/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceCustomization;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceDefinition;
import org.jboss.portal.core.impl.model.instance.JBossInstanceContainerContext;
import org.jboss.portal.core.model.instance.DuplicateInstanceException;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.instance.InstancePermission;
import org.jboss.portal.core.model.instance.NoSuchInstanceException;
import org.jboss.portal.core.model.instance.metadata.InstanceMetaData;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.impl.invocation.PortletInterceptorStack;
import org.jboss.portal.portlet.impl.invocation.PortletInterceptorStackFactory;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.state.DestroyCloneFailure;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalPermissionCollection;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.impl.JBossAuthorizationDomainRegistry;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.PermissionFactory;
import org.jboss.portal.security.spi.provider.PermissionRepository;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceContainerImpl
extends AbstractJBossService
implements InstanceContainer,
AuthorizationDomain,
DomainConfigurator,
PermissionRepository,
PermissionFactory,
Advised {
    protected PortletInterceptorStackFactory stackFactory;
    protected PortletInvoker portletInvoker;
    protected PortalAuthorizationManagerFactory portalAuthorizationManagerFactory;
    protected JBossAuthorizationDomainRegistry authorizationDomainRegistry;
    protected boolean performSecurityChecks = true;
    protected boolean cloneOnCreate = false;
    protected JBossInstanceContainerContext containerContext;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.jboss.portal.core.impl.model.instance.InstanceContainerImpl"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getDefinition7158034184799190936;
    private static WeakReference aop$MethodInfo_createDefinition862581447283271183;
    private static WeakReference aop$MethodInfo_createDefinition_N_3128332771089932650;
    private static WeakReference aop$MethodInfo_createDefinition_N_5101400820916456486;
    private static WeakReference aop$MethodInfo_destroyDefinition_N_3241470021860662167;
    private static WeakReference aop$MethodInfo_getDefinitions8762877803626259730;
    private static WeakReference aop$MethodInfo_invoke_N_8654503705355129869;

    public PortletInterceptorStackFactory getStackFactory() {
        return this.stackFactory;
    }

    public void setStackFactory(PortletInterceptorStackFactory stackFactory) {
        this.stackFactory = stackFactory;
    }

    @Override
    public PortletInvoker getPortletInvoker() {
        return this.portletInvoker;
    }

    public void setPortletInvoker(PortletInvoker portletInvoker) {
        this.portletInvoker = portletInvoker;
    }

    public JBossAuthorizationDomainRegistry getAuthorizationDomainRegistry() {
        return this.authorizationDomainRegistry;
    }

    public void setAuthorizationDomainRegistry(JBossAuthorizationDomainRegistry authorizationDomainRegistry) {
        this.authorizationDomainRegistry = authorizationDomainRegistry;
    }

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.portalAuthorizationManagerFactory;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.portalAuthorizationManagerFactory = portalAuthorizationManagerFactory;
    }

    protected void startService() throws Exception {
        if (this.authorizationDomainRegistry != null) {
            this.authorizationDomainRegistry.addDomain((AuthorizationDomain)this);
        }
        this.containerContext.setContainer(this);
    }

    protected void stopService() throws Exception {
        this.containerContext.setContainer(null);
        if (this.authorizationDomainRegistry != null) {
            this.authorizationDomainRegistry.removeDomain((AuthorizationDomain)this);
        }
    }

    public PortalPermission createPermissionContainer(PortalPermissionCollection collection) throws PortalSecurityException {
        return new InstancePermission(collection);
    }

    public PortalPermission createPermission(String uri, String action) throws PortalSecurityException {
        return new InstancePermission(uri, action);
    }

    public PortalPermission createPermission(String uri, Collection actions) throws PortalSecurityException {
        return new InstancePermission(uri, actions);
    }

    @Override
    public AuthorizationDomain getAuthorizationDomain() {
        return this;
    }

    public boolean getCloneOnCreate() {
        return this.cloneOnCreate;
    }

    public void setCloneOnCreate(boolean cloneOnCreate) {
        this.cloneOnCreate = cloneOnCreate;
    }

    public boolean getPerformSecurityChecks() {
        return this.performSecurityChecks;
    }

    public void setPerformSecurityChecks(boolean performSecurityChecks) {
        this.performSecurityChecks = performSecurityChecks;
    }

    public JBossInstanceContainerContext getContainerContext() {
        return this.containerContext;
    }

    public void setContainerContext(JBossInstanceContainerContext containerContext) {
        this.containerContext = containerContext;
    }

    public InstanceDefinition org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$getDefinition$aop(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        return this.containerContext.getInstanceDefinition(id);
    }

    public InstanceDefinition org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(String id, String portletId) throws DuplicateInstanceException, IllegalArgumentException, PortletInvokerException {
        return this.internalCreateDefinition(id, portletId, this.cloneOnCreate);
    }

    public InstanceDefinition org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(InstanceMetaData instanceMD) throws DuplicateInstanceException, IllegalArgumentException, PortletInvokerException {
        return this.internalCreateDefinition(instanceMD, this.cloneOnCreate);
    }

    public InstanceDefinition org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(String id, String portletId, boolean clone) throws DuplicateInstanceException, PortletInvokerException {
        return this.internalCreateDefinition(id, portletId, clone);
    }

    private InstanceDefinition internalCreateDefinition(String id, String portletId, boolean clone) throws DuplicateInstanceException, PortletInvokerException {
        InstanceMetaData instanceMD = new InstanceMetaData();
        instanceMD.setId(id);
        instanceMD.setPortletRef(portletId);
        return this.internalCreateDefinition(instanceMD, clone);
    }

    private InstanceDefinition internalCreateDefinition(InstanceMetaData instanceMD, boolean clone) throws DuplicateInstanceException, PortletInvokerException {
        if (instanceMD == null) {
            throw new IllegalArgumentException("instanceMD cannot be null");
        }
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Creating instance " + instanceMD.getId() + " of portlet " + instanceMD.getPortletRef()));
        }
        PortletContext portletContext = PortletContext.createPortletContext((String)instanceMD.getPortletRef());
        this.portletInvoker.getPortlet(portletContext);
        AbstractInstanceDefinition instance = this.containerContext.newInstanceDefinition(instanceMD);
        this.containerContext.createInstanceDefinition(instance);
        if (clone) {
            if (debug) {
                this.log.debug((Object)("Cloning instance " + instance.getId() + "/" + portletContext));
            }
            portletContext = this.portletInvoker.createClone(portletContext);
            if (debug) {
                this.log.debug((Object)("Instance " + instance.getId() + " succesfully cloned " + portletContext));
            }
            this.containerContext.updateInstance(instance, portletContext, true);
        }
        return instance;
    }

    public void org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$destroyDefinition$aop(String id) throws PortletInvokerException, NoSuchInstanceException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        AbstractInstanceDefinition definition = this.containerContext.getInstanceDefinition(id);
        if (definition == null) {
            throw new NoSuchInstanceException(id);
        }
        Collection customizations = definition.getCustomizations();
        StringBuffer destroyLog = new StringBuffer("About to destroy portlets for instance=").append(definition.getInstanceId()).append(" [");
        ArrayList<PortletContext> toDestroy = new ArrayList<PortletContext>(customizations.size());
        Iterator i = customizations.iterator();
        while (i.hasNext()) {
            AbstractInstanceCustomization customization = (AbstractInstanceCustomization)i.next();
            PortletContext customizationPortletContext = customization.getPortletContext();
            toDestroy.add(customizationPortletContext);
            destroyLog.append(customizationPortletContext);
            if (!i.hasNext()) continue;
            destroyLog.append(',');
        }
        if (definition.isModifiable()) {
            PortletContext sharedPortletContext = definition.getPortletContext();
            toDestroy.add(sharedPortletContext);
            destroyLog.append(sharedPortletContext);
        }
        destroyLog.append(']');
        this.log.debug((Object)destroyLog);
        List failures = this.portletInvoker.destroyClones(toDestroy);
        if (failures.size() > 0) {
            StringBuffer failureLog = new StringBuffer("Some portlet were not properly destroyed for instance=").append(definition.getInstanceId()).append(" [");
            Iterator i2 = failures.iterator();
            while (i2.hasNext()) {
                DestroyCloneFailure failure = (DestroyCloneFailure)i2.next();
                failureLog.append(failure.getPortletId());
                if (!i2.hasNext()) continue;
                failureLog.append(',');
            }
            failureLog.append(']');
            this.log.debug((Object)failureLog);
        }
        this.containerContext.destroyInstanceDefinition(definition);
    }

    public Collection<InstanceDefinition> org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$getDefinitions$aop() {
        Collection<InstanceDefinition> list = this.containerContext.getInstanceDefinitions();
        if (this.performSecurityChecks) {
            PortalAuthorizationManager mgr = this.portalAuthorizationManagerFactory.getManager();
            Iterator<InstanceDefinition> i = list.iterator();
            while (i.hasNext()) {
                Instance instance = i.next();
                InstancePermission perm = new InstancePermission(instance.getId(), "view");
                if (mgr.checkPermission((PortalPermission)perm)) continue;
                i.remove();
            }
        }
        return list;
    }

    PortletInvocationResponse org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$invoke$aop(PortletInvocation invocation) throws PortletInvokerException {
        PortletInterceptorStack stack = this.stackFactory.getInterceptorStack();
        if (stack.getLength() != 0) {
            try {
                return stack.getInterceptor(0).invoke(invocation);
            }
            catch (Exception e) {
                if (e instanceof PortletInvokerException) {
                    throw (PortletInvokerException)((Object)e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new PortletInvokerException((Throwable)e);
            }
        }
        return this.portletInvoker.invoke(invocation);
    }

    public String getType() {
        return "instance";
    }

    public DomainConfigurator getConfigurator() {
        return this;
    }

    public PermissionRepository getPermissionRepository() {
        return this;
    }

    public PermissionFactory getPermissionFactory() {
        return this;
    }

    public Set getSecurityBindings(String uri) {
        AbstractInstanceDefinition instance = this.containerContext.getInstanceDefinition(uri);
        if (instance != null) {
            return instance.getSecurityBindings();
        }
        return null;
    }

    public void setSecurityBindings(String uri, Set securityBindings) throws SecurityConfigurationException {
        AbstractInstanceDefinition instanceDef = this.containerContext.getInstanceDefinition(uri);
        if (instanceDef == null) {
            throw new SecurityConfigurationException("The object should exist prior its security is configured : fixme");
        }
        HashSet<RoleSecurityBinding> tmp = new HashSet<RoleSecurityBinding>(securityBindings.size());
        for (RoleSecurityBinding sc : securityBindings) {
            if (sc.getActions().size() <= 0) continue;
            tmp.add(sc);
        }
        this.containerContext.updateInstanceDefinition(instanceDef, tmp);
    }

    public void removeSecurityBindings(String uri) throws SecurityConfigurationException {
        this.setSecurityBindings(uri, Collections.EMPTY_SET);
    }

    public PortalPermission getPermission(String roleName, String uri) throws PortalSecurityException {
        Set set = this.getSecurityBindings(uri);
        if (set != null && !set.isEmpty()) {
            for (RoleSecurityBinding sc : set) {
                String constraintRoleName = sc.getRoleName();
                if (!constraintRoleName.equals(roleName) && !SecurityConstants.UNCHECKED_ROLE_NAME.equals(constraintRoleName)) continue;
                return this.createPermission(uri, sc.getActions());
            }
        }
        return null;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        InstanceContainerImpl instanceContainerImpl = this;
        synchronized (instanceContainerImpl) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        InstanceContainerImpl instanceContainerImpl = this;
        synchronized (instanceContainerImpl) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Override
    public InstanceDefinition getDefinition(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getDefinition7158034184799190936.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getDefinition_7158034184799190936 getDefinition_71580341847991909362 = new getDefinition_7158034184799190936(methodInfo, interceptorArray);
            getDefinition_71580341847991909362.arg0 = string;
            getDefinition_71580341847991909362.setTargetObject(this);
            getDefinition_71580341847991909362.typedTargetObject = this;
            getDefinition_71580341847991909362.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InstanceDefinition)getDefinition_71580341847991909362.invokeNext();
        }
        return this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$getDefinition$aop(string);
    }

    @Override
    public InstanceDefinition createDefinition(String string, String string2) throws DuplicateInstanceException, IllegalArgumentException, PortletInvokerException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createDefinition862581447283271183.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createDefinition_862581447283271183 createDefinition_8625814472832711832 = new createDefinition_862581447283271183(methodInfo, interceptorArray);
            createDefinition_8625814472832711832.arg0 = string;
            createDefinition_8625814472832711832.arg1 = string2;
            createDefinition_8625814472832711832.setTargetObject(this);
            createDefinition_8625814472832711832.typedTargetObject = this;
            createDefinition_8625814472832711832.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InstanceDefinition)createDefinition_8625814472832711832.invokeNext();
        }
        return this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(string, string2);
    }

    @Override
    public InstanceDefinition createDefinition(InstanceMetaData instanceMetaData) throws DuplicateInstanceException, IllegalArgumentException, PortletInvokerException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createDefinition_N_3128332771089932650.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createDefinition_N3128332771089932650 createDefinition_N31283327710899326502 = new createDefinition_N3128332771089932650(methodInfo, interceptorArray);
            createDefinition_N31283327710899326502.arg0 = instanceMetaData;
            createDefinition_N31283327710899326502.setTargetObject(this);
            createDefinition_N31283327710899326502.typedTargetObject = this;
            createDefinition_N31283327710899326502.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InstanceDefinition)createDefinition_N31283327710899326502.invokeNext();
        }
        return this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(instanceMetaData);
    }

    @Override
    public InstanceDefinition createDefinition(String string, String string2, boolean bl) throws DuplicateInstanceException, PortletInvokerException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createDefinition_N_5101400820916456486.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createDefinition_N5101400820916456486 createDefinition_N51014008209164564862 = new createDefinition_N5101400820916456486(methodInfo, interceptorArray);
            createDefinition_N51014008209164564862.arg0 = string;
            createDefinition_N51014008209164564862.arg1 = string2;
            createDefinition_N51014008209164564862.arg2 = bl;
            createDefinition_N51014008209164564862.setTargetObject(this);
            createDefinition_N51014008209164564862.typedTargetObject = this;
            createDefinition_N51014008209164564862.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InstanceDefinition)createDefinition_N51014008209164564862.invokeNext();
        }
        return this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(string, string2, bl);
    }

    @Override
    public void destroyDefinition(String string) throws PortletInvokerException, NoSuchInstanceException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_destroyDefinition_N_3241470021860662167.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            destroyDefinition_N3241470021860662167 destroyDefinition_N32414700218606621672 = new destroyDefinition_N3241470021860662167(methodInfo, interceptorArray);
            destroyDefinition_N32414700218606621672.arg0 = string;
            destroyDefinition_N32414700218606621672.setTargetObject(this);
            destroyDefinition_N32414700218606621672.typedTargetObject = this;
            destroyDefinition_N32414700218606621672.setAdvisor((Advisor)aop$classAdvisor$aop);
            destroyDefinition_N32414700218606621672.invokeNext();
        } else {
            this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$destroyDefinition$aop(string);
        }
    }

    public Collection getDefinitions() {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getDefinitions8762877803626259730.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getDefinitions_8762877803626259730 getDefinitions_87628778036262597302 = new getDefinitions_8762877803626259730(methodInfo, interceptorArray);
            getDefinitions_87628778036262597302.setTargetObject(this);
            getDefinitions_87628778036262597302.typedTargetObject = this;
            getDefinitions_87628778036262597302.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Collection)getDefinitions_87628778036262597302.invokeNext();
        }
        return this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$getDefinitions$aop();
    }

    PortletInvocationResponse invoke(PortletInvocation portletInvocation) throws PortletInvokerException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_invoke_N_8654503705355129869.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            invoke_N8654503705355129869 invoke_N86545037053551298692 = new invoke_N8654503705355129869(methodInfo, interceptorArray);
            invoke_N86545037053551298692.arg0 = portletInvocation;
            invoke_N86545037053551298692.setTargetObject(this);
            invoke_N86545037053551298692.typedTargetObject = this;
            invoke_N86545037053551298692.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (PortletInvocationResponse)invoke_N86545037053551298692.invokeNext();
        }
        return this.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$invoke$aop(portletInvocation);
    }

    public static class getDefinition_7158034184799190936
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public InstanceContainerImpl typedTargetObject;

        public getDefinition_7158034184799190936(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getDefinition_7158034184799190936(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getDefinition_7158034184799190936(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getDefinition_7158034184799190936() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$getDefinition$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getDefinition_7158034184799190936 getDefinition_71580341847991909362 = new getDefinition_7158034184799190936(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getDefinition_71580341847991909362.arguments = this.arguments;
            ((InvocationBase)getDefinition_71580341847991909362).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getDefinition_71580341847991909362).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getDefinition_71580341847991909362).instanceResolver = ((InvocationBase)this).instanceResolver;
            getDefinition_71580341847991909362.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getDefinition_71580341847991909362).targetObject = ((InvocationBase)this).targetObject;
            getDefinition_71580341847991909362.arg0 = this.arg0;
            return getDefinition_71580341847991909362;
        }
    }

    public static class createDefinition_862581447283271183
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public InstanceContainerImpl typedTargetObject;

        public createDefinition_862581447283271183(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createDefinition_862581447283271183(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createDefinition_862581447283271183(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createDefinition_862581447283271183() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            createDefinition_862581447283271183 createDefinition_8625814472832711832 = new createDefinition_862581447283271183(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createDefinition_8625814472832711832.arguments = this.arguments;
            ((InvocationBase)createDefinition_8625814472832711832).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createDefinition_8625814472832711832).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createDefinition_8625814472832711832).instanceResolver = ((InvocationBase)this).instanceResolver;
            createDefinition_8625814472832711832.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createDefinition_8625814472832711832).targetObject = ((InvocationBase)this).targetObject;
            createDefinition_8625814472832711832.arg0 = this.arg0;
            createDefinition_8625814472832711832.arg1 = this.arg1;
            return createDefinition_8625814472832711832;
        }
    }

    public static class createDefinition_N3128332771089932650
    extends MethodInvocation
    implements Untransformable {
        public InstanceMetaData arg0;
        public InstanceContainerImpl typedTargetObject;

        public createDefinition_N3128332771089932650(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createDefinition_N3128332771089932650(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createDefinition_N3128332771089932650(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createDefinition_N3128332771089932650() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (InstanceMetaData)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            createDefinition_N3128332771089932650 createDefinition_N31283327710899326502 = new createDefinition_N3128332771089932650(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createDefinition_N31283327710899326502.arguments = this.arguments;
            ((InvocationBase)createDefinition_N31283327710899326502).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createDefinition_N31283327710899326502).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createDefinition_N31283327710899326502).instanceResolver = ((InvocationBase)this).instanceResolver;
            createDefinition_N31283327710899326502.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createDefinition_N31283327710899326502).targetObject = ((InvocationBase)this).targetObject;
            createDefinition_N31283327710899326502.arg0 = this.arg0;
            return createDefinition_N31283327710899326502;
        }
    }

    public static class createDefinition_N5101400820916456486
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public boolean arg2;
        public InstanceContainerImpl typedTargetObject;

        public createDefinition_N5101400820916456486(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createDefinition_N5101400820916456486(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createDefinition_N5101400820916456486(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createDefinition_N5101400820916456486() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$createDefinition$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
            this.arg2 = (Boolean)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Boolean(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            createDefinition_N5101400820916456486 createDefinition_N51014008209164564862 = new createDefinition_N5101400820916456486(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createDefinition_N51014008209164564862.arguments = this.arguments;
            ((InvocationBase)createDefinition_N51014008209164564862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createDefinition_N51014008209164564862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createDefinition_N51014008209164564862).instanceResolver = ((InvocationBase)this).instanceResolver;
            createDefinition_N51014008209164564862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createDefinition_N51014008209164564862).targetObject = ((InvocationBase)this).targetObject;
            createDefinition_N51014008209164564862.arg0 = this.arg0;
            createDefinition_N51014008209164564862.arg1 = this.arg1;
            createDefinition_N51014008209164564862.arg2 = this.arg2;
            return createDefinition_N51014008209164564862;
        }
    }

    public static class destroyDefinition_N3241470021860662167
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public InstanceContainerImpl typedTargetObject;

        public destroyDefinition_N3241470021860662167(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public destroyDefinition_N3241470021860662167(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public destroyDefinition_N3241470021860662167(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public destroyDefinition_N3241470021860662167() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$destroyDefinition$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            destroyDefinition_N3241470021860662167 destroyDefinition_N32414700218606621672 = new destroyDefinition_N3241470021860662167(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            destroyDefinition_N32414700218606621672.arguments = this.arguments;
            ((InvocationBase)destroyDefinition_N32414700218606621672).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)destroyDefinition_N32414700218606621672).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)destroyDefinition_N32414700218606621672).instanceResolver = ((InvocationBase)this).instanceResolver;
            destroyDefinition_N32414700218606621672.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)destroyDefinition_N32414700218606621672).targetObject = ((InvocationBase)this).targetObject;
            destroyDefinition_N32414700218606621672.arg0 = this.arg0;
            return destroyDefinition_N32414700218606621672;
        }
    }

    public static class getDefinitions_8762877803626259730
    extends MethodInvocation
    implements Untransformable {
        public InstanceContainerImpl typedTargetObject;

        public getDefinitions_8762877803626259730(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getDefinitions_8762877803626259730(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getDefinitions_8762877803626259730(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getDefinitions_8762877803626259730() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$getDefinitions$aop();
        }

        public Invocation copy() {
            getDefinitions_8762877803626259730 getDefinitions_87628778036262597302 = new getDefinitions_8762877803626259730(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getDefinitions_87628778036262597302.arguments = this.arguments;
            ((InvocationBase)getDefinitions_87628778036262597302).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getDefinitions_87628778036262597302).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getDefinitions_87628778036262597302).instanceResolver = ((InvocationBase)this).instanceResolver;
            getDefinitions_87628778036262597302.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getDefinitions_87628778036262597302).targetObject = ((InvocationBase)this).targetObject;
            return getDefinitions_87628778036262597302;
        }
    }

    public static class invoke_N8654503705355129869
    extends MethodInvocation
    implements Untransformable {
        public PortletInvocation arg0;
        public InstanceContainerImpl typedTargetObject;

        public invoke_N8654503705355129869(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public invoke_N8654503705355129869(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public invoke_N8654503705355129869(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public invoke_N8654503705355129869() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$portal$core$impl$model$instance$InstanceContainerImpl$invoke$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (PortletInvocation)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            invoke_N8654503705355129869 invoke_N86545037053551298692 = new invoke_N8654503705355129869(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            invoke_N86545037053551298692.arguments = this.arguments;
            ((InvocationBase)invoke_N86545037053551298692).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)invoke_N86545037053551298692).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)invoke_N86545037053551298692).instanceResolver = ((InvocationBase)this).instanceResolver;
            invoke_N86545037053551298692.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)invoke_N86545037053551298692).targetObject = ((InvocationBase)this).targetObject;
            invoke_N86545037053551298692.arg0 = this.arg0;
            return invoke_N86545037053551298692;
        }
    }
}

