/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.portal.core.impl.model.portal.AbstractPortalObjectContainer;
import org.jboss.portal.core.impl.model.portal.ObjectNodeSecurityConstraint;
import org.jboss.portal.core.impl.model.portal.PortalObjectImpl;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.NoSuchPortalObjectException;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.jems.hibernate.ContextObject;
import org.jboss.portal.security.RoleSecurityBinding;

public class ObjectNode
implements ContextObject {
    protected static final Logger log = Logger.getLogger(ObjectNode.class);
    protected static final boolean trace = log.isTraceEnabled();
    private Long key;
    private PortalObjectId path;
    private String name;
    private ObjectNode parent;
    private Map children;
    private PortalObjectImpl object;
    private Map<String, ObjectNodeSecurityConstraint> securityConstraints;
    private AbstractPortalObjectContainer.ContainerContext containerContext;
    private static final String DASHBOARD = "dashboard";

    public ObjectNode() {
        this.containerContext = null;
        this.path = null;
        this.name = null;
        this.children = null;
        this.securityConstraints = null;
    }

    public ObjectNode(AbstractPortalObjectContainer.ContainerContext containerContext, PortalObjectId path, String name) {
        if (containerContext == null) {
            throw new IllegalArgumentException("No context provided");
        }
        this.containerContext = containerContext;
        this.path = path;
        this.name = name;
        this.children = new HashMap();
        this.securityConstraints = new HashMap<String, ObjectNodeSecurityConstraint>();
    }

    public void setContext(Object context) {
        this.containerContext = (AbstractPortalObjectContainer.ContainerContext)context;
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public PortalObjectImpl getObject() {
        return this.object;
    }

    public void setObject(PortalObjectImpl object) {
        this.object = object;
    }

    void addChild(String name, PortalObjectImpl childObject) throws DuplicatePortalObjectException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("No name with null value accepted");
        }
        if (childObject == null) {
            throw new IllegalArgumentException("No null child accepted");
        }
        if (this.children.containsKey(name)) {
            throw new DuplicatePortalObjectException("Object " + this.path + " has already a child with the name " + name);
        }
        PortalObjectId childPath = this.toChildPath(name);
        log.debug((Object)("Creating child of path='" + this.path + "' with path='" + childPath + "'"));
        ObjectNode childNode = new ObjectNode(this.containerContext, childPath, name);
        childNode.setObject(childObject);
        childObject.setObjectNode(childNode);
        this.containerContext.createChild(childNode);
        this.children.put(name, childNode);
        childNode.parent = this;
        if (childObject instanceof ContextObject) {
            ContextObject co = (ContextObject)childObject;
            co.setContext((Object)this.containerContext);
        }
    }

    void removeChild(String name) throws NoSuchPortalObjectException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        log.debug((Object)("Removing child of '" + this.path + "' with name '" + name + "'"));
        ObjectNode child = (ObjectNode)this.children.get(name);
        if (child == null) {
            throw new NoSuchPortalObjectException("Child " + name + " of " + this.path + " does not exist");
        }
        for (String childName : new ArrayList(child.getChildren().keySet())) {
            child.removeChild(childName);
        }
        child.getObject().destroy();
        this.containerContext.destroyChild(child);
        this.children.remove(name);
        child.setParent(null);
    }

    public PortalObjectId getPath() {
        return this.path;
    }

    public void setPath(PortalObjectId path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ObjectNode getParent() {
        return this.parent;
    }

    public void setParent(ObjectNode parent) {
        this.parent = parent;
    }

    public Map getChildren() {
        return this.children;
    }

    public void setChildren(Map children) {
        this.children = children;
    }

    public AbstractPortalObjectContainer.ContainerContext getContext() {
        return this.containerContext;
    }

    public String toString() {
        return "PortalObject[id=" + this.path + "]";
    }

    protected PortalObjectId toChildPath(String name) {
        return new PortalObjectId(this.path.getNamespace(), this.path.getPath().getChild(name));
    }

    public Map getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setSecurityConstraints(Map securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    public void setBindings(Set bindings) {
        for (ObjectNodeSecurityConstraint onsc : this.securityConstraints.values()) {
            onsc.setObjectNode(null);
        }
        this.securityConstraints.clear();
        for (ObjectNodeSecurityConstraint binding : bindings) {
            RoleSecurityBinding sc = (RoleSecurityBinding)binding;
            if (sc.getActions().size() <= 0) continue;
            ObjectNodeSecurityConstraint onsc = new ObjectNodeSecurityConstraint(sc.getActions(), sc.getRoleName());
            onsc.setObjectNode(this);
            this.securityConstraints.put(onsc.getRole(), onsc);
        }
        this.containerContext.updated(this);
    }

    public Set getBindings() {
        HashSet<RoleSecurityBinding> bindings = new HashSet<RoleSecurityBinding>();
        for (ObjectNodeSecurityConstraint onsc : this.securityConstraints.values()) {
            Set actions = onsc.getActions();
            RoleSecurityBinding sc = new RoleSecurityBinding(actions, onsc.getRole());
            bindings.add(sc);
        }
        return bindings;
    }

    public RoleSecurityBinding getBinding(String roleName) {
        Set<String> actions = null;
        ObjectNodeSecurityConstraint onsc = this.securityConstraints.get(roleName);
        if (onsc != null) {
            actions = onsc.getActions();
        }
        if (DASHBOARD.equals(this.path.getNamespace())) {
            if (actions == null) {
                actions = Collections.singleton(DASHBOARD);
            } else {
                actions = new HashSet<String>(actions);
                actions.add(DASHBOARD);
            }
        }
        if (actions != null) {
            return new RoleSecurityBinding(actions, roleName);
        }
        return null;
    }
}

