/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.state;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.core.impl.portlet.state.PersistentConsumerGroup;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerCapabilities;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.DuplicateRegistrationException;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationStatus;
import org.jboss.portal.registration.impl.ConsumerCapabilitiesImpl;

public class PersistentConsumer
implements Consumer {
    private Long key = null;
    private String persistentId;
    private String persistentName;
    private RegistrationStatus persistentStatus;
    private String persistentAgent;
    private Set relatedRegistrations;
    private PersistentConsumerGroup relatedGroup;
    private ConsumerCapabilities capabilities = new ConsumerCapabilitiesImpl();

    public PersistentConsumer(String id, String name) {
        this.persistentId = id;
        this.persistentName = name;
        this.persistentStatus = RegistrationStatus.PENDING;
        this.relatedRegistrations = new HashSet();
        this.relatedGroup = null;
        this.persistentAgent = null;
    }

    PersistentConsumer() {
        this.persistentId = null;
        this.persistentName = null;
        this.persistentStatus = null;
        this.relatedRegistrations = null;
        this.relatedGroup = null;
        this.persistentAgent = null;
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public String getPersistentName() {
        return this.persistentName;
    }

    public void setPersistentName(String persistentName) {
        this.persistentName = persistentName;
    }

    public RegistrationStatus getPersistentStatus() {
        return this.persistentStatus;
    }

    public void setPersistentStatus(RegistrationStatus persistentStatus) {
        this.persistentStatus = persistentStatus;
    }

    public String getPersistentAgent() {
        return this.persistentAgent;
    }

    public void setPersistentAgent(String persistentAgent) {
        this.persistentAgent = persistentAgent;
    }

    public Set getRelatedRegistrations() {
        return this.relatedRegistrations;
    }

    public void setRelatedRegistrations(Set relatedRegistrations) {
        this.relatedRegistrations = relatedRegistrations;
    }

    public PersistentConsumerGroup getRelatedGroup() {
        return this.relatedGroup;
    }

    public void setRelatedGroup(PersistentConsumerGroup relatedGroup) {
        this.relatedGroup = relatedGroup;
    }

    public String getName() {
        return this.persistentName;
    }

    public RegistrationStatus getStatus() {
        return this.persistentStatus;
    }

    public void setStatus(RegistrationStatus status) {
        this.persistentStatus = status;
    }

    public Collection getRegistrations() throws RegistrationException {
        return Collections.unmodifiableSet(this.relatedRegistrations);
    }

    public ConsumerGroup getGroup() {
        return this.relatedGroup;
    }

    public String getId() {
        return this.persistentId;
    }

    public ConsumerCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(ConsumerCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void setGroup(ConsumerGroup group) throws RegistrationException, DuplicateRegistrationException {
        if (this.relatedGroup != null) {
            this.relatedGroup.removeConsumer(this);
        }
        if (group != null) {
            group.addConsumer((Consumer)this);
        }
    }

    public String getConsumerAgent() {
        return this.persistentAgent;
    }

    public void setConsumerAgent(String consumerAgent) throws IllegalArgumentException, IllegalStateException {
        this.persistentAgent = consumerAgent;
    }
}

