/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.util;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ProxyValidator {
    private static final Set acceptedClasses = new HashSet();
    public static final int METHOD_NOT_ACCESSOR = 0;
    public static final int GETTER_INVALID_NAME = 1;
    public static final int GETTER_DUPLICATE_NAME = 2;
    public static final int GETTER_INVALID_RETURN_TYPE = 3;
    public static final int GETTER_NO_ARGUMENT = 4;
    public static final int GETTER_TOO_MANY_ARGUMENTS = 5;
    public static final int GETTER_RETURN_TYPE_DOES_NOT_MATCH_ARGUMENT_TYPE = 6;
    public static final int SETTER_DUPLICATE_NAME = 7;
    public static final int SETTER_INVALID_NAME = 8;
    public static final int SETTER_NO_ARGUMENT = 9;
    public static final int SETTER_TOO_MANY_ARGUMENTS = 10;
    public static final int SETTER_RETURN_TYPE_IS_NOT_VOID = 11;
    public static final int SETTER_INVALID_ARGUMENT_TYPE = 12;
    private static final String[] DESCRIPTIONS;

    public static Error[] validate(Class itf) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Method[] methods = itf.getMethods();
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> setters = new HashSet<String>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                if (methodName.substring(3).length() == 0) {
                    errors.add(new Error(1, method));
                }
                if (getters.contains(methodName.substring(3))) {
                    errors.add(new Error(2, method));
                }
                if (!acceptedClasses.contains(method.getReturnType())) {
                    errors.add(new Error(3, method));
                }
                if (method.getParameterTypes().length == 0) {
                    errors.add(new Error(4, method));
                } else if (method.getParameterTypes().length > 1) {
                    errors.add(new Error(5, method));
                } else if (!method.getReturnType().equals(method.getParameterTypes()[0])) {
                    errors.add(new Error(6, method));
                }
                getters.add(methodName.substring(3));
                continue;
            }
            if (methodName.startsWith("set")) {
                if (method.getParameterTypes().length == 0) {
                    errors.add(new Error(9, method));
                } else if (method.getParameterTypes().length > 1) {
                    errors.add(new Error(10, method));
                } else if (!acceptedClasses.contains(method.getParameterTypes()[0])) {
                    errors.add(new Error(12, method));
                }
                if (methodName.substring(3).length() == 0) {
                    errors.add(new Error(8, method));
                }
                if (setters.contains(methodName.substring(3))) {
                    errors.add(new Error(7, method));
                }
                if (!method.getReturnType().equals(Void.TYPE)) {
                    errors.add(new Error(11, method));
                }
                setters.add(methodName.substring(3));
                continue;
            }
            errors.add(new Error(0, method));
        }
        return errors.toArray(new Error[errors.size()]);
    }

    static {
        acceptedClasses.add(String.class);
        acceptedClasses.add(Integer.TYPE);
        acceptedClasses.add(Boolean.TYPE);
        acceptedClasses.add(String[].class);
        acceptedClasses.add(int[].class);
        acceptedClasses.add(boolean[].class);
        DESCRIPTIONS = new String[]{"Method {0} is not an accessor", "Name {1} is not valid", "Name {1} is duplicated", "Method {0} has an invalid return type", "Method {0} has no argument", "Method {0} has too many arguments", "Method {0} does not have a return type matching the argument type", "Name {1} is duplicated", "Name {1} is not valid", "Method {0} has no argument", "Method {0} has too many arguments", "Method {0} has return type which is not void", "Method {0} has an invalid argument type"};
    }

    public static class Error {
        private int code;
        private Method method;
        private String desc;

        public Error(int code, Method method) {
            this.code = code;
            this.method = method;
            this.desc = MessageFormat.format(DESCRIPTIONS[code], method, method.getName());
        }

        public int getCode() {
            return this.code;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.desc;
        }
    }
}

