/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.security.config.annotation.AlreadyBuiltException;
import org.springframework.security.config.annotation.SecurityBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecurityBuilder<O>
implements SecurityBuilder<O> {
    private AtomicBoolean building = new AtomicBoolean();
    private O object;

    @Override
    public final O build() throws Exception {
        if (this.building.compareAndSet(false, true)) {
            this.object = this.doBuild();
            return this.object;
        }
        throw new AlreadyBuiltException("This object has already been built");
    }

    public final O getObject() {
        if (!this.building.get()) {
            throw new IllegalStateException("This object has not been built");
        }
        return this.object;
    }

    protected abstract O doBuild() throws Exception;
}

