/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.security;

import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.model.portal.navstate.PortalObjectNavigationalStateContext;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.server.ServerInvocation;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.tracker.RequestContextUtil;

public class CmsPermissionHelper {
    public static final String ATTR_TOOLBAR_CMS_VERSION = "osivia.toolbar.cmsVersion";
    public static final String ATTR_TOOLBAR_CMS_EDITION_MODE = "osivia.toolbar.cmsEditionMode";
    public static final String CMS_VERSION_PREVIEW = "preview";
    public static final String CMS_VERSION_ONLINE = "online";
    public static final String CMS_VERSION_LIVE = "live";
    public static final String CMS_EDITION_MODE_ON = "1";
    public static final String CMS_EDITION_MODE_OFF = "0";
    private static final String CURRENT_PAGE_SECURITY_LEVEL = "osivia.currentPageSecurityLevel";
    private static final String LAST_ALLOWED_PAGE = "osivia.lastAllowedPage";
    private static final String WARNING_MESSAGE_PREVIEW_VERSION_ONLY = "WARNING_MESSAGE_PREVIEW_VERSION_ONLY";
    private static final String WARNING_MESSAGE_ONLINE_VERSION_ONLY = "WARNING_MESSAGE_ONLINE_VERSION_ONLY";
    private static final String ERROR_MESSAGE_ACCESS_DENIED = "ERROR_MESSAGE_ACCESS_DENIED";
    private static ICMSServiceLocator icmsServiceLocactor = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private static IInternationalizationService itlzService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
    private static INotificationsService notifService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");

    public static void clearCache(ControllerContext controllerContext) {
        Set keys = controllerContext.getAttributeResolver(ControllerCommand.REQUEST_SCOPE).getKeys();
        for (Object key : keys) {
            if (!key.toString().startsWith(CURRENT_PAGE_SECURITY_LEVEL)) continue;
            controllerContext.getAttributeResolver(ControllerCommand.REQUEST_SCOPE).setAttribute(key, null);
        }
    }

    public static Level getCurrentPageSecurityLevel(InvocationContext ctx, PortalObjectId poid) throws CMSException {
        PageNavigationalState pageState;
        PortalObjectPath pagePath = poid.getPath();
        ServerInvocation invocation = RequestContextUtil.getServerInvocation();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        if (ctx instanceof ControllerContext) {
            NavigationalStateContext nsContext = (NavigationalStateContext)ctx.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
            pageState = nsContext.getPageNavigationalState(poid.toString());
            cmsContext.setControllerContext((ControllerContext)ctx);
        } else {
            PortalObjectNavigationalStateContext pnsCtx = new PortalObjectNavigationalStateContext(invocation.getContext().getAttributeResolver(ControllerCommand.PRINCIPAL_SCOPE));
            pageState = pnsCtx.getPageNavigationalState(pagePath.toString());
            cmsContext.setServerInvocation(invocation);
        }
        String cmsPath = null;
        String[] sPath = null;
        if (pageState != null && (sPath = pageState.getParameter(new QName("", "osivia.cms.contentPath"))) != null && sPath.length == 1) {
            cmsPath = sPath[0];
        }
        return CmsPermissionHelper.getCurrentPageSecurityLevel(ctx, cmsPath);
    }

    public static Level getCurrentPageSecurityLevel(InvocationContext ctx, String cmsPath) throws CMSException {
        Locale locale;
        Level level = null;
        Boolean editableByUser = Boolean.FALSE;
        Boolean published = Boolean.TRUE;
        Boolean belongToPublishSpace = Boolean.TRUE;
        String cmsVersion = CmsPermissionHelper.getCurrentCmsVersion(ctx);
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        if (ctx instanceof ControllerContext) {
            cmsContext.setControllerContext((ControllerContext)ctx);
            locale = ((ControllerContext)ctx).getServerInvocation().getRequest().getLocale();
        } else {
            cmsContext.setServerInvocation(RequestContextUtil.getServerInvocation());
            locale = RequestContextUtil.getServerInvocation().getRequest().getLocale();
        }
        if (cmsPath != null) {
            Object attribute = ctx.getAttribute(ControllerCommand.REQUEST_SCOPE, (Object)CURRENT_PAGE_SECURITY_LEVEL.concat(cmsPath));
            if (attribute != null) {
                level = (Level)((Object)attribute);
            } else {
                String liveEditionPath = (String)ctx.getAttribute(Scope.REQUEST_SCOPE, (Object)"osivia.cms.liveDocument");
                cmsContext.setForcedLivePath(liveEditionPath);
                CMSPublicationInfos pubInfos = null;
                pubInfos = icmsServiceLocactor.getCMSService().getPublicationInfos(cmsContext, cmsPath);
                if (!pubInfos.isPublished()) {
                    cmsContext.setDisplayLiveVersion(CMS_EDITION_MODE_ON);
                }
                boolean isWebPage = icmsServiceLocactor.getCMSService().isCmsWebPage(cmsContext, cmsPath);
                editableByUser = pubInfos.isEditableByUser();
                published = pubInfos.isPublished();
                belongToPublishSpace = pubInfos.getPublishSpacePath() != null;
                if (!isWebPage) {
                    level = Level.notAWebPage;
                    return level;
                }
                if (pubInfos.getPublishSpacePath() != null && !pubInfos.isLiveSpace() && (pubInfos.getDocumentPath().equals(liveEditionPath) || pubInfos.getLiveId().equals(liveEditionPath))) {
                    cmsVersion = CMS_VERSION_PREVIEW;
                }
                level = CmsPermissionHelper.definePermissions(ctx, locale, editableByUser, published, cmsVersion, belongToPublishSpace);
                ctx.setAttribute(ControllerCommand.REQUEST_SCOPE, (Object)CURRENT_PAGE_SECURITY_LEVEL.concat(cmsPath), (Object)level);
                if (level != Level.deny) {
                    ctx.setAttribute(ControllerCommand.SESSION_SCOPE, (Object)LAST_ALLOWED_PAGE, (Object)cmsPath);
                }
            }
        }
        return level;
    }

    private static Level definePermissions(InvocationContext ctx, Locale locale, Boolean editableByUser, Boolean published, String cmsVersion, Boolean belongToPublishSpace) {
        Level level;
        if (cmsVersion.equals(CMS_VERSION_ONLINE)) {
            if (published.booleanValue()) {
                level = Level.allowOnlineVersion;
            } else if (!belongToPublishSpace.booleanValue()) {
                level = Level.allowPreviewVersion;
            } else if (editableByUser.booleanValue()) {
                level = Level.deny;
                PortalControllerContext pcc = new PortalControllerContext((Object)ctx);
                String message = itlzService.getString(WARNING_MESSAGE_PREVIEW_VERSION_ONLY, locale, new Object[0]);
                notifService.addSimpleNotification(pcc, message, NotificationsType.ERROR);
            } else {
                level = Level.deny;
                PortalControllerContext pcc = new PortalControllerContext((Object)ctx);
                String message = itlzService.getString(ERROR_MESSAGE_ACCESS_DENIED, locale, new Object[0]);
                notifService.addSimpleNotification(pcc, message, NotificationsType.ERROR);
            }
        } else if (cmsVersion.equals(CMS_VERSION_LIVE)) {
            level = Level.allowPreviewVersion;
        } else if (editableByUser.booleanValue()) {
            level = Level.allowPreviewVersion;
        } else if (published.booleanValue()) {
            level = Level.deny;
            PortalControllerContext pcc = new PortalControllerContext((Object)ctx);
            String message = itlzService.getString(WARNING_MESSAGE_ONLINE_VERSION_ONLY, locale, new Object[0]);
            notifService.addSimpleNotification(pcc, message, NotificationsType.ERROR);
        } else {
            level = Level.deny;
            PortalControllerContext pcc = new PortalControllerContext((Object)ctx);
            String message = itlzService.getString(ERROR_MESSAGE_ACCESS_DENIED, locale, new Object[0]);
            notifService.addSimpleNotification(pcc, message, NotificationsType.ERROR);
        }
        return level;
    }

    public static String getCurrentCmsVersion(InvocationContext context) {
        String cmsVersion = (String)context.getAttribute(ControllerCommand.SESSION_SCOPE, (Object)ATTR_TOOLBAR_CMS_VERSION);
        if (cmsVersion == null) {
            cmsVersion = CMS_VERSION_ONLINE;
            context.setAttribute(ControllerCommand.SESSION_SCOPE, (Object)ATTR_TOOLBAR_CMS_VERSION, (Object)cmsVersion);
        }
        return cmsVersion;
    }

    public static String getCurrentCmsEditionMode(InvocationContext context) {
        String cmsEditionMode = (String)context.getAttribute(ControllerCommand.SESSION_SCOPE, (Object)ATTR_TOOLBAR_CMS_EDITION_MODE);
        if (cmsEditionMode == null) {
            cmsEditionMode = CMS_EDITION_MODE_ON;
            context.setAttribute(ControllerCommand.SESSION_SCOPE, (Object)ATTR_TOOLBAR_CMS_EDITION_MODE, (Object)cmsEditionMode);
        }
        return cmsEditionMode;
    }

    public static void changeCmsMode(InvocationContext context, String pagePath, String version, String editionMode) {
        context.setAttribute(ControllerCommand.SESSION_SCOPE, (Object)ATTR_TOOLBAR_CMS_VERSION, (Object)version);
        context.setAttribute(ControllerCommand.SESSION_SCOPE, (Object)ATTR_TOOLBAR_CMS_EDITION_MODE, (Object)editionMode);
        context.removeAttribute(ControllerCommand.REQUEST_SCOPE, (Object)CURRENT_PAGE_SECURITY_LEVEL.concat(pagePath));
    }

    public static String getLastAllowedPage(InvocationContext context) {
        String lastAllowedPage = (String)context.getAttribute(ControllerCommand.SESSION_SCOPE, (Object)LAST_ALLOWED_PAGE);
        if (lastAllowedPage == null) {
            // empty if block
        }
        return lastAllowedPage;
    }

    public static enum Level {
        deny,
        allowOnlineVersion,
        allowPreviewVersion,
        notAWebPage;

    }
}

