/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.theming;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.jboss.portal.theme.Orientation;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.osivia.portal.core.theming.IRegionRendererContext;

public class RegionRendererContextImpl
implements IRegionRendererContext {
    private final RegionRendererContext region;
    private final String name;
    private final String cssId;
    private final Boolean cms;
    private final Orientation orientation;

    public RegionRendererContextImpl(RegionRendererContext region, String name, String cssId, Boolean cms, Orientation orientation) {
        this.region = region;
        this.name = name;
        this.cssId = cssId;
        this.cms = cms;
        this.orientation = orientation;
    }

    public String getId() {
        if (this.region == null) {
            return this.name;
        }
        return this.region.getId();
    }

    public Collection<?> getWindows() {
        if (this.region == null) {
            return CollectionUtils.EMPTY_COLLECTION;
        }
        for (Object window : this.region.getWindows()) {
            if (!(window instanceof WindowContext)) continue;
            WindowContext w = (WindowContext)window;
            w.setRegionCms(this.cms);
        }
        return this.region.getWindows();
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.DEFAULT;
        }
        return this.orientation;
    }

    public String getCSSId() {
        return this.cssId;
    }

    public String getProperty(String name) {
        if (this.region == null) {
            return null;
        }
        return this.region.getProperty(name);
    }

    public Map<?, ?> getProperties() {
        if (this.region == null) {
            return MapUtils.EMPTY_MAP;
        }
        return this.region.getProperties();
    }

    @Override
    public boolean isCMS() {
        return BooleanUtils.isTrue((Boolean)this.cms);
    }
}

