/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.component.portlet;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.faces.component.portlet.UIPortlet;
import org.jboss.portal.portlet.spi.PortalContext;

public class JSFPortalContext
implements PortalContext {
    private static final Set defaultModes = Collections.unmodifiableSet(Tools.toSet((Object[])new Mode[]{Mode.VIEW, Mode.EDIT, Mode.HELP}));
    private static final Set defaultWindowStates = Collections.unmodifiableSet(Tools.toSet((Object[])new WindowState[]{WindowState.NORMAL, WindowState.MINIMIZED, WindowState.MAXIMIZED}));
    private final FacesContext faces;
    private final UIPortlet portlet;
    private Set modes;
    private Set windowStates;

    public JSFPortalContext(FacesContext faces, UIPortlet portlet) {
        this.faces = faces;
        this.portlet = portlet;
    }

    public String getInfo() {
        return "JSF/1.0";
    }

    public Set getWindowStates() {
        if (this.windowStates == null) {
            Set tmp = this.portlet.getSupportedWindowStates();
            if (tmp != null) {
                this.windowStates = new HashSet(tmp.size());
                for (String windowStateName : tmp) {
                    WindowState windowState = WindowState.create((String)windowStateName);
                    this.windowStates.add(windowState);
                }
            } else {
                this.windowStates = defaultWindowStates;
            }
        }
        return this.windowStates;
    }

    public Set getModes() {
        if (this.modes == null) {
            Set tmp = this.portlet.getSupportedModes();
            if (tmp != null) {
                this.modes = new HashSet(tmp.size());
                for (String modeName : tmp) {
                    Mode windowState = Mode.create((String)modeName);
                    this.modes.add(windowState);
                }
            } else {
                this.modes = defaultModes;
            }
        }
        return this.modes;
    }

    public Map getProperties() {
        return Collections.EMPTY_MAP;
    }
}

