/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.config.factories;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.samples.config.factories.FactoryConfigSample;
import org.jboss.remoting.security.SSLServerSocketFactoryService;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketFactoryService;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.w3c.dom.Document;

public class FactoryConfigSSLSample
extends TestCase {
    private static Logger log = Logger.getLogger((Class)FactoryConfigSSLSample.class);

    public void testFactoriesByPassingMBeanInXml() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("force_remote", "true");
            ServerSocketFactory service = this.getDefaultServerSocketFactory();
            String serverSocketFactoryName = "jboss:type=serversocketfactory";
            ObjectName objName = new ObjectName(serverSocketFactoryName);
            MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
            mbeanServer.registerMBean(service, objName);
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(sconfig);
            mbeanServer.registerMBean(connector, new ObjectName("test:type=connector"));
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\"?>\n");
            buf.append("<config>");
            buf.append("<invoker transport=\"" + this.getTransport() + "\">");
            buf.append("<attribute name=\"serverBindAddress\">" + this.getHostName() + "</attribute>");
            buf.append("<attribute name=\"serverBindPort\">" + freeport + "</attribute>");
            buf.append("<attribute name=\"serverSocketFactory\">");
            buf.append(serverSocketFactoryName);
            buf.append("</attribute>");
            buf.append("</invoker>");
            buf.append("</config>");
            ByteArrayInputStream bais = new ByteArrayInputStream(buf.toString().getBytes());
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            connector.setConfiguration(xml.getDocumentElement());
            connector.create();
            connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            SocketFactory sf = this.getDefaultSocketFactory();
            client.setSocketFactory(sf);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
            ServerSocketFactory ssf = this.getDefaultCallbackServerSocketFactory();
            callbackConnector.setServerSocketFactory(ssf);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            callbackConnector.start();
            FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error((Object)t);
            t.printStackTrace();
            FactoryConfigSSLSample.fail();
        }
    }

    public void testFactoriesByPassingMBeanInConfig() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            ServerSocketFactory service = this.getDefaultServerSocketFactory();
            String serverSocketFactoryName = "jboss:type=serversocketfactory";
            ObjectName objName = new ObjectName(serverSocketFactoryName);
            MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
            mbeanServer.registerMBean(service, objName);
            sconfig.put("serverSocketFactory", serverSocketFactoryName);
            sconfig.put("force_remote", "true");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            mbeanServer.registerMBean(connector, new ObjectName("test:type=connector"));
            connector.create();
            connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            SocketFactory sf = this.getDefaultSocketFactory();
            client.setSocketFactory(sf);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
            ServerSocketFactory ssf = this.getDefaultCallbackServerSocketFactory();
            callbackConnector.setServerSocketFactory(ssf);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            callbackConnector.start();
            FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error((Object)t);
            t.printStackTrace();
            FactoryConfigSSLSample.fail();
        }
    }

    public void testFactoriesFromSSLParameters() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("force_remote", "true");
            sconfig.put("org.jboss.remoting.serversocket.useClientMode", "false");
            sconfig.put("org.jboss.remoting.keyStoreType", "JKS");
            String keyStoreFilePath = this.getKeystoreFilePath();
            sconfig.put("org.jboss.remoting.keyStore", keyStoreFilePath);
            sconfig.put("org.jboss.remoting.keyStorePassword", "unit-tests-server");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            connector.create();
            connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            cconfig.put("org.jboss.remoting.socket.useClientMode", "true");
            cconfig.put("org.jboss.remoting.trustStoreType", "JKS");
            String trustStoreFilePath = FactoryConfigSSLSample.getTruststoreFilePath();
            cconfig.put("org.jboss.remoting.trustStore", trustStoreFilePath);
            cconfig.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
            Client client = new Client(locator, cconfig);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            HashMap<String, String> cbconfig = new HashMap<String, String>();
            cbconfig.put("org.jboss.remoting.serversocket.useClientMode", "true");
            cbconfig.put("org.jboss.remoting.trustStoreType", "JKS");
            cbconfig.put("org.jboss.remoting.trustStore", trustStoreFilePath);
            cbconfig.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            callbackConnector.start();
            FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error((Object)t);
            t.printStackTrace();
            FactoryConfigSSLSample.fail();
        }
    }

    public void testFactoriesFromSystemSSLParameters() {
        try {
            HashMap<String, String> sconfig = new HashMap<String, String>();
            sconfig.put("force_remote", "true");
            System.setProperty("javax.net.ssl.keyStoreType", "JKS");
            String keyStoreFilePath = this.getKeystoreFilePath();
            System.setProperty("javax.net.ssl.keyStore", keyStoreFilePath);
            System.setProperty("javax.net.ssl.keyStorePassword", "unit-tests-server");
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
            String trustStoreFilePath = FactoryConfigSSLSample.getTruststoreFilePath();
            System.setProperty("javax.net.ssl.trustStore", trustStoreFilePath);
            System.setProperty("javax.net.ssl.trustStorePassword", "unit-tests-client");
            int freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator locator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector connector = new Connector(locator, sconfig);
            connector.create();
            connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            connector.start();
            HashMap<String, String> cconfig = new HashMap<String, String>();
            cconfig.put("force_remote", "true");
            Client client = new Client(locator, cconfig);
            client.connect();
            System.out.println(this.getName() + ": " + client.invoke("test invoke()"));
            HashMap<String, String> cbconfig = new HashMap<String, String>();
            cbconfig.put("org.jboss.remoting.serversocket.useClientMode", "true");
            freeport = PortUtil.findFreePort(this.getHostName());
            InvokerLocator callbackLocator = new InvokerLocator(this.getTransport() + "://" + this.getHostName() + ":" + freeport);
            Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
            callbackConnector.create();
            callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
            callbackConnector.start();
            FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
            String callbackHandleObject = "myCallbackHandleObject";
            client.addListener((InvokerCallbackHandler)callbackHandler, callbackLocator, (Object)callbackHandleObject);
            client.disconnect();
            callbackConnector.stop();
            connector.stop();
        }
        catch (Throwable t) {
            log.error((Object)t);
            t.printStackTrace();
            FactoryConfigSSLSample.fail();
        }
    }

    protected String getHostName() {
        return "localhost";
    }

    protected String getTransport() {
        return "sslsocket";
    }

    protected String getKeystoreFilePath() {
        File file = new File(FactoryConfigSSLSample.class.getResource("keystore").getFile());
        return file.getPath();
    }

    protected static String getTruststoreFilePath() {
        File file = new File(FactoryConfigSSLSample.class.getResource("truststore").getFile());
        return file.getPath();
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.jboss.remoting.keyStoreType", "JKS");
        String keyStoreFilePath = this.getKeystoreFilePath();
        config.put("org.jboss.remoting.keyStore", keyStoreFilePath);
        config.put("org.jboss.remoting.keyStorePassword", "unit-tests-server");
        config.put("org.jboss.remoting.sslProtocol", "SSL");
        SSLSocketBuilder builder = new SSLSocketBuilder(config);
        builder.setUseSSLServerSocketFactory(false);
        SSLServerSocketFactoryService service = new SSLServerSocketFactoryService();
        service.setSSLSocketBuilder(builder);
        service.start();
        return service;
    }

    protected SocketFactory getDefaultSocketFactory() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.jboss.remoting.trustStoreType", "JKS");
        String trustStoreFilePath = FactoryConfigSSLSample.getTruststoreFilePath();
        config.put("org.jboss.remoting.trustStore", trustStoreFilePath);
        config.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
        config.put("org.jboss.remoting.sslProtocol", "SSL");
        SSLSocketBuilder builder = new SSLSocketBuilder(config);
        builder.setUseSSLSocketFactory(false);
        SSLSocketFactoryService service = new SSLSocketFactoryService();
        service.setSSLSocketBuilder(builder);
        service.start();
        return service;
    }

    protected ServerSocketFactory getDefaultCallbackServerSocketFactory() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.jboss.remoting.serversocket.useClientMode", "true");
        config.put("org.jboss.remoting.trustStoreType", "JKS");
        String trustStoreFilePath = FactoryConfigSSLSample.getTruststoreFilePath();
        config.put("org.jboss.remoting.trustStore", trustStoreFilePath);
        config.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
        config.put("org.jboss.remoting.sslProtocol", "SSL");
        SSLSocketBuilder builder = new SSLSocketBuilder(config);
        builder.setUseSSLServerSocketFactory(false);
        SSLServerSocketFactoryService service = new SSLServerSocketFactoryService();
        service.setSSLSocketBuilder(builder);
        service.start();
        return service;
    }

    protected SocketFactory getDefaultCallbackSocketFactory() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.jboss.remoting.socket.useClientMode", "false");
        config.put("org.jboss.remoting.keyStoreType", "JKS");
        String keyStoreFilePath = this.getKeystoreFilePath();
        config.put("org.jboss.remoting.keyStore", keyStoreFilePath);
        config.put("org.jboss.remoting.keyStorePassword", "unit-tests-server");
        config.put("org.jboss.remoting.sslProtocol", "SSL");
        SSLSocketBuilder builder = new SSLSocketBuilder(config);
        builder.setUseSSLSocketFactory(false);
        SSLSocketFactoryService service = new SSLSocketFactoryService();
        service.setSSLSocketBuilder(builder);
        service.start();
        return builder.createSSLSocketFactory();
    }
}

