/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import org.jboss.logging.Logger;
import org.jboss.portal.theme.ThemeElement;

public final class ThemeScript
implements ThemeElement {
    private static final Logger log = Logger.getLogger(ThemeScript.class);
    private final String src;
    private final String type;
    private final String id;
    private final String charset;
    private final String script;

    public ThemeScript(String contextPath, String src, String id, String type, String bodyContent, String charset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating theme script with src=" + src + " type=" + type));
        }
        this.src = src;
        this.id = id;
        this.type = type;
        this.charset = charset;
        this.script = ThemeScript.buildScriptMarkup(contextPath, src, id, type, bodyContent, charset);
    }

    public String getScript() {
        return this.script;
    }

    public String toString() {
        return this.script;
    }

    public String getElement() {
        return this.getScript();
    }

    public String getAttributeValue(String attributeName) {
        if ("type".equals(attributeName)) {
            return this.type;
        }
        if ("id".equals(attributeName)) {
            return this.id;
        }
        if ("src".equals(attributeName)) {
            return this.src;
        }
        if ("charset".equals(attributeName)) {
            return this.charset;
        }
        return null;
    }

    private static String buildScriptMarkup(String contextPath, String src, String id, String type, String bodyContent, String charset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"build script markup...");
        }
        StringBuffer script = new StringBuffer();
        script.append("<script");
        if (src != null && !"".equals(src)) {
            StringBuffer correctSRC = new StringBuffer();
            if (src.startsWith("/")) {
                correctSRC.append(contextPath);
            }
            correctSRC.append(src);
            script.append(" src=\"").append(correctSRC).append("\"");
        }
        if (id != null && !"".equals(id)) {
            script.append(" id=\"").append(id).append("\"");
        }
        if (type != null && !"".equals(type)) {
            script.append(" type=\"").append(type).append("\"");
        }
        if (charset != null && !"".equals(charset)) {
            script.append(" charset=\"").append(charset).append("\"");
        }
        if (bodyContent == null || "".equals(bodyContent)) {
            script.append("></script>");
        } else {
            script.append(">").append(bodyContent).append("</script>");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("returning script : " + script));
        }
        return script.toString();
    }
}

