/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.taglib.portal.tag;

import java.io.IOException;
import java.util.Locale;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.taglib.common.PortalSimpleTag;
import org.springframework.context.ApplicationContext;

public class TranslationTag
extends PortalSimpleTag {
    private static final String INTERNATIONALIZATION_SERVICE_ATTRIBUTE_NAME = "osivia.internationalization.service";
    private static final String SEPARATOR = ",";
    private String key;
    private ClassLoader classLoader;
    private String args;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest servletRequest = pageContext.getRequest();
        Boolean layoutParsing = (Boolean)servletRequest.getAttribute("osivia.layout.parsing");
        if (BooleanUtils.isNotTrue((Boolean)layoutParsing)) {
            PortletRequest portletRequest = this.getPortletRequest();
            PortletContext portletContext = this.getPortletContext();
            Locale locale = servletRequest.getLocale();
            IInternationalizationService internationalizationService = this.getInternationalizationService(pageContext);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader customizedClassLoader = this.classLoader == null && portletRequest != null ? (ClassLoader)portletRequest.getAttribute("osivia.customizer.cms.jsp.classloader") : this.classLoader;
            ApplicationContext applicationContext = this.getApplicationContext();
            Object[] arguments = StringUtils.split((String)this.args, (String)SEPARATOR);
            String property = internationalizationService.getString(this.key, locale, classLoader, customizedClassLoader, applicationContext, arguments);
            JspWriter out = pageContext.getOut();
            out.write(property);
        }
    }

    private IInternationalizationService getInternationalizationService(PageContext pageContext) {
        IInternationalizationService internationalizationService = (IInternationalizationService)pageContext.getAttribute(INTERNATIONALIZATION_SERVICE_ATTRIBUTE_NAME, 2);
        if (internationalizationService == null) {
            internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
            pageContext.setAttribute(INTERNATIONALIZATION_SERVICE_ATTRIBUTE_NAME, (Object)internationalizationService, 2);
        }
        return internationalizationService;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setArgs(String args) {
        this.args = args;
    }
}

