/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.jboss.portal.common.text.CharBuffer;
import org.jboss.portal.common.text.CharWriter;
import org.jboss.portal.common.text.EntityEncoder;
import org.jboss.portlet.JBossActionRequest;
import org.jboss.portlet.JBossActionResponse;
import org.jboss.portlet.JBossRenderRequest;
import org.jboss.portlet.JBossRenderResponse;

public class JBossPortlet
implements Portlet {
    private static final Class[] ACTION_LOOKUP = new Class[]{JBossActionRequest.class, JBossActionResponse.class};
    private static final PortletMode ADMIN = new PortletMode("admin");
    private PortletConfig config;

    public String getDefaultOperation() {
        return "main";
    }

    public String getOperationName() {
        return "op";
    }

    public void init() throws PortletException {
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.config.getPortletContext();
    }

    protected void processAction(JBossActionRequest req, JBossActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        this.processDispatch(req, resp);
    }

    protected void processDispatch(JBossActionRequest req, JBossActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        PortletMode portletMode = req.getPortletMode();
        if (PortletMode.VIEW.equals((Object)portletMode)) {
            this.processView(req, resp);
        } else if (PortletMode.HELP.equals((Object)portletMode)) {
            this.processHelp(req, resp);
        } else if (PortletMode.EDIT.equals((Object)portletMode)) {
            this.processEdit(req, resp);
        } else if (ADMIN.equals((Object)portletMode)) {
            this.processAdmin(req, resp);
        }
    }

    public void processEdit(JBossActionRequest req, JBossActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        PortletPreferences prefs = req.getPreferences();
        Map map = prefs.getMap();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (!map.containsKey(name)) continue;
            prefs.setValues(name, values);
        }
        prefs.store();
    }

    public void processHelp(JBossActionRequest req, JBossActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    public void processAdmin(JBossActionRequest req, JBossActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    public void processView(JBossActionRequest req, JBossActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        Method dispatcher = null;
        String operation = req.getParameter(this.getOperationName());
        if (operation != null) {
            dispatcher = this.lookupMethod(operation, ACTION_LOOKUP);
        }
        if (dispatcher == null) {
            dispatcher = this.lookupMethod(this.getDefaultOperation(), ACTION_LOOKUP);
        }
        if (dispatcher != null) {
            try {
                dispatcher.invoke((Object)this, new Object[]{req, resp});
            }
            catch (IllegalAccessException e) {
                throw new PortletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof PortletException) {
                    throw (PortletException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new PortletException("Unexpected exception when dispatching the operation", (Throwable)e);
            }
        } else {
            throw new PortletException("Nothing to invoke");
        }
    }

    protected void render(JBossRenderRequest req, JBossRenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        resp.setTitle(this.getTitle(req));
        this.doDispatch(req, resp);
    }

    protected void doDispatch(JBossRenderRequest request, JBossRenderResponse response) throws PortletException, PortletSecurityException, IOException {
        if (!WindowState.MINIMIZED.equals((Object)request.getWindowState())) {
            PortletMode portletMode = request.getPortletMode();
            if (PortletMode.VIEW.equals((Object)portletMode)) {
                this.doView(request, response);
            } else if (PortletMode.HELP.equals((Object)portletMode)) {
                this.doHelp(request, response);
            } else if (PortletMode.EDIT.equals((Object)portletMode)) {
                this.doEdit(request, response);
            } else if (ADMIN.equals((Object)portletMode)) {
                this.doAdmin(request, response);
            }
        }
    }

    protected void doView(JBossRenderRequest request, JBossRenderResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    protected void doHelp(JBossRenderRequest request, JBossRenderResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    protected void doEdit(JBossRenderRequest request, JBossRenderResponse response) throws PortletException, PortletSecurityException, IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        PortletURL url = response.createActionURL();
        writer.print("<table> <tr><td class=\"portlet-section-alternate\">Name</td><td class=\"portlet-section-alternate\">Value</td></tr><form action=\"");
        writer.print(url.toString());
        writer.print("\" method=\"post\">");
        PortletPreferences prefs = request.getPreferences();
        for (Map.Entry entry : prefs.getMap().entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            CharBuffer nameBuffer = new CharBuffer();
            EntityEncoder.FULL.encode((CharSequence)name, (CharWriter)nameBuffer);
            name = nameBuffer.asString();
            CharBuffer valueBuffer = new CharBuffer();
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                if (value == null) continue;
                valueBuffer.reset();
                EntityEncoder.FULL.encode((CharSequence)value, (CharWriter)valueBuffer);
                values[j] = valueBuffer.asString();
            }
            writer.print("<tr><td class=\"portlet-section-body\">");
            writer.print(name);
            writer.print("</td><td class=\"portlet-section-body\">");
            if (prefs.isReadOnly(name)) {
                writer.print(name);
            } else {
                writer.print("<input class=\"portlet-form-input-field\" type=\"text\" name=\"");
                writer.print(name);
                writer.print("\" value=\"");
                writer.print(values.length >= 1 ? values[0] : "");
                writer.print("\"/>");
            }
            writer.print("</td></tr>");
        }
        writer.print("<tr><td colspan=\"2\" class=\"portlet-section-alternate\"><input class=\"portlet-form-button\" type=\"submit\" value=\"Save\"/></td></tr></form></table>");
    }

    protected void doAdmin(JBossRenderRequest request, JBossRenderResponse response) throws PortletException, PortletSecurityException, IOException {
        throw new PortletException();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getPortletConfig().getResourceBundle(locale);
    }

    protected String getTitle(RenderRequest request) {
        ResourceBundle bundle = this.getResourceBundle(request.getLocale());
        return bundle.getString("javax.portlet.title");
    }

    public String getInitParameter(String name) throws IllegalArgumentException {
        return this.getPortletConfig().getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.getPortletConfig().getInitParameterNames();
    }

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.init();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, PortletSecurityException, IOException {
        this.processAction((JBossActionRequest)request, (JBossActionResponse)response);
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        if (!(req instanceof JBossRenderRequest) || !(resp instanceof JBossRenderResponse)) {
            throw new PortletException("The request isn't a JBossRenderRequest, you probably need to activate the JBoss Portlet Filter: org.jboss.portlet.filter.JBossPortletFilter on " + this.getPortletName());
        }
        this.render((JBossRenderRequest)req, (JBossRenderResponse)resp);
    }

    public void destroy() {
    }

    private Method lookupMethod(String operation, Class[] parameterTypes) {
        try {
            Method m = this.getClass().getMethod(operation, parameterTypes);
            if (m.getReturnType() == Void.TYPE && Modifier.isPublic(m.getModifiers())) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

