/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.servlet;

import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.common.invocation.InterceptorStackFactory;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.common.util.Exceptions;
import org.jboss.portal.server.RequestController;
import org.jboss.portal.server.RequestControllerDispatcher;
import org.jboss.portal.server.RequestControllerFactory;
import org.jboss.portal.server.Server;
import org.jboss.portal.server.ServerException;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerRequest;
import org.jboss.portal.server.ServerResponse;
import org.jboss.portal.server.impl.ServerInvocationContextImpl;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.web.WebRequest;
import org.jboss.portal.web.endpoint.EndPointRequest;

public class PortalServlet
extends HttpServlet {
    private static final int DEFAULT_SERVLET_MAPPING = 0;
    private static final int ROOT_PATH_MAPPING = 1;
    private static final int PATH_MAPPING = 2;
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Server server;
    private InterceptorStackFactory interceptorStack;
    private boolean asDefaultServlet;
    private RequestControllerFactory controllerFactory;
    private String controllerFactoryName;

    public void init() throws ServletException {
        this.asDefaultServlet = this.getAsDefaultServletInitValue();
        this.controllerFactoryName = this.getServletConfig().getInitParameter("controllerFactoryName");
    }

    protected final Server getServer() {
        if (this.server == null) {
            try {
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                this.server = (Server)MBeanProxy.get(Server.class, (ObjectName)new ObjectName("portal:service=Server"), (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                String msg = "Cannot get portal server";
                this.log.error((Object)msg, (Throwable)e);
                throw new IllegalStateException(msg);
            }
        }
        return this.server;
    }

    protected final InterceptorStackFactory getInterceptorStackFactory() {
        if (this.interceptorStack == null) {
            try {
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                this.interceptorStack = (InterceptorStackFactory)MBeanProxy.get(InterceptorStackFactory.class, (ObjectName)new ObjectName("portal:service=InterceptorStackFactory,type=Server"), (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                String msg = "Cannot get interceptor stack";
                this.log.error((Object)msg, (Throwable)e);
                throw new IllegalStateException(msg);
            }
        }
        return this.interceptorStack;
    }

    protected final RequestControllerFactory getControllerFactory() {
        if (this.controllerFactory == null) {
            try {
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                this.controllerFactory = (RequestControllerFactory)MBeanProxy.get(RequestControllerFactory.class, (ObjectName)new ObjectName(this.controllerFactoryName), (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                String msg = "Cannot get controller " + this.controllerFactoryName;
                this.log.error((Object)msg, (Throwable)e);
                throw new IllegalStateException(msg);
            }
        }
        return this.controllerFactory;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String servletPath = req.getServletPath();
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        int mapping = 0;
        if (!this.asDefaultServlet) {
            mapping = servletPath.length() == 0 ? 1 : 2;
        }
        String portalHost = req.getServerName();
        String portalRequestPath = null;
        String portalContextPath = null;
        switch (mapping) {
            case 0: {
                portalRequestPath = requestURI.substring(contextPath.length());
                portalContextPath = requestURI.substring(0, contextPath.length());
                break;
            }
            case 1: {
                portalRequestPath = requestURI.substring(contextPath.length());
                portalContextPath = requestURI.substring(0, contextPath.length());
                break;
            }
            case 2: {
                portalRequestPath = requestURI.substring(contextPath.length() + servletPath.length());
                portalContextPath = requestURI.substring(0, contextPath.length() + servletPath.length());
            }
        }
        portalRequestPath = URLTools.decodeXWWWFormURL(portalRequestPath);
        portalContextPath = URLTools.decodeXWWWFormURL(portalContextPath);
        URLContext urlContext = URLContext.newInstance(req.isSecure(), req.getRemoteUser() != null);
        EndPointRequest webReq = new EndPointRequest(req, portalRequestPath, portalContextPath, 1);
        Server server = this.getServer();
        ServerInvocationContextImpl invocationCtx = new ServerInvocationContextImpl(req, resp, (WebRequest)webReq, portalHost, portalRequestPath, portalContextPath, urlContext);
        ServerRequest request = new ServerRequest(invocationCtx);
        request.setServer(server);
        ServerResponse response = new ServerResponse(request, invocationCtx);
        ServerInvocation invocation = new ServerInvocation(invocationCtx);
        invocation.setRequest(request);
        invocation.setResponse(response);
        RequestControllerFactory controllerFactory = this.getControllerFactory();
        RequestController controller = controllerFactory.createRequestController(invocation);
        invocation.setHandler(new RequestControllerDispatcher(controller));
        try {
            InterceptorStackFactory stack = this.getInterceptorStackFactory();
            invocation.invoke(stack.getInterceptorStack());
        }
        catch (ServerException e) {
            this.log.error((Object)"Server exception", (Throwable)e);
            Throwable nested = Exceptions.unwrap((Throwable)e);
            throw new ServletException(nested);
        }
        catch (InvocationException e) {
            this.log.error((Object)"Invocation exception", (Throwable)e);
            Throwable nested = Exceptions.unwrap((Throwable)e);
            throw new ServletException(nested);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Unexpected exception", (Throwable)e);
            Throwable nested = Exceptions.unwrap((Throwable)e);
            throw new ServletException(nested);
        }
    }

    protected boolean getAsDefaultServletInitValue() {
        ServletConfig config = this.getServletConfig();
        String value = config.getInitParameter("asDefaultServlet");
        if ("true".equalsIgnoreCase(value)) {
            this.log.debug((Object)"Servlet loaded as default servlet mapping");
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            this.log.debug((Object)"Servlet loaded as path mapping servlet");
            return false;
        }
        this.log.warn((Object)("Servlet mapping cannot be determined with init parameter value=" + value));
        return false;
    }
}

