/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.invocation.resolver;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.common.util.Tools;

public class RequestAttributeResolver
implements AttributeResolver {
    private final HttpServletRequest req;

    public RequestAttributeResolver(HttpServletRequest req) {
        if (req == null) {
            throw new IllegalArgumentException();
        }
        this.req = req;
    }

    public Set getKeys() {
        return Tools.toSet(this.req.getAttributeNames());
    }

    public Object getAttribute(Object attrKey) throws IllegalArgumentException {
        if (attrKey == null) {
            throw new IllegalArgumentException("No null attribute key accepted");
        }
        if (!(attrKey instanceof String)) {
            throw new IllegalArgumentException("Attribute key must be a string");
        }
        return this.req.getAttribute((String)attrKey);
    }

    public void setAttribute(Object attrKey, Object attrValue) throws IllegalArgumentException {
        if (attrKey == null) {
            throw new IllegalArgumentException("No null attribute key accepted");
        }
        if (!(attrKey instanceof String)) {
            throw new IllegalArgumentException("Attribute key must be a string");
        }
        if (attrValue != null) {
            this.req.setAttribute((String)attrKey, attrValue);
        } else {
            this.req.removeAttribute((String)attrKey);
        }
    }
}

