/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.portal.common.io.Serialization;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.impl.ControllerPortletInvocationContext;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.impl.spi.AbstractClientContext;
import org.jboss.portal.portlet.impl.spi.AbstractInstanceContext;
import org.jboss.portal.portlet.impl.spi.AbstractPortalContext;
import org.jboss.portal.portlet.impl.spi.AbstractRequestContext;
import org.jboss.portal.portlet.impl.spi.AbstractSecurityContext;
import org.jboss.portal.portlet.impl.spi.AbstractServerContext;
import org.jboss.portal.portlet.impl.spi.AbstractUserContext;
import org.jboss.portal.portlet.impl.spi.AbstractWindowContext;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.EventInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.ResourceInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.ClientContext;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.spi.PortalContext;
import org.jboss.portal.portlet.spi.PortletInvocationContext;
import org.jboss.portal.portlet.spi.RequestContext;
import org.jboss.portal.portlet.spi.SecurityContext;
import org.jboss.portal.portlet.spi.ServerContext;
import org.jboss.portal.portlet.spi.UserContext;
import org.jboss.portal.portlet.spi.WindowContext;
import org.jboss.portal.web.IllegalRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPortletControllerContext
implements PortletControllerContext {
    private static Logger log = Logger.getLogger(AbstractPortletControllerContext.class);
    public static final PortalContext PORTAL_CONTEXT = new AbstractPortalContext(Collections.singletonMap("javax.portlet.markup.head.element.support", "true"));
    public static final MarkupInfo MARKUP_INFO = new MarkupInfo(MediaType.TEXT_HTML, "UTF8");
    public static final int NAV_SCOPE = 0;
    public static final int SESSION_SCOPE = 1;
    private final HttpServletRequest req;
    private final HttpServletResponse resp;

    public AbstractPortletControllerContext(HttpServletRequest req, HttpServletResponse resp) throws IllegalRequestException, IOException {
        this.req = req;
        this.resp = resp;
    }

    public HttpServletRequest getClientRequest() {
        return this.req;
    }

    public HttpServletResponse getClientResponse() {
        return this.resp;
    }

    @Override
    public PortletInfo getPortletInfo(String windowId) {
        try {
            return this.getPortlet(windowId).getInfo();
        }
        catch (PortletInvokerException e) {
            log.error((Object)("Could not access portlet invoker for locating window " + windowId), (Throwable)e);
            return null;
        }
    }

    protected abstract Portlet getPortlet(String var1) throws PortletInvokerException;

    protected abstract PortletInvocationResponse invoke(PortletInvocation var1) throws PortletInvokerException;

    protected abstract Serialization<PortletPageNavigationalState> getPageNavigationalStateSerialization();

    @Override
    public PortletInvocationResponse invoke(ActionInvocation actionInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)actionInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        actionInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req));
        actionInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        actionInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        actionInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        actionInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        actionInvocation.setPortalContext(PORTAL_CONTEXT);
        actionInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        actionInvocation.setRequestContext((RequestContext)new AbstractRequestContext(this.req));
        actionInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)actionInvocation);
    }

    @Override
    public PortletInvocationResponse invoke(List<Cookie> requestCookies, EventInvocation eventInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)eventInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        eventInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req, requestCookies));
        eventInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        eventInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        eventInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        eventInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        eventInvocation.setPortalContext(PORTAL_CONTEXT);
        eventInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        eventInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)eventInvocation);
    }

    @Override
    public PortletInvocationResponse invoke(List<Cookie> requestCookies, RenderInvocation renderInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)renderInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        renderInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req, requestCookies));
        renderInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        renderInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        renderInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        renderInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        renderInvocation.setPortalContext(PORTAL_CONTEXT);
        renderInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        renderInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)renderInvocation);
    }

    @Override
    public PortletInvocationResponse invoke(ResourceInvocation resourceInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)resourceInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        resourceInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req));
        resourceInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        resourceInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        resourceInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        resourceInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        resourceInvocation.setPortalContext(PORTAL_CONTEXT);
        resourceInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        resourceInvocation.setRequestContext((RequestContext)new AbstractRequestContext(this.req));
        resourceInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)resourceInvocation);
    }

    @Override
    public PortletInvocationContext createPortletInvocationContext(String windowId, PortletPageNavigationalState pageNavigationalState) {
        return new ControllerPortletInvocationContext(this.getPageNavigationalStateSerialization(), this.req, this.resp, windowId, pageNavigationalState, MARKUP_INFO);
    }
}

