/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.db;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.ProfileMap;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.db.ProfileMapImpl;

public class HibernateUserImpl
implements User {
    private static final Logger log = Logger.getLogger(HibernateUserImpl.class);
    static final Map ACCESSORS = HibernateUserImpl.buildAccessors();
    protected ProfileMap profileMap;
    protected String userName;
    protected String givenName;
    protected String familyName;
    protected String realEmail;
    protected Long key = null;
    protected boolean enabled;
    protected String password;
    protected String fakeEmail;
    protected boolean viewRealEmail;
    protected Date registrationDate;
    protected Map dynamic;
    protected Set roles;

    private static Map buildAccessors() {
        HashMap<String, PropertyAccessor> map = new HashMap<String, PropertyAccessor>();
        map.put("user.name.nickName", new StringPropertyAccessor("user.name.nickName", "userName", false, false));
        map.put("user.business-info.online.email", new StringPropertyAccessor("user.business-info.online.email", "realEmail", true, true));
        map.put("user.name.given", new StringPropertyAccessor("user.name.given", "givenName", true, true));
        map.put("user.name.family", new StringPropertyAccessor("user.name.family", "familyName", true, true));
        map.put("portal.user.email.fake", new StringPropertyAccessor("portal.user.email.fake", "fakeEmail", true, true));
        map.put("portal.user.registration-date", new DatePropertyAccessor("portal.user.registration-date", "registrationDate", true, false));
        map.put("portal.user.email.view-real", new BooleanPropertyAccessor("portal.user.email.view-real", "viewRealEmail", true, false));
        map.put("portal.user.enabled", new BooleanPropertyAccessor("portal.user.enabled", "enabled", true, false));
        return Collections.unmodifiableMap(map);
    }

    public HibernateUserImpl() {
        this.userName = null;
        this.dynamic = null;
        this.roles = null;
        this.registrationDate = null;
        this.enabled = false;
        this.profileMap = new ProfileMapImpl(this);
    }

    public HibernateUserImpl(String userName) {
        this.userName = userName;
        this.dynamic = new HashMap();
        this.roles = new HashSet();
        this.registrationDate = new Date();
        this.enabled = false;
        this.profileMap = new ProfileMapImpl(this);
    }

    public Long getKey() {
        return this.key;
    }

    protected void setKey(Long key) {
        this.key = key;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    protected Map getDynamic() {
        return this.dynamic;
    }

    protected void setDynamic(Map dynamic) {
        this.dynamic = dynamic;
    }

    public ProfileMap getProfileMap() {
        return this.profileMap;
    }

    public Object getId() {
        return this.key;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void updatePassword(String password) throws IdentityException {
        this.password = Tools.md5AsHexString((String)password);
    }

    public String getRealEmail() {
        return this.realEmail;
    }

    public void setRealEmail(String realEmail) {
        this.realEmail = realEmail;
    }

    public String getFakeEmail() {
        return this.fakeEmail;
    }

    public void setFakeEmail(String fakeEmail) {
        this.fakeEmail = fakeEmail;
    }

    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public boolean getViewRealEmail() {
        return this.viewRealEmail;
    }

    public void setViewRealEmail(boolean viewRealEmail) {
        this.viewRealEmail = viewRealEmail;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set roles) {
        this.roles = roles;
    }

    public boolean validatePassword(String password) {
        if (password != null) {
            String hashedPassword = Tools.md5AsHexString((String)password);
            return hashedPassword.equals(this.password);
        }
        return false;
    }

    public String toString() {
        return "User[" + this.key + "," + this.userName + "]";
    }

    static class DatePropertyAccessor
    extends PropertyAccessor {
        private static final ThreadLocal formatLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new SimpleDateFormat();
            }
        };

        public DatePropertyAccessor(String propertyName, String fieldName, boolean writable, boolean nullable) {
            super(propertyName, fieldName, writable, nullable);
        }

        protected Object toObject(String value) throws IllegalArgumentException {
            try {
                DateFormat format = (DateFormat)formatLocal.get();
                Date date = format.parse(value);
                return date;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't convert the date in the user profile. value=[" + value + "].", e);
            }
        }

        protected String toString(Object value) {
            Date date = (Date)value;
            DateFormat format = (DateFormat)formatLocal.get();
            return format.format(date);
        }

        public Object get(Object instance) throws IllegalArgumentException {
            try {
                return this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }
    }

    static class BooleanPropertyAccessor
    extends PropertyAccessor {
        public BooleanPropertyAccessor(String propertyName, String fieldName, boolean writable, boolean nullable) {
            super(propertyName, fieldName, writable, nullable);
        }

        protected Object toObject(String value) throws IllegalArgumentException {
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("The value " + value + " cannot be converted to boolean for accessor " + this.toString());
        }

        protected String toString(Object value) {
            return value.toString();
        }

        public Object get(Object instance) throws IllegalArgumentException {
            try {
                return this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }
    }

    static class StringPropertyAccessor
    extends PropertyAccessor {
        public StringPropertyAccessor(String propertyName, String fieldName, boolean writable, boolean nullable) {
            super(propertyName, fieldName, writable, nullable);
        }

        protected Object toObject(String value) {
            return value;
        }

        protected String toString(Object value) {
            return (String)value;
        }
    }

    static abstract class PropertyAccessor {
        protected final String propertyName;
        protected final Field field;
        protected final boolean writable;
        protected final boolean nullable;

        public PropertyAccessor(String propertyName, String fieldName, boolean writable, boolean nullable) {
            try {
                this.propertyName = propertyName;
                this.writable = writable;
                this.field = HibernateUserImpl.class.getDeclaredField(fieldName);
                this.nullable = nullable;
            }
            catch (NoSuchFieldException e) {
                throw new Error(e);
            }
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void set(Object instance, Object value) throws IllegalArgumentException {
            try {
                if (value == null) {
                    this.field.set(instance, null);
                }
                if (value instanceof String) {
                    Object object = this.toObject((String)value);
                    this.field.set(instance, object);
                } else {
                    this.field.set(instance, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }

        public Object get(Object instance) throws IllegalArgumentException {
            try {
                Object object = this.field.get(instance);
                if (object == null) {
                    return null;
                }
                return this.toString(object);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }

        protected abstract Object toObject(String var1) throws IllegalArgumentException;

        protected abstract String toString(Object var1);

        public String toString() {
            return "PropertyAccessor[" + this.propertyName + "," + this.field + "]";
        }
    }
}

