/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Comparator;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.ldap.LDAPRoleModule;

public class LDAPRoleImpl
implements Role {
    private static final Logger log = Logger.getLogger(LDAPRoleImpl.class);
    private IdentityContext identityContext;
    private String dn;
    private String name;
    private String id;
    private String displayName;
    private LDAPRoleModule roleModule;

    private LDAPRoleImpl() {
    }

    protected LDAPRoleImpl(String dn, IdentityContext context, String id, String name, String displayName) {
        if (dn == null) {
            throw new IllegalArgumentException("LDAPRoleImpl need to be aware of its DN");
        }
        if (context == null) {
            throw new IllegalArgumentException("IdentityContext can't be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("DisplayName can't be null");
        }
        this.identityContext = context;
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.dn = dn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) {
            return super.equals(obj);
        }
        Role r = (Role)obj;
        return r.getId().toString().equals(this.getId().toString());
    }

    public int hashCode() {
        return this.id.hashCode() * 13 + 5;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("DisplayName is null");
        }
        try {
            this.getRoleModule().updateDisplayName(this, name);
            this.displayName = name;
        }
        catch (IdentityException e) {
            log.debug((Object)"Unable to update role displayName: ", (Throwable)e);
        }
    }

    protected LDAPRoleModule getRoleModule() throws IdentityException {
        if (this.roleModule == null) {
            try {
                this.roleModule = (LDAPRoleModule)this.identityContext.getObject("Role");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context", e);
            }
        }
        return this.roleModule;
    }

    public String getDn() {
        return this.dn;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public static class LDAPRoleComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Role r1 = (Role)o1;
            Role r2 = (Role)o2;
            String name1 = r1.getName();
            String name2 = r2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

