/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;

public class NuxeoException
extends RuntimeException {
    private static IInternationalizationService itlzService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
    private static final long serialVersionUID = 1L;
    private int errorCode = -1;
    public static final int ERROR_FORBIDDEN = 1;
    public static final int ERROR_UNAVAILAIBLE = 2;
    public static final int ERROR_NOTFOUND = 3;

    public int getErrorCode() {
        return this.errorCode;
    }

    public NuxeoException(Throwable cause) {
        super(cause);
    }

    public NuxeoException(int errorCode) {
        this.errorCode = errorCode;
    }

    public NuxeoException(int errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public void rethrowCMSException() throws CMSException {
        if (this.getCause() != null) {
            throw new CMSException(this.getCause());
        }
        if (this.errorCode != -1) {
            if (this.errorCode == 1) {
                throw new CMSException(1);
            }
            if (this.errorCode == 2) {
                throw new CMSException(2);
            }
            if (this.errorCode == 3) {
                throw new CMSException(3);
            }
        }
        throw new RuntimeException(this);
    }

    public String getUserMessage(PortalControllerContext portalCtx) {
        String sClass;
        Map otherNodes;
        JsonNode className;
        String message = null;
        Throwable curException = this;
        while (curException.getCause() != null) {
            curException = curException.getCause();
        }
        boolean quotaExceeded = false;
        if (curException instanceof JsonMarshalling.RemoteThrowable && (className = (JsonNode)(otherNodes = ((JsonMarshalling.RemoteThrowable)curException).getOtherNodes()).get("className")) != null && "\"org.opentoutatice.addon.quota.check.exception.QuotaExceededException\"".equals(sClass = className.toString())) {
            quotaExceeded = true;
        }
        if (quotaExceeded) {
            message = itlzService.getString("ERROR_MESSAGE_QUOTA_EXCEEDED", portalCtx.getHttpServletRequest().getLocale(), new Object[0]);
        }
        if ("Virus found".equals(curException.getMessage())) {
            message = itlzService.getString("ERROR_MESSAGE_VIRUS_FOUND", portalCtx.getHttpServletRequest().getLocale(), new Object[0]);
        }
        return message;
    }
}

