/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.urls.Link;

public class TitleTag
extends ToutaticeSimpleTag {
    private boolean linkable = true;
    private String displayContext;
    private boolean icon = false;
    private boolean openInSpaceTabs = false;
    private INuxeoCustomizer cmsCustomizer;

    public TitleTag() {
        INuxeoService nuxeoService = NuxeoServiceFactory.getNuxeoService();
        this.cmsCustomizer = nuxeoService.getCMSCustomizer();
    }

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        String title = StringUtils.isNotEmpty((String)document.getTitle()) ? document.getDisplayTitle() : document.getId();
        String icon = this.icon && document.getType() != null ? document.getType().getIcon() : null;
        Element container = DOM4JUtils.generateElement((String)"span", null, null);
        if (this.linkable) {
            boolean isFile;
            Link link = this.getTagService().getDocumentLink(nuxeoController, document, null, this.displayContext, false, false);
            boolean bl = isFile = document.getType() != null && "File".equals(document.getType().getName());
            String target = link.isExternal() || "download".equals(this.displayContext) && isFile ? "_blank" : (this.openInSpaceTabs ? this.cmsCustomizer.getTarget(document) : null);
            Element content = DOM4JUtils.generateLinkElement((String)link.getUrl(), (String)target, null, (String)"no-ajax-link", (String)title, (String)icon);
            container.add(content);
            if (link.isExternal()) {
                Element external = DOM4JUtils.generateElement((String)"small", null, null, (String)"glyphicons glyphicons-new-window-alt", null);
                container.add(external);
            }
        } else {
            Element content = DOM4JUtils.generateElement((String)"span", null, (String)title, (String)icon, null);
            container.add(content);
        }
        HTMLWriter htmlWriter = new HTMLWriter((Writer)this.getJspContext().getOut());
        htmlWriter.setEscapeText(false);
        htmlWriter.write(container);
    }

    public void setLinkable(boolean linkable) {
        this.linkable = linkable;
    }

    public void setDisplayContext(String displayContext) {
        this.displayContext = displayContext;
    }

    public void setIcon(boolean icon) {
        this.icon = icon;
    }

    public void setOpenInSpaceTabs(boolean openInSpaceTabs) {
        this.openInSpaceTabs = openInSpaceTabs;
    }
}

