/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.identity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.osivia.portal.core.identity.AbstractLDAPGroupMembership;

public class HierarchicalLDAPGroupMembership
extends AbstractLDAPGroupMembership {
    private static final Log logger = LogFactory.getLog(HierarchicalLDAPGroupMembership.class);

    @Override
    protected Set<Role> searchRolesFromLDAP(User user) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", (Throwable)e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        HashSet<Role> roles = new HashSet<Role>();
        try {
            String memberName = this.isUidAttributeIsDN() ? ldapUser.getDn() : ldapUser.getUserName();
            String filter = this.getMemberAttributeID().concat("=").concat(memberName);
            List results = this.getRoleModule().searchRoles(filter, null);
            for (SearchResult result : results) {
                this.addResultHierarchy(roles, result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roles;
    }

    private void addResultHierarchy(Set<Role> roles, SearchResult resultHierarchy) throws IdentityException, NamingException {
        String[] names;
        for (String name : names = StringUtils.split((String)resultHierarchy.getName(), (String)",")) {
            List results = this.getRoleModule().searchRoles(name, null);
            if (results.size() == 1) {
                SearchResult result = (SearchResult)results.get(0);
                DirContext dirContext = (DirContext)result.getObject();
                LDAPRoleImpl role = this.getRoleModule().createRoleInstance(result.getAttributes(), dirContext.getNameInNamespace());
                roles.add((Role)role);
                dirContext.close();
                continue;
            }
            logger.warn((Object)("LDAP request must return a single result for filter '" + name + "'."));
        }
    }
}

