/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPPermission;

public class SRPClientSession {
    private static Logger log = Logger.getLogger(SRPClientSession.class);
    private SRPParameters params;
    private BigInteger N;
    private BigInteger g;
    private BigInteger x;
    private BigInteger v;
    private byte[] s;
    private BigInteger a;
    private BigInteger A;
    private byte[] K;
    private MessageDigest clientHash;
    private MessageDigest serverHash;
    private static int A_LEN = 64;

    public SRPClientSession(String username, char[] password, SRPParameters params) {
        this(username, password, params, null);
    }

    public SRPClientSession(String username, char[] password, SRPParameters params, byte[] abytes) {
        MessageDigest tmp;
        try {
            Util.init();
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        this.params = params;
        this.g = new BigInteger(1, params.g);
        this.N = new BigInteger(1, params.N);
        if (abytes != null) {
            if (8 * abytes.length != A_LEN) {
                throw new IllegalArgumentException("The abytes param must be " + A_LEN / 8 + " in length, abytes.length=" + abytes.length);
            }
            this.a = new BigInteger(abytes);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("g: " + Util.tob64((byte[])params.g)));
        }
        byte[] xb = Util.calculatePasswordHash((String)username, (char[])password, (byte[])params.s);
        if (log.isTraceEnabled()) {
            log.trace((Object)("x: " + Util.tob64((byte[])xb)));
        }
        this.x = new BigInteger(1, xb);
        this.v = this.g.modPow(this.x, this.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("v: " + Util.tob64((byte[])this.v.toByteArray())));
        }
        this.serverHash = Util.newDigest();
        this.clientHash = Util.newDigest();
        byte[] hn = Util.newDigest().digest(params.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(N): " + Util.tob64((byte[])hn)));
        }
        byte[] hg = Util.newDigest().digest(params.g);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(g): " + Util.tob64((byte[])hg)));
        }
        byte[] hxg = Util.xor((byte[])hn, (byte[])hg, (int)20);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(N) xor H(g): " + Util.tob64((byte[])hxg)));
        }
        this.clientHash.update(hxg);
        if (log.isTraceEnabled()) {
            tmp = Util.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g)]: " + Util.tob64((byte[])tmp.digest())));
        }
        this.clientHash.update(Util.newDigest().digest(username.getBytes()));
        if (log.isTraceEnabled()) {
            tmp = Util.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U)]: " + Util.tob64((byte[])tmp.digest())));
        }
        this.clientHash.update(params.s);
        if (log.isTraceEnabled()) {
            tmp = Util.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s]: " + Util.tob64((byte[])tmp.digest())));
        }
        this.K = null;
    }

    public byte[] exponential() {
        byte[] Abytes = null;
        if (this.A == null) {
            if (this.a == null) {
                BigInteger one = BigInteger.ONE;
                do {
                    this.a = new BigInteger(A_LEN, Util.getPRNG());
                } while (this.a.compareTo(one) <= 0);
            }
            this.A = this.g.modPow(this.a, this.N);
            Abytes = Util.trim((byte[])this.A.toByteArray());
            this.clientHash.update(Abytes);
            if (log.isTraceEnabled()) {
                MessageDigest tmp = Util.copy((MessageDigest)this.clientHash);
                log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A]: " + Util.tob64((byte[])tmp.digest())));
            }
            this.serverHash.update(Abytes);
        }
        return Abytes;
    }

    public byte[] response(byte[] Bbytes) throws NoSuchAlgorithmException {
        this.clientHash.update(Bbytes);
        if (log.isTraceEnabled()) {
            MessageDigest tmp = Util.copy((MessageDigest)this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A | B]: " + Util.tob64((byte[])tmp.digest())));
        }
        byte[] hB = Util.newDigest().digest(Bbytes);
        byte[] ub = new byte[]{hB[0], hB[1], hB[2], hB[3]};
        BigInteger B = new BigInteger(1, Bbytes);
        if (log.isTraceEnabled()) {
            log.trace((Object)("B: " + Util.tob64((byte[])B.toByteArray())));
        }
        if (B.compareTo(this.v) < 0) {
            B = B.add(this.N);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("B': " + Util.tob64((byte[])B.toByteArray())));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("v: " + Util.tob64((byte[])this.v.toByteArray())));
        }
        BigInteger u = new BigInteger(1, ub);
        if (log.isTraceEnabled()) {
            log.trace((Object)("u: " + Util.tob64((byte[])u.toByteArray())));
        }
        BigInteger B_v = B.subtract(this.v);
        if (log.isTraceEnabled()) {
            log.trace((Object)("B - v: " + Util.tob64((byte[])B_v.toByteArray())));
        }
        BigInteger a_ux = this.a.add(u.multiply(this.x));
        if (log.isTraceEnabled()) {
            log.trace((Object)("a + u * x: " + Util.tob64((byte[])a_ux.toByteArray())));
        }
        BigInteger S = B_v.modPow(a_ux, this.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("S: " + Util.tob64((byte[])S.toByteArray())));
        }
        MessageDigest sessionDigest = MessageDigest.getInstance(this.params.hashAlgorithm);
        this.K = sessionDigest.digest(S.toByteArray());
        if (log.isTraceEnabled()) {
            log.trace((Object)("K: " + Util.tob64((byte[])this.K)));
        }
        this.clientHash.update(this.K);
        byte[] M1 = this.clientHash.digest();
        if (log.isTraceEnabled()) {
            log.trace((Object)("M1: H[H(N) xor H(g) | H(U) | s | A | B | K]: " + Util.tob64((byte[])M1)));
        }
        this.serverHash.update(M1);
        this.serverHash.update(this.K);
        if (log.isTraceEnabled()) {
            MessageDigest tmp = Util.copy((MessageDigest)this.serverHash);
            log.trace((Object)("H[A | M1 | K]: " + Util.tob64((byte[])tmp.digest())));
        }
        return M1;
    }

    public boolean verify(byte[] M2) {
        byte[] myM2 = this.serverHash.digest();
        boolean valid = Arrays.equals(M2, myM2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("verify serverM2: " + Util.tob64((byte[])M2)));
            log.trace((Object)("verify M2: " + Util.tob64((byte[])myM2)));
        }
        return valid;
    }

    public byte[] getSessionKey() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SRPPermission p = new SRPPermission("getSessionKey");
            sm.checkPermission(p);
        }
        return this.K;
    }
}

