/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.portlet;

import [Ljava.lang.String;;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.NullPredicate;
import org.apache.commons.collections.map.PredicatedMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.displaytag.util.Href;

public class PortletHref
implements Href {
    private static final String PARAM_PREFIX = "portlet:";
    public static final String PARAM_MODE = "portlet:mode";
    public static final String PARAM_STATE = "portlet:state";
    public static final String PARAM_SECURE = "portlet:secure";
    public static final String PARAM_TYPE = "portlet:type";
    public static final String TYPE_RENDER = "render";
    public static final String TYPE_ACTION = "action";
    private static final long serialVersionUID = 899149338534L;
    private static final Predicate PRED_TYPE_OF_STRING = new InstanceofPredicate(String.class);
    private static final Predicate PRED_TYPE_OF_STRING_ARRY = new InstanceofPredicate(String;.class);
    private static final Predicate PRED_OR_STR_STRARR = new AnyPredicate(new Predicate[]{PRED_TYPE_OF_STRING, PRED_TYPE_OF_STRING_ARRY, NullPredicate.INSTANCE});
    private final PortletRequest portletRequest;
    private final RenderResponse renderResponse;
    private Map parameters = this.createParameterMap();
    private boolean isAction;
    private PortletMode requestedMode;
    private WindowState requestedState;
    private boolean requestedSecure;
    private String anchor;

    public PortletHref(PortletRequest portletRequest, RenderResponse renderResponse) {
        if (portletRequest == null) {
            throw new IllegalArgumentException("portletRequest may not be null");
        }
        if (renderResponse == null) {
            throw new IllegalArgumentException("renderResponse may not be null");
        }
        this.portletRequest = portletRequest;
        this.renderResponse = renderResponse;
    }

    public void setFullUrl(String baseUrl) {
    }

    public boolean isAction() {
        return this.isAction;
    }

    public void setAction(boolean isAction) {
        this.isAction = isAction;
    }

    public PortletMode getRequestedMode() {
        return this.requestedMode;
    }

    public void setRequestedMode(PortletMode requestedMode) {
        this.requestedMode = requestedMode;
    }

    public boolean isRequestedSecure() {
        return this.requestedSecure;
    }

    public void setRequestedSecure(boolean requestedSecure) {
        this.requestedSecure = requestedSecure;
    }

    public WindowState getRequestedState() {
        return this.requestedState;
    }

    public void setRequestedState(WindowState requestedState) {
        this.requestedState = requestedState;
    }

    public Href addParameter(String name, int value) {
        return this.addParameter(name, Integer.toString(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Href addParameter(String name, Object objValue) {
        String value = ObjectUtils.toString((Object)objValue, null);
        if (name != null && name.startsWith(PARAM_PREFIX)) {
            if (PARAM_TYPE.equals(name)) {
                if (TYPE_RENDER.equals(value)) {
                    this.setAction(false);
                    return this;
                } else {
                    if (!TYPE_ACTION.equals(value)) throw new IllegalArgumentException("Value of parameter '" + name + "' must be equal to '" + TYPE_RENDER + "' or '" + TYPE_ACTION + "'. '" + value + "' is not allowed.");
                    this.setAction(true);
                }
                return this;
            } else if (PARAM_SECURE.equals(name)) {
                if (new Boolean(value).booleanValue()) {
                    this.setRequestedSecure(true);
                    return this;
                } else {
                    this.setRequestedSecure(false);
                }
                return this;
            } else if (PARAM_MODE.equals(name)) {
                if (value == null) {
                    this.setRequestedMode(null);
                    return this;
                } else {
                    PortletMode mode = new PortletMode(value);
                    if (!this.portletRequest.isPortletModeAllowed(mode)) {
                        throw new IllegalArgumentException("PortletMode '" + mode + "' is not allowed for this request.");
                    }
                    this.setRequestedMode(mode);
                }
                return this;
            } else {
                if (!PARAM_STATE.equals(name)) throw new IllegalArgumentException("'" + name + "' is not a valid '" + PARAM_PREFIX + "' prefixed parameter.");
                if (value == null) {
                    this.setRequestedState(null);
                    return this;
                } else {
                    WindowState state = new WindowState(value);
                    if (!this.portletRequest.isWindowStateAllowed(state)) {
                        throw new IllegalArgumentException("WindowState '" + state + "' is not allowed for this request.");
                    }
                    this.setRequestedState(state);
                }
            }
            return this;
        } else {
            this.parameters.put(name, value);
        }
        return this;
    }

    public void addParameterMap(Map parametersMap) {
        Iterator paramItr = parametersMap.entrySet().iterator();
        while (paramItr.hasNext()) {
            Map.Entry entry = paramItr.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                this.parameters.put(name, value);
                continue;
            }
            if (value == null || value instanceof String) {
                this.addParameter(name, value);
                continue;
            }
            this.addParameter(name, value.toString());
        }
    }

    public void setParameterMap(Map parametersMap) {
        this.parameters.clear();
        this.addParameterMap(parametersMap);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void setAnchor(String name) {
        this.anchor = name;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String getBaseUrl() {
        if (this.isAction()) {
            return this.renderResponse.createActionURL().toString();
        }
        return this.renderResponse.createRenderURL().toString();
    }

    public Object clone() {
        PortletHref href;
        try {
            href = (PortletHref)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("Parent through a CloneNotSupportedException, this should never happen", cnse);
        }
        href.isAction = this.isAction;
        href.parameters = this.createParameterMap();
        href.parameters.putAll(this.parameters);
        href.requestedMode = this.requestedMode;
        href.requestedState = this.requestedState;
        href.requestedSecure = this.requestedSecure;
        href.anchor = this.anchor;
        return href;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortletHref)) {
            return false;
        }
        PortletHref rhs = (PortletHref)object;
        return new EqualsBuilder().append(this.isAction, rhs.isAction).append((Object)this.parameters, (Object)rhs.parameters).append((Object)this.requestedMode, (Object)rhs.requestedMode).append((Object)this.requestedState, (Object)rhs.requestedState).append(this.requestedSecure, rhs.requestedSecure).append((Object)this.anchor, (Object)rhs.anchor).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1313733113, -431360889).append(this.isAction).append((Object)this.parameters).append((Object)this.requestedMode).append((Object)this.requestedState).append(this.requestedSecure).append((Object)this.anchor).toHashCode();
    }

    public String toString() {
        PortletURL url = this.isAction() ? this.renderResponse.createActionURL() : this.renderResponse.createRenderURL();
        if (this.isRequestedSecure()) {
            try {
                url.setSecure(true);
            }
            catch (PortletSecurityException pse) {
                throw new RuntimeException("Creating secure PortletURL Failed.", pse);
            }
        }
        if (this.getRequestedMode() != null) {
            try {
                url.setPortletMode(this.getRequestedMode());
            }
            catch (PortletModeException pme) {
                IllegalStateException ise = new IllegalStateException("Requested PortletMode='" + this.getRequestedMode() + "' could not be set.");
                ise.initCause(pme);
                throw ise;
            }
        }
        if (this.getRequestedState() != null) {
            try {
                url.setWindowState(this.getRequestedState());
            }
            catch (WindowStateException wse) {
                IllegalStateException ise = new IllegalStateException("Requested WindowState='" + this.getRequestedState() + "' could not be set.");
                ise.initCause(wse);
                throw ise;
            }
        }
        Iterator paramItr = this.parameters.entrySet().iterator();
        while (paramItr.hasNext()) {
            Map.Entry entry = paramItr.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                url.setParameter(name, (String)value);
                continue;
            }
            if (!(value instanceof String[])) continue;
            url.setParameter(name, (String[])value);
        }
        if (this.getAnchor() == null) {
            return url.toString();
        }
        return url.toString() + "#" + this.getAnchor();
    }

    private Map createParameterMap() {
        return PredicatedMap.decorate(new HashMap(), (Predicate)PRED_TYPE_OF_STRING, (Predicate)PRED_OR_STR_STRARR);
    }
}

