/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.portal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.core.impl.model.portal.AbstractPortalObjectContainer;
import org.jboss.portal.core.impl.model.portal.PortalObjectImpl;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.handler.ContentHandler;
import org.jboss.portal.core.model.content.spi.handler.ContentState;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.jems.hibernate.ContextObject;

public class WindowImpl
extends PortalObjectImpl
implements Window,
ContextObject {
    public static final String PORTAL_PROP_WINDOW_CONTENT_TYPE = "portal.windowContentType";
    public static final String PORTAL_INITIAL_WINDOW_STATE = "portal.windowInitialState";
    public static final String PORTAL_INITIAL_MODE = "portal.windowInitialMode";
    protected String uri;
    protected AbstractPortalObjectContainer.ContainerContext containerContext;
    protected ContentType contentType;
    protected ContentStateImpl contentState;

    public WindowImpl() {
        super(true);
        this.contentType = null;
        this.uri = null;
    }

    public WindowImpl(ContentType contentType, String contentURI) throws IllegalArgumentException {
        super(false);
        if (contentType == null) {
            throw new IllegalArgumentException("No null content type accepted");
        }
        if (contentURI == null) {
            throw new IllegalArgumentException("No null content URI accepted");
        }
        this.contentType = contentType;
        this.uri = contentURI;
    }

    private ContentStateImpl getContentState() {
        if (this.contentState == null) {
            this.contentState = new ContentStateImpl();
        }
        return this.contentState;
    }

    public void setContext(Object context) {
        this.containerContext = (AbstractPortalObjectContainer.ContainerContext)context;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public Page getPage() {
        return (Page)this.getParent();
    }

    public Content getContent() {
        return this.getContentState().getContent();
    }

    public ContentType getContentType() {
        if (this.contentType == null) {
            String value = this.getDeclaredProperty(PORTAL_PROP_WINDOW_CONTENT_TYPE);
            this.contentType = value == null ? this.containerContext.getDefaultContentType() : ContentType.create(value);
        }
        return this.contentType;
    }

    public int getType() {
        return 3;
    }

    protected PortalObjectImpl cloneObject() {
        WindowImpl clone = new WindowImpl();
        clone.setURI(this.uri);
        clone.setDeclaredPropertyMap(new HashMap<String, String>(this.getDeclaredPropertyMap()));
        clone.setListener(this.getListener());
        clone.setDisplayName(this.getDisplayName());
        return clone;
    }

    protected void destroy() {
        this.getContentState().destroy();
    }

    public WindowState getInitialWindowState() {
        String value = this.getDeclaredProperty(PORTAL_INITIAL_WINDOW_STATE);
        if (value != null) {
            return WindowState.create((String)value);
        }
        return WindowState.NORMAL;
    }

    public Mode getInitialMode() {
        String value = this.getDeclaredProperty(PORTAL_INITIAL_MODE);
        if (value != null) {
            return Mode.create((String)value);
        }
        return Mode.VIEW;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentStateImpl
    implements ContentState {
        private final String contextId;
        private Content content;

        private ContentStateImpl() {
            this.contextId = WindowImpl.this.getId().toString();
        }

        @Override
        public String getURI() {
            return WindowImpl.this.uri;
        }

        @Override
        public void setURI(String uri) {
            WindowImpl.this.uri = uri;
        }

        private void destroy() {
            ContentHandler handler = this.getContentHandler();
            if (handler != null) {
                handler.contentDestroyed(this.contextId, this);
            }
        }

        private Content getContent() {
            ContentHandler handler;
            if (this.content == null && (handler = this.getContentHandler()) != null) {
                String contextId = WindowImpl.this.getId().toString();
                this.content = handler.newContent(contextId, this);
            }
            return this.content;
        }

        private ContentHandler getContentHandler() {
            ContentType contentType = WindowImpl.this.getContentType();
            return WindowImpl.this.containerContext.getContentHandler(contentType);
        }

        public Iterator getParameterNames() {
            return new Iterator(){
                Iterator i;
                String next;
                {
                    this.i = WindowImpl.this.getDeclaredProperties().keySet().iterator();
                    this.findNext();
                }

                public boolean hasNext() {
                    return this.next != null;
                }

                public Object next() {
                    String tmp = this.next;
                    this.findNext();
                    return tmp;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                void findNext() {
                    this.next = null;
                    while (this.i.hasNext() && this.next == null) {
                        String propertyName = (String)this.i.next();
                        if (!propertyName.startsWith("content.")) continue;
                        this.next = propertyName.substring(8);
                    }
                }
            };
        }

        @Override
        public void setParameter(String name, String value) throws IllegalArgumentException {
            WindowImpl.this.setDeclaredProperty("content." + name, value);
        }

        @Override
        public void setParameters(Map<String, String> parameters) throws IllegalArgumentException {
            this.clearParameters();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                this.setParameter(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public String getParameter(String name) throws IllegalArgumentException {
            return WindowImpl.this.getDeclaredProperty("content." + name);
        }

        @Override
        public void clearParameters() {
            Iterator<String> i = WindowImpl.this.getDeclaredProperties().keySet().iterator();
            while (i.hasNext()) {
                String propertyName = i.next();
                if (!propertyName.startsWith("content.")) continue;
                i.remove();
            }
        }
    }
}

