/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.portal.common.i18n.ResourceBundleFactory;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.util.EmptyResourceBundle;

public class MetaDataResourceBundleFactory
implements ResourceBundleFactory {
    private Logger logger = Logger.getLogger(MetaDataResourceBundleFactory.class);
    private ClassLoader classLoader;
    private String baseName;

    public static ResourceBundleManager createResourceBundleManager(ClassLoader classLoader, List supportedLocales, String baseName) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Need a non null classloader");
        }
        if (supportedLocales == null) {
            throw new IllegalArgumentException("Supported locales cannot be null");
        }
        MetaDataResourceBundleFactory factory = new MetaDataResourceBundleFactory(classLoader, baseName);
        ResourceBundleManager manager = new ResourceBundleManager((ResourceBundle)EmptyResourceBundle.INSTANCE, (ResourceBundleFactory)factory);
        for (Locale locale : supportedLocales) {
            manager.getResourceBundle(locale);
        }
        return manager;
    }

    public MetaDataResourceBundleFactory(ClassLoader classLoader, String baseName) {
        this.classLoader = classLoader;
        this.baseName = baseName;
    }

    public ResourceBundle getBundle(Locale locale) throws IllegalArgumentException {
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null");
        }
        try {
            return ResourceBundle.getBundle(this.baseName, locale, this.classLoader);
        }
        catch (MissingResourceException e) {
            this.logger.warn((Object)("Could not find resource bundle: " + this.baseName + " for locale: " + locale));
            return EmptyResourceBundle.INSTANCE;
        }
    }
}

