/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.navstate;

import java.io.Serializable;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.portlet.StateString;

public final class WindowNavigationalState
implements Serializable {
    private static final WindowNavigationalState DEFAULT = new WindowNavigationalState();
    private final WindowState windowState;
    private final Mode mode;
    private final StateString contentState;
    private final StateString publicContentState;

    public static WindowNavigationalState create() {
        return DEFAULT;
    }

    public WindowNavigationalState(WindowState windowState, Mode mode, StateString contentState, StateString publicContentState) {
        if (windowState == null) {
            throw new IllegalArgumentException("No null window state accepted");
        }
        if (mode == null) {
            throw new IllegalArgumentException("No null mode accepted");
        }
        this.windowState = windowState;
        this.mode = mode;
        this.contentState = contentState;
        this.publicContentState = publicContentState;
    }

    private WindowNavigationalState() {
        this(WindowState.NORMAL, Mode.VIEW, null, null);
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public Mode getMode() {
        return this.mode;
    }

    public StateString getContentState() {
        return this.contentState;
    }

    public StateString getPublicContentState() {
        return this.publicContentState;
    }

    public static WindowState getWindowState(AttributeResolver resolver, Object id) {
        NavigationalStateKey key = new NavigationalStateKey(WindowNavigationalState.class, id);
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        return wns != null ? wns.getWindowState() : null;
    }

    public static void setWindowState(AttributeResolver resolver, Object id, WindowState windowState) {
        WindowNavigationalState.setWindowState(resolver, new NavigationalStateKey(WindowNavigationalState.class, id), windowState);
    }

    public static void setWindowState(AttributeResolver resolver, NavigationalStateKey key, WindowState windowState) {
        if (resolver == null) {
            throw new IllegalArgumentException("No null resolver");
        }
        if (key == null) {
            throw new IllegalArgumentException("No null key");
        }
        if (windowState == null) {
            throw new IllegalArgumentException("No null window state");
        }
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        wns = wns == null ? new WindowNavigationalState(windowState, Mode.VIEW, null, null) : new WindowNavigationalState(windowState, wns.getMode(), wns.getContentState(), wns.getPublicContentState());
        resolver.setAttribute((Object)key, (Object)wns);
    }

    public static Mode getMode(AttributeResolver resolver, Object id) {
        NavigationalStateKey key = new NavigationalStateKey(WindowNavigationalState.class, id);
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        return wns != null ? wns.getMode() : null;
    }

    public static void setMode(AttributeResolver context, Object id, Mode mode) {
        WindowNavigationalState.setMode(context, new NavigationalStateKey(WindowNavigationalState.class, id), mode);
    }

    public static void setMode(AttributeResolver resolver, NavigationalStateKey key, Mode mode) {
        if (resolver == null) {
            throw new IllegalArgumentException("No null resolver");
        }
        if (key == null) {
            throw new IllegalArgumentException("No null key");
        }
        if (mode == null) {
            throw new IllegalArgumentException("No null mode");
        }
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        wns = wns == null ? new WindowNavigationalState(WindowState.NORMAL, mode, null, null) : new WindowNavigationalState(wns.getWindowState(), mode, wns.getContentState(), wns.getPublicContentState());
        resolver.setAttribute((Object)key, (Object)wns);
    }

    public static StateString getState(AttributeResolver resolver, Object id) {
        NavigationalStateKey key = new NavigationalStateKey(WindowNavigationalState.class, id);
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        return wns != null ? wns.getContentState() : null;
    }

    public static void setState(AttributeResolver resolver, Object id, StateString state) {
        WindowNavigationalState.setState(resolver, new NavigationalStateKey(WindowNavigationalState.class, id), state);
    }

    public static StateString getPublicState(AttributeResolver resolver, Object id) {
        NavigationalStateKey key = new NavigationalStateKey(WindowNavigationalState.class, id);
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        return wns != null ? wns.getPublicContentState() : null;
    }

    public static void setPublicState(AttributeResolver resolver, Object id, StateString state) {
        WindowNavigationalState.setPublicState(resolver, new NavigationalStateKey(WindowNavigationalState.class, id), state);
    }

    public static void setState(AttributeResolver resolver, NavigationalStateKey key, StateString state) {
        if (resolver == null) {
            throw new IllegalArgumentException("No null resolver");
        }
        if (key == null) {
            throw new IllegalArgumentException("No null key");
        }
        if (state == null) {
            throw new IllegalArgumentException("No null state");
        }
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        wns = wns == null ? new WindowNavigationalState(WindowState.NORMAL, Mode.VIEW, state, null) : new WindowNavigationalState(wns.getWindowState(), wns.getMode(), state, wns.getPublicContentState());
        resolver.setAttribute((Object)key, (Object)wns);
    }

    public static void setPublicState(AttributeResolver resolver, NavigationalStateKey key, StateString publicState) {
        if (resolver == null) {
            throw new IllegalArgumentException("No null resolver");
        }
        if (key == null) {
            throw new IllegalArgumentException("No null key");
        }
        if (publicState == null) {
            throw new IllegalArgumentException("No null public state");
        }
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        wns = wns == null ? new WindowNavigationalState(WindowState.NORMAL, Mode.VIEW, null, publicState) : new WindowNavigationalState(wns.getWindowState(), wns.getMode(), wns.getContentState(), publicState);
        resolver.setAttribute((Object)key, (Object)wns);
    }

    public static void setState(AttributeResolver resolver, NavigationalStateKey key, StateString state, Window window) {
        if (resolver == null) {
            throw new IllegalArgumentException("No null resolver");
        }
        if (key == null) {
            throw new IllegalArgumentException("No null key");
        }
        if (state == null) {
            throw new IllegalArgumentException("No null state");
        }
        if (window == null) {
            throw new IllegalArgumentException("No null window");
        }
        WindowNavigationalState wns = (WindowNavigationalState)resolver.getAttribute((Object)key);
        wns = wns == null ? new WindowNavigationalState(window.getInitialWindowState(), window.getInitialMode(), state, null) : new WindowNavigationalState(wns.getWindowState(), wns.getMode(), state, wns.getPublicContentState());
        resolver.setAttribute((Object)key, (Object)wns);
    }

    public static WindowNavigationalState bilto(WindowNavigationalState oldNS, WindowState windowState, Mode mode, StateString contentState) {
        Mode newMode;
        StateString newState = oldNS != null ? oldNS.getContentState() : null;
        WindowState newWindowState = oldNS != null ? oldNS.getWindowState() : WindowState.NORMAL;
        Mode mode2 = newMode = oldNS != null ? oldNS.getMode() : Mode.VIEW;
        if (contentState != null) {
            newState = contentState;
        }
        if (mode != null) {
            newMode = mode;
        }
        if (windowState != null) {
            newWindowState = windowState;
        }
        return new WindowNavigationalState(newWindowState, newMode, newState, oldNS.getPublicContentState());
    }
}

