/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.actions;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.text.FastURLDecoder;
import org.jboss.portal.core.identity.services.IdentityMailService;
import org.jboss.portal.core.identity.ui.IdentityUIUser;
import org.jboss.portal.core.identity.ui.common.IdentityUserBean;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;

public class LostPasswordAction {
    private String username;
    private String email;
    private String passwordCharacters;
    private IdentityUserBean identityUserBean;
    private IdentityMailService identityMailService;
    private static final Logger log = Logger.getLogger(LostPasswordAction.class);
    private static final FastURLDecoder decoder = FastURLDecoder.getUTF8Instance();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public IdentityUserBean getIdentityUserBean() {
        return this.identityUserBean;
    }

    public void setIdentityUserBean(IdentityUserBean identityUserBean) {
        this.identityUserBean = identityUserBean;
    }

    public IdentityMailService getIdentityMailService() {
        return this.identityMailService;
    }

    public void setIdentityMailService(IdentityMailService identityMailService) {
        this.identityMailService = identityMailService;
    }

    public String getPasswordCharacters() {
        return this.passwordCharacters;
    }

    public void setPasswordCharacters(String passwordCharacters) {
        this.passwordCharacters = passwordCharacters;
    }

    public String doomed() {
        User user = null;
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", FacesContext.getCurrentInstance().getViewRoot().getLocale());
        if (this.username != null && this.username.trim().length() > 0) {
            try {
                user = this.identityUserBean.findUserByUserName(this.username);
            }
            catch (NoSuchUserException e) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_LOST_PASSWORD_STATUS_404")));
                return "status";
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_LOST_PASSWORD_ERROR")));
                return "status";
            }
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_LOST_PASSWORD_STATUS_404")));
            return "status";
        }
        if (user != null) {
            try {
                String newPassword = this.genPassword(8);
                IdentityUIUser uiUser = new IdentityUIUser(user.getUserName());
                HashMap<String, String> mailMap = new HashMap<String, String>();
                mailMap.put("to", (String)uiUser.getAttribute().getValue("email").getObject());
                mailMap.put("username", user.getUserName());
                mailMap.put("password", newPassword);
                this.identityUserBean.updatePassword(user.getUserName(), newPassword);
                Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                this.identityMailService.sendMail("lostPassword", mailMap, locale);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_LOST_PASSWORD_ERROR"), bundle.getString("IDENTITY_LOST_PASSWORD_ERROR")));
                return "status";
            }
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(bundle.getString("IDENTITY_LOST_PASSWORD_STATUS_SUCCESSFUL")));
        return "status";
    }

    public String adminResetPassword() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        this.username = params.get("currentUser") != null ? decoder.encode((String)params.get("currentUser")) : null;
        return "resetPassword";
    }

    private String genPassword(int length) throws NoSuchAlgorithmException {
        StringBuffer buffer = new StringBuffer();
        char[] characterMap = this.passwordCharacters.toCharArray();
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        for (int i = 0; i <= length; ++i) {
            byte[] bytes = new byte[512];
            secureRandom.nextBytes(bytes);
            double number = secureRandom.nextDouble();
            int b = (int)(number * (double)characterMap.length);
            buffer.append(characterMap[b]);
        }
        return buffer.toString();
    }
}

