/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.trapd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.jmx.adaptor.snmp.trapd.TrapReceiver;
import org.jboss.jmx.adaptor.snmp.trapd.TrapdServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;

public class TrapdService
extends ServiceMBeanSupport
implements TrapdServiceMBean {
    private int port;
    private InetAddress bindAddress;
    protected SnmpTrapSession trapSession;

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = this.toInetAddress(host);
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    protected void startService() throws Exception {
        try {
            InetAddress address = this.bindAddress != null ? this.bindAddress : this.toInetAddress(System.getProperty("jboss.bind.address"));
            this.trapSession = new SnmpTrapSession((SnmpTrapHandler)new TrapReceiver(this.log), this.port, address);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot instantiate trap session");
            throw e;
        }
    }

    protected void stopService() throws Exception {
        this.trapSession.close();
        this.trapSession = null;
    }

    private InetAddress toInetAddress(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }
}

