/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.impl;

import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.jboss.portal.search.FederatedQuery;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.QueryConversionException;
import org.jboss.portal.search.QueryConverter;

public abstract class AbstractQueryConverter
implements QueryConverter {
    public Query convert(FederatedQuery query) throws QueryConversionException {
        org.apache.lucene.search.Query luceneQuery = query.getLuceneQuery();
        if (luceneQuery == null) {
            return null;
        }
        return this.convert(luceneQuery);
    }

    public Query convert(org.apache.lucene.search.Query luceneQuery) throws QueryConversionException {
        if (luceneQuery instanceof TermQuery) {
            return this.convertTermQuery((TermQuery)luceneQuery);
        }
        if (luceneQuery instanceof BooleanQuery) {
            return this.convertBooleanQuery((BooleanQuery)luceneQuery);
        }
        throw new QueryConversionException("Unknown query type: " + luceneQuery.getClass());
    }

    public abstract Query convertTermQuery(TermQuery var1);

    public abstract Query convertBooleanQuery(BooleanQuery var1) throws QueryConversionException;
}

