/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.deployment.DeploymentException;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.net.URLNavigator;
import org.jboss.portal.common.net.URLVisitor;
import org.jboss.portal.common.xml.NullEntityResolver;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.deployment.jboss.PortletAppDeploymentFactory;
import org.jboss.portal.core.metadata.ServiceMetaData;
import org.jboss.portal.core.metadata.portlet.JBossApplicationMetaData;
import org.jboss.portal.core.model.instance.DuplicateInstanceException;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.instance.NoSuchInstanceException;
import org.jboss.portal.core.model.instance.metadata.InstanceMetaData;
import org.jboss.portal.portlet.InvalidPortletIdException;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletPreferenceMetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletPreferencesMetaData;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.metadata.SecurityConstraintsMetaData;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class PortletAppDeployment
extends org.jboss.portal.portlet.deployment.jboss.PortletAppDeployment
implements Advised {
    public static final int OVERWRITE_IF_EXISTS = 0;
    public static final int KEEP_IF_EXISTS = 1;
    private PortletAppDeploymentFactory factory;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.jboss.portal.core.deployment.jboss.PortletAppDeployment"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_handleInstance2257800355530988303;

    public PortletAppDeployment(URL url, PortalWebApp pwa, ManagedObjectRegistryEventListener listener, MBeanServer mbeanServer, PortletAppDeploymentFactory factory) {
        super(url, pwa, listener, mbeanServer, (org.jboss.portal.portlet.deployment.jboss.PortletAppDeploymentFactory)factory);
        this.factory = factory;
    }

    public void start() throws DeploymentException {
        this.injectServices();
        super.start();
        if (this.factory.getCreateInstances()) {
            this.buildInstances();
        }
    }

    protected void injectServices() {
        if (this.jbossAppMD instanceof JBossApplicationMetaData) {
            JBossApplicationMetaData jBossApplicationMetaData = (JBossApplicationMetaData)this.jbossAppMD;
            for (ServiceMetaData serviceMD : jBossApplicationMetaData.getServices().values()) {
                String serviceName = serviceMD.getName();
                String serviceClass = serviceMD.getClassName();
                String serviceRef = serviceMD.getRef();
                this.log.debug((Object)("Trying to inject service '" + serviceName + "' (ref: '" + serviceRef + "' class: " + serviceClass + ") in the servlet context of " + this.pwa.getURL()));
                if (serviceRef.startsWith(":")) {
                    this.log.debug((Object)("Detecting a relative service reference " + serviceRef + " prepending it with " + this.factory.getConfig().getDomain()));
                    serviceRef = this.factory.getConfig().getDomain() + serviceRef;
                }
                try {
                    Class<?> proxyClass = this.pwa.getClassLoader().loadClass(serviceClass);
                    ObjectName objectName = ObjectName.getInstance(serviceRef);
                    Object proxy = MBeanProxyExt.create(proxyClass, (ObjectName)objectName, (MBeanServer)this.mbeanServer, (boolean)true);
                    this.pwa.getServletContext().setAttribute(serviceName, proxy);
                }
                catch (Exception e) {
                    this.log.error((Object)"Was not able to create service proxy", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildInstances() {
        try {
            final ArrayList<InstanceMetaDataContext> metaDataCtxs = new ArrayList<InstanceMetaDataContext>();
            this.log.debug((Object)("Looking for the WEB-INF path of " + this.pwa.getId()));
            final String webInfPath = this.pwa.getServletContext().getRealPath("/WEB-INF");
            if (webInfPath != null) {
                File webInfFile = new File(webInfPath);
                URL webInfURL = webInfFile.toURL();
                URLNavigator.visit((URL)webInfURL, (URLVisitor)new URLVisitor(){

                    public void startDir(URL url, String name) {
                    }

                    public void endDir(URL url, String name) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void file(URL url, String name) {
                        boolean logged = false;
                        if (name.endsWith("-object.xml")) {
                            BufferedInputStream in = null;
                            try {
                                in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
                                DocumentBuilder builder = XMLTools.getDocumentBuilderFactory().newDocumentBuilder();
                                EntityResolver entityResolver = PortletAppDeployment.this.factory.getPortalObjectEntityResolver();
                                if (entityResolver == null) {
                                    PortletAppDeployment.this.log.debug((Object)("Coult not obtain entity resolver for " + url));
                                    entityResolver = new NullEntityResolver();
                                } else {
                                    PortletAppDeployment.this.log.debug((Object)("Obtained entity resolver " + entityResolver + " for " + url));
                                }
                                builder.setEntityResolver(entityResolver);
                                Document doc = builder.parse(in);
                                Element deploymentsElt = doc.getDocumentElement();
                                Iterator i = XMLTools.getChildrenIterator((Element)deploymentsElt, (String)"deployment");
                                while (i.hasNext()) {
                                    InstanceMetaData metaData;
                                    Element deploymentElt = (Element)i.next();
                                    Element instanceElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"instance", (boolean)false);
                                    if (instanceElt == null) continue;
                                    if (!logged) {
                                        PortletAppDeployment.this.log.debug((Object)("Found -object.xml containing instances, you need to convert and move them to the file " + webInfPath + "/portlet-instances.xml"));
                                        logged = true;
                                    }
                                    if ((metaData = InstanceMetaData.buildLegacyMetaData(instanceElt, PortletAppDeployment.this.pwa.getId())) == null) continue;
                                    InstanceMetaDataContext metaDataCtx = new InstanceMetaDataContext(metaData, 1);
                                    metaDataCtxs.add(metaDataCtx);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                IOTools.safeClose((Closeable)in);
                            }
                        }
                    }
                });
            } else {
                this.log.debug((Object)"No real path found");
            }
            if (metaDataCtxs.size() > 0) {
                DocumentBuilder builder = XMLTools.getDocumentBuilderFactory().newDocumentBuilder();
                Document doc = builder.newDocument();
                Element deployments = (Element)doc.appendChild(doc.createElement("deployments"));
                for (int i = 0; i < metaDataCtxs.size(); ++i) {
                    InstanceMetaDataContext metaDataCtx = (InstanceMetaDataContext)metaDataCtxs.get(i);
                    InstanceMetaData instanceMD = metaDataCtx.metaData;
                    Element deploymentElt = (Element)deployments.appendChild(doc.createElement("deployment"));
                    Element instanceElt = (Element)deploymentElt.appendChild(doc.createElement("instance"));
                    Element instanceIdElt = (Element)instanceElt.appendChild(doc.createElement("instance-id"));
                    instanceIdElt.appendChild(doc.createTextNode(instanceMD.getId()));
                    Element portletRefElt = (Element)instanceElt.appendChild(doc.createElement("portlet-ref"));
                    portletRefElt.appendChild(doc.createTextNode(instanceMD.getPortletRef()));
                }
                String migratedContent = XMLTools.toString((Document)doc, (boolean)false, (boolean)true, (boolean)true, (String)"utf-8");
                this.log.info((Object)("These instances have been found in -object.xml, you should put them in the file " + webInfPath + "/portlet-instances.xml"));
                this.log.info((Object)migratedContent);
            }
            BufferedInputStream in = null;
            try {
                in = IOTools.safeBufferedWrapper((InputStream)this.pwa.getServletContext().getResourceAsStream("/WEB-INF/portlet-instances.xml"));
                if (in != null) {
                    DocumentBuilder builder = XMLTools.getDocumentBuilderFactory().newDocumentBuilder();
                    EntityResolver entityResolver = this.factory.getPortletInstancesEntityResolver();
                    if (entityResolver == null) {
                        this.log.debug((Object)"Coult not obtain entity resolver for portlet-instances.xml");
                        entityResolver = new NullEntityResolver();
                    } else {
                        this.log.debug((Object)("Obtained entity resolver " + entityResolver + " for portlet-instances.xml"));
                    }
                    builder.setEntityResolver(entityResolver);
                    Document doc = builder.parse(in);
                    Iterator i = XMLTools.getChildrenIterator((Element)doc.getDocumentElement(), (String)"deployment");
                    while (i.hasNext()) {
                        Element deploymentElt = (Element)i.next();
                        Element instanceElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"instance", (boolean)true);
                        InstanceMetaData metaData = InstanceMetaData.buildMetaData(instanceElt, this.pwa);
                        Element ifExistsElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"if-exists", (boolean)false);
                        int ifExists = 1;
                        if (ifExistsElt != null) {
                            String tmp = XMLTools.asString((Element)ifExistsElt);
                            if ("overwrite".equals(tmp)) {
                                ifExists = 0;
                            } else if ("keep".equals(tmp)) {
                                ifExists = 1;
                            }
                        }
                        InstanceMetaDataContext metaDataCtx = new InstanceMetaDataContext(metaData, ifExists);
                        metaDataCtxs.add(metaDataCtx);
                    }
                }
            }
            catch (Throwable throwable) {
                IOTools.safeClose(in);
                throw throwable;
            }
            IOTools.safeClose((Closeable)in);
            if (metaDataCtxs.size() > 0) {
                this.createInstances(metaDataCtxs);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error when creating instances", (Throwable)e);
        }
    }

    private void createInstances(List metaDataCtxs) throws Exception {
        for (int i = 0; i < metaDataCtxs.size(); ++i) {
            String msg;
            InstanceMetaDataContext metaDataCtx = (InstanceMetaDataContext)metaDataCtxs.get(i);
            try {
                this.handleInstance(metaDataCtx);
                continue;
            }
            catch (NoSuchPortletException e) {
                msg = "Failed to create instance " + metaDataCtx.metaData.getId() + " of portlet " + e.getPortletId() + " because portlet " + e.getPortletId() + " is not available";
                this.log.warn((Object)msg);
                this.log.debug((Object)msg, (Throwable)e);
                continue;
            }
            catch (InvalidPortletIdException e) {
                msg = "Failed to create instance " + metaDataCtx.metaData.getId() + " of portlet " + e.getPortletId() + " because portlet id " + e.getPortletId() + " is invalid";
                this.log.warn((Object)msg);
                this.log.debug((Object)msg, (Throwable)e);
                continue;
            }
            catch (PortletInvokerException e) {
                msg = "Failed to create instance " + metaDataCtx.metaData.getId() + " of portlet";
                this.log.warn((Object)msg);
                this.log.debug((Object)msg, (Throwable)e);
                continue;
            }
            catch (DuplicateInstanceException e) {
                msg = "Instance " + metaDataCtx.metaData.getId() + " already exists";
                this.log.warn((Object)msg);
                this.log.debug((Object)msg, (Throwable)e);
                continue;
            }
            catch (SecurityConfigurationException e) {
                msg = "Cannot configure security of instance " + metaDataCtx.metaData.getId();
                this.log.warn((Object)msg);
                this.log.debug((Object)msg, (Throwable)e);
            }
        }
    }

    private void org$jboss$portal$core$deployment$jboss$PortletAppDeployment$handleInstance$aop(InstanceMetaDataContext metaDataCtx) throws PortletInvokerException, SecurityConfigurationException, DuplicateInstanceException {
        InstanceMetaData metaData = metaDataCtx.metaData;
        InstanceDefinition instance = this.factory.getInstanceContainer().getDefinition(metaData.getId());
        if (instance == null) {
            this.createInstance(metaData);
        } else if (metaDataCtx.ifExists == 0) {
            this.log.debug((Object)("Reconfiguring instance " + metaData.getId() + " that already exists"));
            try {
                this.configureInstance(instance, metaData);
            }
            catch (NoSuchPortletException e) {
                try {
                    this.factory.getInstanceContainer().destroyDefinition(metaData.getId());
                }
                catch (NoSuchInstanceException e1) {
                    this.log.error((Object)" Can't redeploy. Portlet has changed context");
                }
                this.createInstance(metaData);
            }
        } else {
            this.log.debug((Object)("Instance " + metaData.getId() + " exists"));
        }
        if ("/osivia-portal-administration".equals(this.pwa.getContextPath())) {
            try {
                Class<?> migrationClass = Class.forName("org.osivia.portal.core.migration.IMigrationManager");
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                Object mbean = MBeanProxy.get(migrationClass, (ObjectName)new ObjectName("osivia:service=MigrationService"), (MBeanServer)mbeanServer);
                String aMethod = "migrate";
                Class[] params = new Class[]{};
                Object[] paramsObj = new Object[]{};
                Method thisMethod = mbean.getClass().getDeclaredMethod(aMethod, params);
                thisMethod.invoke(mbean, paramsObj);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void configureInstance(Instance instance, InstanceMetaData metaData) throws PortletInvokerException, SecurityConfigurationException {
        SecurityConstraintsMetaData securityConstraints;
        ArrayList<PropertyChange> changes = new ArrayList<PropertyChange>();
        PortletPreferencesMetaData preferencesMetaData = metaData.getPreferences();
        PropertyMap propertyMap = instance.getProperties();
        if (propertyMap != null && propertyMap.size() > 0) {
            for (String key : propertyMap.keySet()) {
                if (preferencesMetaData != null && preferencesMetaData.getPortletPreferences() != null && preferencesMetaData.getPortletPreferences().get(key) != null) continue;
                changes.add(PropertyChange.newReset((String)key));
            }
        }
        if (preferencesMetaData != null && preferencesMetaData.getPortletPreferences() != null && preferencesMetaData.getPortletPreferences().size() > 0) {
            for (PortletPreferenceMetaData preference : preferencesMetaData.getPortletPreferences().values()) {
                List preferenceValues = preference.getValue();
                changes.add(PropertyChange.newUpdate((String)preference.getName(), (String[])preferenceValues.toArray(new String[preferenceValues.size()])));
            }
        }
        if (changes.size() > 0) {
            instance.setProperties(changes.toArray(new PropertyChange[changes.size()]));
        }
        if ((securityConstraints = metaData.getSecurityConstraints()) == null) {
            securityConstraints = new SecurityConstraintsMetaData();
            securityConstraints.getConstraints().add(new RoleSecurityBinding("view", SecurityConstants.UNCHECKED_ROLE_NAME));
        }
        AuthorizationDomain authDomain = instance.getContainer().getAuthorizationDomain();
        DomainConfigurator domainConfigurator = authDomain.getConfigurator();
        domainConfigurator.setSecurityBindings(instance.getId(), securityConstraints.getConstraints());
    }

    private void createInstance(InstanceMetaData metaData) throws PortletInvokerException, DuplicateInstanceException, SecurityConfigurationException {
        this.log.debug((Object)("Creating portlet instance " + metaData.getId()));
        metaData.setPortletRef(this.resolvePortletRef(metaData.getPortletRef()));
        InstanceDefinition instance = this.factory.getInstanceContainer().createDefinition(metaData);
        this.configureInstance(instance, metaData);
    }

    private String resolvePortletRef(String ref) {
        return "local." + this.getAppId() + "." + ref;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        PortletAppDeployment portletAppDeployment = this;
        synchronized (portletAppDeployment) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        PortletAppDeployment portletAppDeployment = this;
        synchronized (portletAppDeployment) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    private void handleInstance(InstanceMetaDataContext instanceMetaDataContext) throws PortletInvokerException, SecurityConfigurationException, DuplicateInstanceException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_handleInstance2257800355530988303.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            handleInstance_2257800355530988303 handleInstance_22578003555309883032 = new handleInstance_2257800355530988303(methodInfo, interceptorArray);
            handleInstance_22578003555309883032.arg0 = instanceMetaDataContext;
            handleInstance_22578003555309883032.setTargetObject((Object)this);
            handleInstance_22578003555309883032.typedTargetObject = this;
            handleInstance_22578003555309883032.setAdvisor((Advisor)aop$classAdvisor$aop);
            handleInstance_22578003555309883032.invokeNext();
        } else {
            this.org$jboss$portal$core$deployment$jboss$PortletAppDeployment$handleInstance$aop(instanceMetaDataContext);
        }
    }

    private class InstanceMetaDataContext {
        private InstanceMetaData metaData;
        private int ifExists;

        public InstanceMetaDataContext(InstanceMetaData metaData, int ifExists) {
            this.metaData = metaData;
            this.ifExists = ifExists;
        }
    }

    public static class handleInstance_2257800355530988303
    extends MethodInvocation
    implements Untransformable {
        public InstanceMetaDataContext arg0;
        public PortletAppDeployment typedTargetObject;

        public handleInstance_2257800355530988303(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public handleInstance_2257800355530988303(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public handleInstance_2257800355530988303(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public handleInstance_2257800355530988303() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$jboss$portal$core$deployment$jboss$PortletAppDeployment$handleInstance$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (InstanceMetaDataContext)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            handleInstance_2257800355530988303 handleInstance_22578003555309883032 = new handleInstance_2257800355530988303(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            handleInstance_22578003555309883032.arguments = this.arguments;
            ((InvocationBase)handleInstance_22578003555309883032).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)handleInstance_22578003555309883032).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)handleInstance_22578003555309883032).instanceResolver = ((InvocationBase)this).instanceResolver;
            handleInstance_22578003555309883032.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)handleInstance_22578003555309883032).targetObject = ((InvocationBase)this).targetObject;
            handleInstance_22578003555309883032.arg0 = this.arg0;
            return handleInstance_22578003555309883032;
        }
    }
}

