/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal;

import java.io.Serializable;
import org.jboss.portal.core.model.portal.PortalObjectPath;

public class PortalObjectId
implements Comparable,
Serializable {
    private final String namespace;
    private final PortalObjectPath path;
    private Integer hashCode;
    private String toStringCanonicalFormat;
    private String toStringLegacyFormat;
    public static final char NAMESPACE_SEPARATOR = ':';

    public PortalObjectId(String namespace, PortalObjectPath path) throws IllegalArgumentException {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
        this.path = path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PortalObjectPath getPath() {
        return this.path;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = new Integer(this.namespace.hashCode() + this.path.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PortalObjectId) {
            PortalObjectId that = (PortalObjectId)obj;
            return this.namespace.equals(that.namespace) && this.path.equals(that.path);
        }
        return false;
    }

    public static PortalObjectId parse(String idValue, PortalObjectPath.Format format) throws IllegalArgumentException {
        if (idValue == null) {
            throw new IllegalArgumentException("No null id value accepted");
        }
        int pos = idValue.indexOf(58);
        if (pos == -1) {
            return PortalObjectId.parse("", idValue, format);
        }
        String namespace = idValue.substring(0, pos);
        String pathValue = idValue.substring(pos + 1);
        return PortalObjectId.parse(namespace, pathValue, format);
    }

    public static PortalObjectId parse(String namespace, String pathValue, PortalObjectPath.Format format) throws IllegalArgumentException {
        return new PortalObjectId(namespace, PortalObjectPath.parse(pathValue, format));
    }

    public String toString() {
        return this.toString(PortalObjectPath.CANONICAL_FORMAT);
    }

    public String toString(PortalObjectPath.Format format) throws IllegalArgumentException {
        if (format == null) {
            throw new IllegalArgumentException("No null format accepted");
        }
        if (format == PortalObjectPath.LEGACY_FORMAT) {
            if (this.toStringLegacyFormat == null) {
                this.toStringLegacyFormat = PortalObjectId.toString(this.namespace, this.path, format);
            }
            return this.toStringLegacyFormat;
        }
        if (format == PortalObjectPath.CANONICAL_FORMAT) {
            if (this.toStringCanonicalFormat == null) {
                this.toStringCanonicalFormat = PortalObjectId.toString(this.namespace, this.path, format);
            }
            return this.toStringCanonicalFormat;
        }
        return PortalObjectId.toString(this.namespace, this.path, format);
    }

    public static String toString(String namespace, PortalObjectPath path, PortalObjectPath.Format format) throws IllegalArgumentException {
        if (namespace == null) {
            throw new IllegalArgumentException("No null namespace accepted");
        }
        if (path == null) {
            throw new IllegalArgumentException("No null path accepted");
        }
        if (namespace.length() > 0) {
            return namespace + ':' + path.toString(format);
        }
        return path.toString(format);
    }

    public int compareTo(Object o) {
        PortalObjectId that = (PortalObjectId)o;
        int order = this.namespace.compareTo(that.namespace);
        return order != 0 ? order : this.path.compareTo(that.path);
    }

    public PortalObjectId getChildId(String name) {
        return new PortalObjectId(this.getNamespace(), this.getPath().getChild(name));
    }
}

