/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.action;

import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.command.info.ActionCommandInfo;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.PageCommand;
import org.jboss.portal.core.model.portal.command.response.UpdatePageResponse;
import org.jboss.portal.identity.User;

public class ImportPageToDashboardCommand
extends PageCommand {
    private static final CommandInfo info = new ActionCommandInfo(false);
    private Portal dashboardPortal;

    public ImportPageToDashboardCommand(PortalObjectId pageId) {
        super(pageId);
    }

    public CommandInfo getInfo() {
        return info;
    }

    protected Page initPage() {
        return (Page)this.getTarget();
    }

    public void acquireResources() throws NoSuchResourceException {
        super.acquireResources();
        CustomizationManager manager = this.getControllerContext().getController().getCustomizationManager();
        User user = this.getControllerContext().getUser();
        this.dashboardPortal = manager.getDashboard(user);
    }

    public ControllerResponse execute() throws ControllerException {
        String name = this.target.getName();
        PortalObject dashboardPage = this.dashboardPortal.getChild(name);
        if (dashboardPage == null) {
            try {
                dashboardPage = this.target.copy(this.dashboardPortal, name, false);
                for (PortalObject child : this.target.getChildren()) {
                    if (child.getType() != 3) continue;
                    child.copy(dashboardPage, child.getName(), false);
                }
            }
            catch (DuplicatePortalObjectException e) {
                log.error((Object)"Unexpected exception during the copy of a page to a dashboard page", (Throwable)e);
                throw new ControllerException(e);
            }
        }
        return new UpdatePageResponse(dashboardPage.getId());
    }
}

