/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.metadata.coordination;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.controller.coordination.IllegalCoordinationException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PageContainer;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationAliasBindingMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationEventWiringMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationParameterBindingMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationWindowMultiQNameMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationWindowSimpleQNameMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationMetaData {
    private String implicitModeEvent;
    private String implicitModeParameter;
    List<CoordinationParameterBindingMetaData> parameterBindings = new LinkedList<CoordinationParameterBindingMetaData>();
    List<CoordinationAliasBindingMetaData> aliasBindings = new LinkedList<CoordinationAliasBindingMetaData>();
    List<CoordinationEventWiringMetaData> wirings = new LinkedList<CoordinationEventWiringMetaData>();

    public static CoordinationMetaData buildMetaData(Element coordinationElt) {
        Element bindingsElement;
        CoordinationMetaData coordinationMetaData = new CoordinationMetaData();
        Element wiringsElement = XMLTools.getUniqueChild((Element)coordinationElt, (String)"wirings", (boolean)false);
        if (wiringsElement != null) {
            Element wiringImplicitModeElt = XMLTools.getUniqueChild((Element)wiringsElement, (String)"implicit-mode", (boolean)false);
            if (wiringImplicitModeElt != null) {
                coordinationMetaData.setImplicitModeEvent(XMLTools.asString((Element)wiringImplicitModeElt));
            }
            coordinationMetaData.setWirings(CoordinationMetaData.buildWiringsMetaData(wiringsElement));
        }
        if ((bindingsElement = XMLTools.getUniqueChild((Element)coordinationElt, (String)"bindings", (boolean)false)) != null) {
            Element parameterImplicitModeElt = XMLTools.getUniqueChild((Element)bindingsElement, (String)"implicit-mode", (boolean)false);
            if (parameterImplicitModeElt != null) {
                coordinationMetaData.setImplicitModeParameter(XMLTools.asString((Element)parameterImplicitModeElt));
            }
            Iterator paramBindingsIter = XMLTools.getChildrenIterator((Element)bindingsElement, (String)"parameter-binding");
            while (paramBindingsIter.hasNext()) {
                Element bindingElement = (Element)paramBindingsIter.next();
                coordinationMetaData.addParameterBinding(CoordinationParameterBindingMetaData.buildMetaData(bindingElement));
            }
            Iterator aliasBindingsIter = XMLTools.getChildrenIterator((Element)bindingsElement, (String)"alias-binding");
            while (aliasBindingsIter.hasNext()) {
                Element aliasElement = (Element)aliasBindingsIter.next();
                coordinationMetaData.addAliasBinding(CoordinationAliasBindingMetaData.buildMetaData(aliasElement));
            }
        }
        return coordinationMetaData;
    }

    private static List<CoordinationEventWiringMetaData> buildWiringsMetaData(Element wiringsElement) {
        LinkedList<CoordinationEventWiringMetaData> w = new LinkedList<CoordinationEventWiringMetaData>();
        Iterator wiringsIter = XMLTools.getChildrenIterator((Element)wiringsElement, (String)"event-wiring");
        while (wiringsIter.hasNext()) {
            Element element = (Element)wiringsIter.next();
            w.add(CoordinationEventWiringMetaData.buildMetaData(element));
        }
        return w;
    }

    public void configure(BuildContext buildContext, PortalObject object) throws IllegalCoordinationException {
        if (this.getImplicitModeEvent() != null) {
            buildContext.getCoordinationConfigurator().setEventWiringImplicitMode((PageContainer)object, Boolean.valueOf(this.getImplicitModeEvent()));
        }
        if (this.getImplicitModeParameter() != null) {
            buildContext.getCoordinationConfigurator().setParameterBindingImplicitMode((PageContainer)object, Boolean.valueOf(this.getImplicitModeParameter()));
        }
        if (object instanceof Page) {
            Page page = (Page)object;
            for (CoordinationParameterBindingMetaData parameterBinding : this.parameterBindings) {
                HashMap<Window, Set<QName>> bindings = new HashMap<Window, Set<QName>>();
                for (CoordinationWindowMultiQNameMetaData windowMD : parameterBinding.getWindows()) {
                    String windowName = windowMD.getWindowName();
                    Window window = page.getWindow(windowName);
                    if (window == null) {
                        throw new IllegalCoordinationException("Cannot obtain window: \"" + windowName + "\" on page: " + page.getName());
                    }
                    bindings.put(window, windowMD.getNames());
                }
                buildContext.getCoordinationConfigurator().setParameterBinding(parameterBinding.getName(), bindings);
            }
            for (CoordinationAliasBindingMetaData windowBinding : this.aliasBindings) {
                buildContext.getCoordinationConfigurator().setAliasBinding(page, windowBinding.getName(), windowBinding.getQnames());
            }
            for (CoordinationEventWiringMetaData wiring : this.wirings) {
                HashMap<Window, QName> sources = new HashMap<Window, QName>();
                HashMap<Window, QName> destinations = new HashMap<Window, QName>();
                CoordinationMetaData.populateWindows(sources, wiring.getSources(), page);
                CoordinationMetaData.populateWindows(destinations, wiring.getDestinations(), page);
                buildContext.getCoordinationConfigurator().setEventWiring(sources, destinations, wiring.getName());
            }
        }
    }

    private static void populateWindows(Map<Window, QName> map, List<CoordinationWindowSimpleQNameMetaData> windows, Page page) throws IllegalCoordinationException {
        for (CoordinationWindowSimpleQNameMetaData windowMD : windows) {
            QName name = windowMD.getQname();
            Window window = page.getWindow(windowMD.getWindowName());
            if (window == null) {
                throw new IllegalCoordinationException("Cannot obtain window: \"" + windowMD.getWindowName() + "\" on page: " + page.getName());
            }
            map.put(window, name);
        }
    }

    public String getImplicitModeEvent() {
        return this.implicitModeEvent;
    }

    public void setImplicitModeEvent(String implicitModeEvent) {
        this.implicitModeEvent = implicitModeEvent;
    }

    public String getImplicitModeParameter() {
        return this.implicitModeParameter;
    }

    public void setImplicitModeParameter(String implicitModeParameter) {
        this.implicitModeParameter = implicitModeParameter;
    }

    public List<CoordinationEventWiringMetaData> getWirings() {
        return this.wirings;
    }

    public void setWirings(List<CoordinationEventWiringMetaData> wirings) {
        this.wirings = wirings;
    }

    public void addWirings(CoordinationEventWiringMetaData wiring) {
        this.wirings.add(wiring);
    }

    public List<CoordinationParameterBindingMetaData> getParameterBindings() {
        return this.parameterBindings;
    }

    public void setParameterBindings(List<CoordinationParameterBindingMetaData> parameterBindings) {
        this.parameterBindings = parameterBindings;
    }

    public void addParameterBinding(CoordinationParameterBindingMetaData binding) {
        this.parameterBindings.add(binding);
    }

    public List<CoordinationAliasBindingMetaData> getAliasBindings() {
        return this.aliasBindings;
    }

    public void setAliasBindings(List<CoordinationAliasBindingMetaData> aliasBindings) {
        this.aliasBindings = aliasBindings;
    }

    public void addAliasBinding(CoordinationAliasBindingMetaData aliasBinding) {
        this.aliasBindings.add(aliasBinding);
    }
}

