/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.invocation.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.portal.common.invocation.AttributeResolver;

public abstract class AbstractSessionAttributeResolver
implements AttributeResolver {
    protected final HttpServletRequest req;

    public AbstractSessionAttributeResolver(HttpServletRequest req) {
        if (req == null) {
            throw new IllegalArgumentException();
        }
        this.req = req;
    }

    public Set getKeys() {
        Map map = this.getMap(false);
        if (map != null) {
            return map.keySet();
        }
        return Collections.EMPTY_SET;
    }

    public Object getAttribute(Object attrKey) throws IllegalArgumentException {
        if (attrKey == null) {
            throw new IllegalArgumentException();
        }
        Object value = null;
        Map map = this.getMap(false);
        if (map != null) {
            value = map.get(attrKey);
        }
        return value;
    }

    public void setAttribute(Object attrKey, Object attrValue) throws IllegalArgumentException {
        if (attrKey == null) {
            throw new IllegalArgumentException();
        }
        Map map = this.getMap(false);
        if (map != null) {
            if (attrValue != null) {
                map.put(attrKey, attrValue);
            } else {
                map.remove(attrKey);
            }
        } else if (attrValue != null) {
            map = this.getMap(true);
            map.put(attrKey, attrValue);
        }
    }

    protected abstract String getMapKey();

    protected Map createMap(String mapKey) {
        return new HashMap();
    }

    private Map getMap(boolean create) {
        HttpSession session = this.req.getSession(create);
        if (session != null) {
            String mapKey = this.getMapKey();
            Map map = (Map)session.getAttribute(mapKey);
            if (map == null) {
                map = this.createMap(mapKey);
                session.setAttribute(mapKey, (Object)map);
            }
            return map;
        }
        return null;
    }
}

