/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.ldap.LDAPConnectionContext;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.jboss.portal.identity.service.UserModuleService;

public abstract class LDAPUserModule
extends UserModuleService {
    private static final Logger log = Logger.getLogger(LDAPUserModule.class);
    private LDAPConnectionContext connectionContext;
    private UserProfileModule userProfileModule;

    public void start() throws Exception {
        if (this.getConnectionJNDIName() == null) {
            throw new IdentityException("Cannot obtain ldap connection context JNDI name");
        }
        try {
            this.connectionContext = (LDAPConnectionContext)new InitialContext().lookup(this.getConnectionJNDIName());
        }
        catch (NamingException e) {
            log.error((Object)"Couldn't obtain connection context");
        }
        super.start();
    }

    public void updatePassword(LDAPUserImpl ldapu, String password) throws IdentityException {
        if (!(password != null && password.length() != 0 || this.isAllowEmptyPasswords())) {
            throw new IdentityException("Cannot update password with empty value - please set proper option to allow this");
        }
        String attributeName = this.getPasswordAttributeId();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        String passwordString = password;
        if (this.getEnclosePasswordWith() != null) {
            String enc = this.getEnclosePasswordWith();
            passwordString = enc + passwordString + enc;
        }
        byte[] encodedPassword = null;
        if (this.getPasswordEncoding() != null && passwordString != null) {
            try {
                encodedPassword = passwordString.getBytes(this.getPasswordEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new IdentityException("Error while encoding password with configured setting: " + this.getPasswordEncoding(), e);
            }
        }
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute attr = new BasicAttribute(attributeName);
            if (encodedPassword != null) {
                attr.add(encodedPassword);
            } else {
                attr.add(passwordString);
            }
            attrs.put(attr);
            if (this.getUpdatePasswordAttributeValues() != null && this.getUpdatePasswordAttributeValues().size() > 0) {
                Map attributesToAdd = this.getUpdatePasswordAttributeValues();
                for (Map.Entry entry : attributesToAdd.entrySet()) {
                    BasicAttribute additionalAttr = new BasicAttribute((String)entry.getKey());
                    for (String val : (Set)entry.getValue()) {
                        additionalAttr.add(val);
                    }
                    attrs.put(additionalAttr);
                }
            }
            ldapContext.modifyAttributes(ldapu.getDn(), 2, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot set user password value.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validatePassword(LDAPUserImpl ldapu, String password) throws IdentityException {
        if ((password == null || password.length() == 0) & !this.isAllowEmptyPasswords()) {
            return false;
        }
        String principal = ldapu.getDn();
        if (this.getPrincipalPreffix() != null || this.getPrincipalSuffix() != null) {
            String suffix;
            String preffix = this.getPrincipalPreffix();
            if (preffix == null) {
                preffix = "";
            }
            if ((suffix = this.getPrincipalSuffix()) == null) {
                suffix = "";
            }
            principal = preffix + ldapu.getUserName() + suffix;
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            Hashtable<?, ?> env = ldapContext.getEnvironment();
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", password);
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            if (ctx != null) {
                ctx.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (NamingException e) {
            try {
                ldapContext.close();
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", e2);
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return false;
    }

    public LDAPUserImpl createUserInstance(Attributes attrs, String dn) throws IdentityException {
        LDAPUserImpl ldapu = null;
        try {
            Attribute uida = attrs.get(this.getUidAttributeID());
            if (uida == null) {
                throw new IdentityException("LDAP entry doesn't contain proper attribute:" + this.getUidAttributeID());
            }
            ldapu = new LDAPUserImpl(dn, this.getIdentityContext(), dn);
            if (this.isUserNameToLowerCase()) {
                ldapu.setUserName(uida.get().toString().toLowerCase());
            } else {
                ldapu.setUserName(uida.get().toString());
            }
            log.debug((Object)("user uid: " + ldapu.getId()));
            log.debug((Object)("user dn: " + ldapu.getDn()));
        }
        catch (Exception e) {
            throw new IdentityException("Couldn't create LDAPUserImpl object from ldap entry (SearchResult)", e);
        }
        return ldapu;
    }

    public User findUserByDN(String dn) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("findUserByDN(): DN = " + dn));
            if (dn == null) {
                throw new IdentityException("User dn canot be null");
            }
            Attributes attrs = ldapContext.getAttributes(dn);
            if (attrs == null) {
                throw new IdentityException("Can't find user entry with DN: " + dn);
            }
            LDAPUserImpl lDAPUserImpl = this.createUserInstance(attrs, dn);
            return lDAPUserImpl;
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("No user found with dn: " + dn), (Throwable)e);
        }
        catch (NamingException e) {
            throw new IdentityException("User search failed.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return null;
    }

    public abstract List searchUsers(String var1, Object[] var2) throws NamingException, IdentityException;

    protected UserProfileModule getUserProfileModule() throws IdentityException {
        if (this.userProfileModule == null) {
            this.userProfileModule = (UserProfileModule)this.getIdentityContext().getObject("UserProfile");
        }
        return this.userProfileModule;
    }

    protected String getUidAttributeID() throws IdentityException {
        String uid = this.getIdentityConfiguration().getValue("uidAttributeID");
        if (uid == null) {
            return "uid";
        }
        return uid;
    }

    protected LDAPConnectionContext getConnectionContext() throws IdentityException {
        if (this.connectionContext == null) {
            throw new IdentityException("No LDAPConnectionContext available");
        }
        return this.connectionContext;
    }

    protected String getContainerDN() throws IdentityException {
        String cont = this.getIdentityConfiguration().getValue("userCtxDN");
        if (cont == null) {
            throw new IdentityException("Configuration option missing: userCtxDN");
        }
        return cont;
    }

    protected String getPrincipalPreffix() throws IdentityException {
        return this.getIdentityConfiguration().getValue("principalDNPrefix");
    }

    protected String getPrincipalSuffix() throws IdentityException {
        return this.getIdentityConfiguration().getValue("principalDNSuffix");
    }

    protected String getPasswordAttributeId() throws IdentityException {
        String passwd = this.getIdentityConfiguration().getValue("passwordAttributeID");
        if (passwd == null) {
            return "userPassword";
        }
        return passwd;
    }

    protected String getUserSearchFilter() throws IdentityException {
        String searchFilter = this.getIdentityConfiguration().getValue("userSearchFilter");
        if (searchFilter == null) {
            throw new IdentityException("userSearchFilter missing in configuration");
        }
        return searchFilter;
    }

    protected String getUserSearchCtxDN() throws IdentityException {
        String searchCtx = this.getIdentityConfiguration().getValue("userCtxDN");
        if (searchCtx == null) {
            throw new IdentityException("userCtxDN missing in configuration");
        }
        return searchCtx;
    }

    protected int getSearchTimeLimit() throws IdentityException {
        int searchTimeout = 10000;
        String limit = this.getIdentityConfiguration().getValue("searchTimeLimit");
        if (limit != null) {
            try {
                searchTimeout = Integer.parseInt(limit);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("searchTimeLimitwrong value falling back to defaults:" + e));
            }
        }
        return searchTimeout;
    }

    protected int getSearchScope() throws IdentityException {
        int searchScope = 1;
        String scope = this.getIdentityConfiguration().getValue("userCtxDN");
        if (scope != null) {
            if ("OBJECT_SCOPE".equalsIgnoreCase(scope)) {
                searchScope = 0;
            } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                searchScope = 1;
            } else if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                searchScope = 2;
            }
        }
        return searchScope;
    }

    protected boolean isAllowEmptyPasswords() {
        String allowEmptyPasswords = this.getIdentityConfiguration().getValue("allowEmptyPasswords");
        if (allowEmptyPasswords != null && allowEmptyPasswords.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected boolean isUserNameToLowerCase() {
        String userNameToLowerCase = this.getIdentityConfiguration().getValue("userNameToLowerCase");
        if (userNameToLowerCase != null && userNameToLowerCase.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected boolean isSetPasswordAfterUserCreate() {
        String userNameToLowerCase = this.getIdentityConfiguration().getValue("setPasswordAfterUserCreate");
        if (userNameToLowerCase != null && userNameToLowerCase.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Map getAttributesToAdd() throws IdentityException {
        Map attributesToAdd = this.getIdentityConfiguration().getOptions("userCreateAttibutes");
        if (attributesToAdd == null) {
            throw new IdentityException("userCreateAttibutes missing in configuration");
        }
        return attributesToAdd;
    }

    public void setConnectionContext(LDAPConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    protected String getPasswordEncoding() throws IdentityException {
        String encoding = this.getIdentityConfiguration().getValue("passwordEncoding");
        return encoding;
    }

    protected Map getUpdatePasswordAttributeValues() throws IdentityException {
        Map attributesToAdd = this.getIdentityConfiguration().getOptions("passwordUpdateAttributeValues");
        return attributesToAdd;
    }

    protected String getEnclosePasswordWith() throws IdentityException {
        String enc = this.getIdentityConfiguration().getValue("enclosePasswordWith");
        return enc;
    }
}

