/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import com.sun.mail.smtp.SMTPTransport;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterInstance;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.StartProcedureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.TransformationFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.UpdateProcedureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetTasksCommand;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Name;
import javax.portlet.PortletContext;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class FormsServiceImpl
implements IFormsService {
    private static ThreadLocal<ThreadLocalContainer> threadLocal = new ThreadLocal();
    private final DefaultCMSCustomizer cmsCustomizer;
    private final Log log;
    private final ICMSServiceLocator cmsServiceLocator;
    private final ITasksService tasksService;
    private final IBundleFactory bundleFactory;
    private final PersonService personService;
    private final GroupService groupService;

    public FormsServiceImpl(DefaultCMSCustomizer cmsCustomizer) {
        this.cmsCustomizer = cmsCustomizer;
        this.log = LogFactory.getLog(this.getClass());
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        this.tasksService = (ITasksService)Locator.findMBean(ITasksService.class, (String)"osivia:service=TasksService");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        this.groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
    }

    public Map<String, String> start(PortalControllerContext portalControllerContext, String modelId, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.start(portalControllerContext, modelId, null, variables);
    }

    public Map<String, String> start(PortalControllerContext portalControllerContext, String modelId, String actionId, Map<String, String> variables) throws PortalException, FormFilterException {
        boolean endStep;
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        String modelWebId = "procedure_" + modelId;
        Document model = this.getModel(portalControllerContext, modelWebId);
        String procedureInitiator = portalControllerContext.getHttpServletRequest().getRemoteUser();
        String startingStep = model.getString("pcd:startingStep");
        PropertyMap startingStepProperties = this.getStepProperties(model, startingStep);
        PropertyMap actionProperties = this.getActionProperties(startingStepProperties, actionId);
        String nextStep = actionProperties.getString("stepReference");
        String title = "";
        ArrayList<String> actors = new ArrayList<String>();
        if (!StringUtils.equals((String)"endStep", (String)nextStep)) {
            PropertyMap nextStepProperties = this.getStepProperties(model, nextStep);
            title = nextStepProperties.getString("name");
            PropertyList groupsObjectsList = nextStepProperties.getList("authorizedGroups");
            if (groupsObjectsList != null) {
                for (Object groupsObject : groupsObjectsList.list()) {
                    actors.add((String)groupsObject);
                }
            }
        }
        if (variables == null) {
            variables = new HashMap<String, String>();
        }
        String uuid = UUID.randomUUID().toString();
        variables.put("uuid", uuid);
        this.requiredFieldsValidation(portalControllerContext, startingStepProperties, variables);
        FormFilterContext filterContext = this.callFilters(modelWebId, uuid, actionId, variables, actionProperties, actors, null, portalControllerContext, procedureInitiator, null, nextStep);
        if (!StringUtils.equals((String)"endStep", (String)filterContext.getNextStep())) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("pi:currentStep", actionProperties.getString("stepReference"));
            properties.put("pi:procedureModelWebId", modelWebId);
            properties.put("pi:globalVariablesValues", this.generateVariablesJSON(variables));
            StartProcedureCommand command = new StartProcedureCommand(title, filterContext.getActors(), filterContext.getAdditionalAuthorizations(), properties);
            try {
                this.cmsCustomizer.executeNuxeoCommand(cmsContext, command);
            }
            catch (CMSException e) {
                throw new PortalException((Exception)((Object)e));
            }
        }
        if (!(endStep = "endStep".equals(filterContext.getNextStep()))) {
            try {
                this.sendEmailNotification(portalControllerContext, uuid, procedureInitiator);
            }
            catch (CMSException e) {
                throw new PortalException((Exception)((Object)e));
            }
        }
        return filterContext.getVariables();
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, Document task, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, task, null, variables);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, Document task, String actionId, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, task.getProperties(), actionId, variables);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, PropertyMap taskProperties, Map<String, String> variables) throws PortalException, FormFilterException {
        return this.proceed(portalControllerContext, taskProperties, null, variables);
    }

    public Map<String, String> proceed(PortalControllerContext portalControllerContext, PropertyMap taskProperties, String actionId, Map<String, String> variables) throws PortalException, FormFilterException {
        Map updatedVariables;
        boolean deleteOnEnding;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        PropertyMap instanceProperties = taskProperties.getMap("nt:pi");
        String instancePath = instanceProperties.getString("ecm:path");
        String previousTaskInitiator = taskProperties.getString("nt:initiator");
        String modelWebId = instanceProperties.getString("pi:procedureModelWebId");
        Document model = this.getModel(portalControllerContext, modelWebId);
        String procedureInitiator = instanceProperties.getString("pi:procedureInitiator");
        String previousStep = instanceProperties.getString("pi:currentStep");
        PropertyMap previousStepProperties = this.getStepProperties(model, previousStep);
        PropertyMap actionProperties = this.getActionProperties(previousStepProperties, actionId);
        String nextStep = actionProperties.getString("stepReference");
        String title = "";
        ArrayList<String> actors = new ArrayList<String>();
        if (!StringUtils.equals((String)"endStep", (String)nextStep)) {
            PropertyMap nextStepProperties = this.getStepProperties(model, nextStep);
            title = nextStepProperties.getString("name");
            PropertyList groupsObjectsList = nextStepProperties.getList("authorizedGroups");
            if (groupsObjectsList != null) {
                for (Map.Entry groupsObject : groupsObjectsList.list()) {
                    actors.add((String)((Object)groupsObject));
                }
            }
        }
        Map globalVariableValuesMap = instanceProperties.getMap("pi:globalVariablesValues").map();
        HashMap<String, String> globalVariableValues = new HashMap<String, String>(globalVariableValuesMap.size());
        for (Map.Entry gvvEntry : globalVariableValuesMap.entrySet()) {
            globalVariableValues.put((String)gvvEntry.getKey(), String.valueOf(gvvEntry.getValue()));
        }
        if (variables == null) {
            variables = new HashMap<String, String>();
        }
        String procedureInstanceUuid = (String)globalVariableValues.get("uuid");
        this.requiredFieldsValidation(portalControllerContext, previousStepProperties, variables);
        FormFilterContext filterContext = this.callFilters(modelWebId, procedureInstanceUuid, actionId, variables, actionProperties, actors, globalVariableValues, portalControllerContext, procedureInitiator, previousTaskInitiator, nextStep);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("pi:currentStep", actionProperties.getString("stepReference"));
        properties.put("pi:procedureModelWebId", modelWebId);
        properties.put("pi:globalVariablesValues", this.generateVariablesJSON(globalVariableValues));
        UpdateProcedureCommand command = new UpdateProcedureCommand(instancePath, title, filterContext.getActors(), filterContext.getAdditionalAuthorizations(), properties);
        try {
            this.cmsCustomizer.executeNuxeoCommand(cmsContext, command);
        }
        catch (CMSException e) {
            throw new PortalException((Exception)((Object)e));
        }
        boolean endStep = "endStep".equals(filterContext.getNextStep());
        if (!endStep) {
            String uuid = (String)globalVariableValues.get("uuid");
            String initiator = portalControllerContext.getHttpServletRequest().getRemoteUser();
            try {
                this.sendEmailNotification(portalControllerContext, uuid, initiator);
            }
            catch (CMSException e) {
                throw new PortalException((Exception)((Object)e));
            }
        }
        if ((deleteOnEnding = BooleanUtils.toBoolean((String)((String)(updatedVariables = filterContext.getVariables()).get("deleteOnEnding")))) && endStep) {
            String savedScope = cmsContext.getScope();
            try {
                cmsContext.setScope("superuser_no_cache");
                cmsService.deleteDocument(cmsContext, instancePath);
            }
            catch (CMSException e) {
                throw new PortalException((Exception)((Object)e));
            }
            finally {
                cmsContext.setScope(savedScope);
            }
        }
        return updatedVariables;
    }

    private void requiredFieldsValidation(PortalControllerContext portalControllerContext, PropertyMap step, Map<String, String> variables) throws FormFilterException {
        Locale locale = portalControllerContext.getHttpServletRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        PropertyList fields = step.getList("globalVariablesReferences");
        for (int i = 0; i < fields.size(); ++i) {
            String name;
            String value;
            PropertyMap field = fields.getMap(i);
            boolean required = BooleanUtils.isTrue((Boolean)field.getBoolean("required"));
            if (!required || !StringUtils.isBlank((String)(value = variables.get(name = field.getString("variableName"))))) continue;
            String label = StringUtils.defaultIfEmpty((String)field.getString("superLabel"), (String)name);
            String message = bundle.getString("MESSAGE_MISSING_REQUIRED_FIELD_ERROR", new Object[]{label});
            throw new FormFilterException(message);
        }
    }

    private FormFilterContext callFilters(String modelWebId, String procedureInstanceUuid, String actionId, Map<String, String> variables, PropertyMap actionProperties, List<String> actors, Map<String, String> globalVariableValues, PortalControllerContext portalControllerContext, String procedureInitiator, String taskInitiator, String nextStep) throws FormFilterException {
        CustomizationPluginMgr pluginManager = this.cmsCustomizer.getPluginManager();
        Map<String, FormFilter> portalFilters = pluginManager.getFormFilters();
        PropertyList actionFilters = actionProperties.getList("filtersList");
        HashMap<String, ArrayList<FormFilterInstance>> filtersByParentPathMap = new HashMap<String, ArrayList<FormFilterInstance>>();
        HashMap filtersParams = new HashMap();
        for (Object filterObject : actionFilters.list()) {
            PropertyMap filterMap = (PropertyMap)filterObject;
            FormFilter filter = portalFilters.get(filterMap.getString("filterId"));
            if (filter == null) continue;
            FormFilterInstance filterInstance = new FormFilterInstance(filter, filterMap.getString("filterPath"), filterMap.getString("filterName"), filterMap.getString("filterInstanceId"));
            String parentPath = StringUtils.contains((String)filterInstance.getPath(), (char)',') ? StringUtils.substringBeforeLast((String)filterInstance.getPath(), (String)",") : "";
            ArrayList<FormFilterInstance> parentFiltersList = (ArrayList<FormFilterInstance>)filtersByParentPathMap.get(parentPath);
            if (parentFiltersList == null) {
                parentFiltersList = new ArrayList<FormFilterInstance>();
            }
            parentFiltersList.add(filterInstance);
            filtersByParentPathMap.put(parentPath, parentFiltersList);
            PropertyList argumentsList = filterMap.getList("argumentsList");
            if (argumentsList == null) continue;
            HashMap<String, String> filterParams = new HashMap<String, String>(argumentsList.size());
            for (int i = 0; i < argumentsList.size(); ++i) {
                PropertyMap argumentMap = argumentsList.getMap(i);
                if (!StringUtils.isNotBlank((String)argumentMap.getString("argumentName"))) continue;
                filterParams.put(argumentMap.getString("argumentName"), argumentMap.getString("argumentValue"));
            }
            filtersParams.put(filterInstance.getId(), filterParams);
        }
        FormFilterContext filterContext = new FormFilterContext(filtersParams, procedureInitiator, taskInitiator, nextStep);
        filterContext.setPortalControllerContext(portalControllerContext);
        filterContext.setModelWebId(modelWebId);
        filterContext.setProcedureInstanceUuid(procedureInstanceUuid);
        filterContext.setActionId(actionId);
        if (globalVariableValues != null) {
            globalVariableValues.putAll(variables);
            filterContext.setVariables(globalVariableValues);
        } else {
            filterContext.setVariables(variables);
        }
        if (CollectionUtils.isNotEmpty(actors)) {
            filterContext.getActors().addAll(actors);
        }
        FormFilterExecutor parentExecutor = new FormFilterExecutor(filtersByParentPathMap, "", "");
        parentExecutor.executeChildren(filterContext);
        return filterContext;
    }

    private Document getModel(PortalControllerContext portalControllerContext, String webId) throws PortalException {
        CMSItem cmsItem;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        cmsContext.setScope("superuser_context");
        String path = NuxeoController.webIdToFetchPath((String)webId);
        try {
            cmsItem = cmsService.getContent(cmsContext, path);
        }
        catch (CMSException e) {
            throw new PortalException((Exception)((Object)e));
        }
        return (Document)cmsItem.getNativeItem();
    }

    private PropertyMap getStepProperties(Document model, String step) {
        PropertyList steps = model.getProperties().getList("pcd:steps");
        PropertyMap properties = null;
        for (int i = 0; i < steps.size(); ++i) {
            PropertyMap map = steps.getMap(i);
            if (!StringUtils.equals((String)step, (String)map.getString("reference"))) continue;
            properties = map;
            break;
        }
        return properties;
    }

    private PropertyMap getActionProperties(PropertyMap stepProperties, String actionId) {
        if (actionId == null) {
            actionId = String.valueOf(stepProperties.get("actionIdDefault"));
        }
        PropertyList actions = stepProperties.getList("actions");
        PropertyMap properties = null;
        for (int i = 0; i < actions.size(); ++i) {
            PropertyMap map = actions.getMap(i);
            if (!StringUtils.equals((String)actionId, (String)map.getString("actionId"))) continue;
            properties = map;
            break;
        }
        return properties;
    }

    private String generateVariablesJSON(Map<String, String> variables) {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            JSONObject object = new JSONObject();
            object.put((Object)"name", (Object)entry.getKey());
            object.put((Object)"value", (Object)entry.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    private void sendEmailNotification(PortalControllerContext portalControllerContext, String procedureInstanceId, String initiator) throws CMSException, PortalException {
        PortletContext portletContext = this.cmsCustomizer.getPortletContext();
        NuxeoController nuxeoController = new NuxeoController(portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        Locale locale = portalControllerContext.getHttpServletRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        if (StringUtils.isNotEmpty((String)procedureInstanceId)) {
            PropertyList actors;
            UUID uuid = UUID.fromString(procedureInstanceId);
            GetTasksCommand command = new GetTasksCommand(null, null, uuid);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            if (documents.size() != 1) {
                throw new CMSException(3);
            }
            Document task = documents.get(0);
            PropertyMap variables = task.getProperties().getMap("nt:task_variables");
            if (BooleanUtils.isTrue((Boolean)variables.getBoolean("notifEmail")) && !(actors = task.getProperties().getList("nt:actors")).isEmpty()) {
                HashSet<Name> names = new HashSet<Name>(actors.size());
                for (int i = 0; i < actors.size(); ++i) {
                    String actor = actors.getString(i);
                    Group group = StringUtils.startsWith((String)actor, (String)"user:") ? null : (StringUtils.startsWith((String)actor, (String)"group:") ? this.groupService.get(StringUtils.removeStart((String)actor, (String)"group:")) : this.groupService.get(actor));
                    if (group == null) {
                        String user = StringUtils.removeStart((String)actor, (String)"user:");
                        names.add(this.personService.getEmptyPerson().buildDn(user));
                        continue;
                    }
                    for (Name member : group.getMembers()) {
                        names.add(member);
                    }
                }
                HashSet<String> emailRecipients = new HashSet<String>(names.size());
                for (Name name : names) {
                    String email;
                    Person person = this.personService.getPerson(name);
                    if (person == null || !StringUtils.isNotBlank((String)(email = person.getMail()))) continue;
                    emailRecipients.add(email);
                }
                if (!emailRecipients.isEmpty()) {
                    Person sender = this.personService.getPerson(initiator);
                    String emailSender = StringUtils.defaultIfBlank((String)sender.getMail(), (String)initiator);
                    String expression = variables.getString("stringMsg");
                    try {
                        String acceptActionId;
                        Session mailSession = Session.getInstance((Properties)System.getProperties(), null);
                        MimeMessage message = new MimeMessage(mailSession);
                        message.setSentDate(new Date());
                        InternetAddress from = new InternetAddress(emailSender);
                        message.setFrom((Address)from);
                        InternetAddress[] to = InternetAddress.parse((String)StringUtils.join(emailRecipients, (String)","));
                        message.setRecipients(Message.RecipientType.TO, (Address[])to);
                        InternetAddress[] replyTo = new InternetAddress[]{from};
                        message.setReplyTo((Address[])replyTo);
                        String subject = StringUtils.substringBefore((String)this.transform(portalControllerContext, expression, task, true), (String)System.lineSeparator());
                        message.setSubject(subject, "UTF-8");
                        String inlineBody = this.transform(portalControllerContext, expression, task, false);
                        StringBuilder body = new StringBuilder();
                        for (String line : StringUtils.split((String)inlineBody, (String)System.lineSeparator())) {
                            body.append("<p>");
                            body.append(line);
                            body.append("</p>");
                        }
                        if (BooleanUtils.isTrue((Boolean)variables.getBoolean("acquitable")) && StringUtils.isNotBlank((String)(acceptActionId = variables.getString("actionIdYes")))) {
                            String url = this.tasksService.getCommandUrl(portalControllerContext, uuid, acceptActionId, null);
                            String title = bundle.getString("ACCEPT");
                            Element link = DOM4JUtils.generateLinkElement((String)url, null, null, null, (String)title);
                            body.append("<p>");
                            body.append(DOM4JUtils.writeCompact((Element)link));
                            body.append("</p>");
                        }
                        MimeMultipart multipart = new MimeMultipart();
                        MimeBodyPart htmlPart = new MimeBodyPart();
                        htmlPart.setContent((Object)body.toString(), "text/html; charset=UTF-8");
                        multipart.addBodyPart((BodyPart)htmlPart);
                        message.setContent((Multipart)multipart);
                        SMTPTransport transport = (SMTPTransport)mailSession.getTransport();
                        transport.connect();
                        transport.sendMessage((Message)message, message.getAllRecipients());
                        transport.close();
                    }
                    catch (MessagingException e) {
                        this.log.warn((Object)"Email sending error", e.getCause());
                    }
                }
            }
        }
    }

    public String transform(PortalControllerContext portalControllerContext, String expression, Document task) throws PortalException {
        return this.transform(portalControllerContext, expression, task, false);
    }

    private String transform(PortalControllerContext portalControllerContext, String expression, Document task, boolean disabledLinks) throws PortalException {
        PropertyMap globalVariables;
        PropertyMap instanceProperties = task.getProperties().getMap("nt:pi");
        if (instanceProperties == null) {
            instanceProperties = new PropertyMap(0);
        }
        if ((globalVariables = instanceProperties.getMap("pi:globalVariablesValues")) == null) {
            globalVariables = new PropertyMap(0);
        }
        PropertyMap taskVariables = task.getProperties().getMap("nt:task_variables");
        HashMap<String, String> variables = new HashMap<String, String>(globalVariables.size() + taskVariables.size());
        for (Map.Entry entry : globalVariables.getMap().entrySet()) {
            variables.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : taskVariables.getMap().entrySet()) {
            variables.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        variables.put("procedureInitiator", instanceProperties.getString("pi:procedureInitiator"));
        variables.put("taskInitiator", task.getString("nt:initiator"));
        return this.transform(portalControllerContext, expression, variables, disabledLinks);
    }

    public String transform(PortalControllerContext portalControllerContext, String expression, Map<String, String> variables) throws PortalException {
        return this.transform(portalControllerContext, expression, variables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transform(PortalControllerContext portalControllerContext, String expression, Map<String, String> variables, boolean disabledLinks) throws PortalException {
        String transformedExpression;
        String value;
        UUID uuid = null;
        if (variables != null && StringUtils.isNotBlank((String)(value = variables.get("uuid")))) {
            uuid = UUID.fromString(value);
        }
        ThreadLocalContainer container = new ThreadLocalContainer(portalControllerContext, uuid, disabledLinks);
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (MapUtils.isNotEmpty(variables)) {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                context.setVariable(entry.getKey(), factory.createValueExpression((Object)entry.getValue(), String.class));
            }
        }
        try {
            context.setFunction("user", "name", TransformationFunctions.getUserDisplayNameMethod());
            context.setFunction("user", "email", TransformationFunctions.getUserEmailMethod());
            context.setFunction("group", "emails", TransformationFunctions.getGroupEmailsMethod());
            context.setFunction("document", "title", TransformationFunctions.getDocumentTitleMethod());
            context.setFunction("command", "link", TransformationFunctions.getCommandLinkMethod());
            if (disabledLinks) {
                context.setFunction("user", "link", TransformationFunctions.getUserDisplayNameMethod());
                context.setFunction("document", "link", TransformationFunctions.getDocumentTitleMethod());
            } else {
                context.setFunction("user", "link", TransformationFunctions.getUserLinkMethod());
                context.setFunction("document", "link", TransformationFunctions.getDocumentLinkMethod());
            }
        }
        catch (NoSuchMethodException e) {
            throw new PortalException((Exception)e);
        }
        catch (SecurityException e) {
            throw new PortalException((Exception)e);
        }
        ValueExpression value2 = factory.createValueExpression((ELContext)context, StringUtils.trimToEmpty((String)expression), String.class);
        try {
            threadLocal.set(container);
            transformedExpression = String.valueOf(value2.getValue((ELContext)context));
        }
        finally {
            threadLocal.remove();
        }
        return transformedExpression;
    }

    public static PortalControllerContext getPortalControllerContext() {
        ThreadLocalContainer container = threadLocal.get();
        PortalControllerContext portalControllerContext = container == null ? null : container.portalControllerContext;
        return portalControllerContext;
    }

    public static UUID getUuid() {
        ThreadLocalContainer container = threadLocal.get();
        UUID uuid = container == null ? null : container.uuid;
        return uuid;
    }

    public static boolean areLinksDisabled() {
        ThreadLocalContainer container = threadLocal.get();
        boolean disabledLinks = container == null ? false : container.disabledLinks;
        return disabledLinks;
    }

    private class ThreadLocalContainer {
        private final PortalControllerContext portalControllerContext;
        private final UUID uuid;
        private final boolean disabledLinks;

        public ThreadLocalContainer(PortalControllerContext portalControllerContext, UUID uuid, boolean disabledLinks) {
            this.portalControllerContext = portalControllerContext;
            this.uuid = uuid;
            this.disabledLinks = disabledLinks;
        }
    }
}

