/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.NavigationItem;

public class DocumentPublishSpaceNavigationCommand
implements INuxeoCommand {
    protected static final Log logger = LogFactory.getLog(CMSService.class);
    CMSItem publishSpaceConfig;
    private boolean forceLiveVersion;
    private boolean useES = false;
    public static final String basicNavigationSchemas = "dublincore,common, toutatice";

    public DocumentPublishSpaceNavigationCommand(CMSItem publishSpaceConfig, boolean forceLiveVersion) {
        this.publishSpaceConfig = publishSpaceConfig;
        this.forceLiveVersion = forceLiveVersion;
        this.useES = NuxeoCompatibility.canUseES();
    }

    public Object execute(Session session) throws Exception {
        boolean canUseES = this.useES && BooleanUtils.toBoolean((String)((String)this.publishSpaceConfig.getProperties().get("useES")));
        OperationRequest request = canUseES ? session.newRequest("Document.QueryES") : session.newRequest("Document.Query");
        boolean live = "1".equals(this.publishSpaceConfig.getProperties().get("displayLiveVersion"));
        if (this.forceLiveVersion) {
            live = true;
        }
        String uuid = ((Document)this.publishSpaceConfig.getNativeItem()).getId();
        String path = this.publishSpaceConfig.getPath();
        String parentCriteria = "ecm:path STARTSWITH";
        String nuxeoRequest = "( " + parentCriteria + " '" + path + "'  AND  (ecm:mixinType = 'Folderish' OR ttc:showInMenu = 1)  )";
        NuxeoQueryFilterContext queryFilter = new NuxeoQueryFilterContext(live ? 1 : 0, "none");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)queryFilter, (String)nuxeoRequest);
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest + " ORDER BY ecm:pos"));
        String navigationSchemas = basicNavigationSchemas;
        String extraNavigationSchemas = System.getProperty("nuxeo.navigationSchemas");
        if (extraNavigationSchemas != null) {
            navigationSchemas = navigationSchemas + "," + extraNavigationSchemas;
        }
        if (canUseES) {
            request.set("X-NXDocumentProperties", (Object)navigationSchemas);
        } else {
            request.setHeader("X-NXDocumentProperties", navigationSchemas);
        }
        HashMap<String, NavigationItem> navItems = new HashMap<String, NavigationItem>();
        Documents children = (Documents)request.execute();
        ArrayList<Document> concatDocuments = new ArrayList<Document>();
        Document doc = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", navigationSchemas).set("value", (Object)uuid).execute();
        concatDocuments.add(doc);
        for (Document child : children) {
            concatDocuments.add(child);
        }
        for (Document child : concatDocuments) {
            String navPath = DocumentHelper.computeNavPath((String)child.getPath());
            NavigationItem navItem = (NavigationItem)navItems.get(navPath);
            if (navItem == null) {
                navItem = new NavigationItem();
                navItems.put(navPath, navItem);
            }
            navItem.setMainDoc((Object)child);
            String parentPath = navPath.substring(0, navPath.lastIndexOf(47));
            if (!parentPath.contains(path)) continue;
            navItem = (NavigationItem)navItems.get(parentPath);
            if (navItem == null) {
                navItem = new NavigationItem();
                navItems.put(parentPath, navItem);
            }
            navItem.getChildren().add(child);
        }
        return navItems;
    }

    public String getId() {
        String sLive = "false";
        if (this.forceLiveVersion) {
            sLive = "true";
        }
        return "PublishSpaceNavigationCommandT2/" + sLive + "/" + this.publishSpaceConfig.getPath();
    }
}

