/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document.helpers;

import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.ContextDocumentsHelper;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static boolean isLeaf(Document document) {
        return !DocumentHelper.isFolder(document);
    }

    public static boolean isFolder(Document document) {
        return ContextDocumentsHelper.isFolder(document);
    }

    public static boolean isLocalPublishLive(Document document) {
        return ContextDocumentsHelper.isLocalPublishLive(document);
    }

    public static boolean isDraft(Document document) {
        return ContextDocumentsHelper.isDraft(document);
    }

    public static boolean hasDraft(Document document) {
        return ContextDocumentsHelper.hasDraft(document);
    }

    public static boolean isRemoteProxy(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        if (cmsCtx.getDoc() == null) {
            return false;
        }
        if (pubInfos.isPublished() && !DocumentHelper.isInLiveMode(cmsCtx, pubInfos)) {
            Document document = (Document)cmsCtx.getDoc();
            String path = document.getPath();
            if (pubInfos.getDocumentPath().equals(path)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInLiveMode(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        IContributionService.EditionState curState;
        boolean liveMode = false;
        PortletRequest request = cmsCtx.getRequest();
        if (request != null && (curState = (IContributionService.EditionState)request.getAttribute("osivia.editionState")) != null && curState.getContributionMode().equals(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION) && curState.getDocPath().equals(pubInfos.getDocumentPath())) {
            liveMode = true;
        }
        return liveMode;
    }

    public static String getName(Document document) {
        String path = document.getPath();
        return StringUtils.substringAfterLast((String)path, (String)"/");
    }

    public static String getWebId(Document document) {
        String webId = (String)ContextDocumentsHelper.getPropertyValue(document, "ttc:webid");
        return StringUtils.isNotBlank((String)webId) ? webId : "";
    }

    public static String getCheckinedWebIdFromDraft(Document draft) {
        if (DocumentHelper.isDraft(draft)) {
            return (String)ContextDocumentsHelper.getPropertyValue(draft, "ottcDft:checkinedDocId");
        }
        return "";
    }

    public static String getDraftPath(Document document) {
        if (DocumentHelper.hasDraft(document)) {
            String draftPath = (String)ContextDocumentsHelper.getPropertyValue(document, "ottcChk:draftPath");
            return StringUtils.isNotBlank((String)draftPath) ? draftPath : "";
        }
        return "";
    }

    public static String computeNavPath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }
}

