/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.commands;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.nuxeo.ecm.automation.client.AutomationException;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.osivia.portal.api.ecm.EcmCommand;

public class NuxeoCommandDelegate
implements INuxeoCommand {
    EcmCommand command;
    Document doc;

    public NuxeoCommandDelegate(EcmCommand command, Document doc) {
        this.command = command;
        this.doc = doc;
    }

    public Object execute(Session session) throws Exception {
        Object result;
        String nxRealCommand = this.command.getRealCommand();
        Map parameters = this.command.getRealCommandParameters();
        if (nxRealCommand != null) {
            OperationRequest operationRequest = session.newRequest(nxRealCommand).setHeader("X-NXDocumentProperties", "*").setInput((OperationInput)this.doc);
            if (MapUtils.isNotEmpty((Map)parameters)) {
                for (Map.Entry entry : parameters.entrySet()) {
                    operationRequest.set((String)entry.getKey(), entry.getValue());
                }
            }
            if (!((result = operationRequest.execute()) instanceof Document)) {
                return result;
            }
        } else {
            throw new AutomationException("L'op\u00e9ration" + this.command.getCommandName() + " n'est pas reconnue.");
        }
        this.doc = (Document)result;
        return this.doc;
    }

    public String getId() {
        return this.command.getCommandName();
    }
}

