/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPostDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.AddCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.DeleteCommentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class NuxeoCommentsServiceImpl
implements INuxeoCommentsService {
    private final CMSService cmsService;
    private final PersonService personService;

    public NuxeoCommentsServiceImpl(CMSService cmsService) {
        this.cmsService = cmsService;
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    }

    public List<CommentDTO> getDocumentComments(CMSServiceCtx cmsContext, Document document) throws CMSException {
        return this.getGenericComments(cmsContext, document, CommentDTO.class);
    }

    public List<ThreadPostDTO> getForumThreadPosts(CMSServiceCtx cmsContext, Document document) throws CMSException {
        return this.getGenericComments(cmsContext, document, ThreadPostDTO.class);
    }

    private <T extends CommentDTO> List<T> getGenericComments(CMSServiceCtx cmsContext, Document document, Class<T> type) throws CMSException {
        try {
            GetCommentsCommand command = new GetCommentsCommand(document);
            JSONArray jsonArray = (JSONArray)this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            List comments = this.convertJSONArrayToComments(jsonArray, type);
            return comments;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    private <T extends CommentDTO> List<T> convertJSONArrayToComments(JSONArray jsonArray, Class<T> type) throws InstantiationException, IllegalAccessException {
        ArrayList<CommentDTO> comments = new ArrayList<CommentDTO>(jsonArray.size());
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            CommentDTO comment = (CommentDTO)type.newInstance();
            if (jsonObject.containsKey((Object)"id")) {
                String id = jsonObject.getString("id");
                comment.setId(id);
            }
            if (jsonObject.containsKey((Object)"path")) {
                String path = jsonObject.getString("path");
                comment.setPath(path);
            }
            if (jsonObject.containsKey((Object)"author")) {
                String author = jsonObject.getString("author");
                comment.setAuthor(author);
                Person person = this.personService.getPerson(author);
                comment.setPerson(person);
            }
            if (jsonObject.containsKey((Object)"creationDate")) {
                JSONObject jsonObjectDate = jsonObject.getJSONObject("creationDate");
                Long time = (Long)jsonObjectDate.get("timeInMillis");
                comment.setCreationDate(new Date(time));
            }
            if (jsonObject.containsKey((Object)"content")) {
                String content = StringUtils.replace((String)jsonObject.getString("content"), (String)SystemUtils.LINE_SEPARATOR, (String)"<br>");
                comment.setContent(content);
            }
            if (jsonObject.containsKey((Object)"canDelete")) {
                boolean deletable = jsonObject.getBoolean("canDelete");
                comment.setDeletable(deletable);
            }
            if (comment instanceof ThreadPostDTO) {
                ThreadPostDTO threadPost = (ThreadPostDTO)comment;
                if (jsonObject.containsKey((Object)"title")) {
                    String title = jsonObject.getString("title");
                    threadPost.setTitle(title);
                }
                if (jsonObject.containsKey((Object)"filename")) {
                    String filename = jsonObject.getString("filename");
                    threadPost.setFilename(filename);
                }
            }
            if (jsonObject.containsKey((Object)"children")) {
                JSONArray children = jsonObject.getJSONArray("children");
                List commentChildren = this.convertJSONArrayToComments(children, type);
                comment.getChildren().addAll(commentChildren);
            }
            comments.add(comment);
        }
        return comments;
    }

    public Document addDocumentComment(CMSServiceCtx cmsContext, Document document, CommentDTO comment, String parentId) throws CMSException {
        try {
            AddCommentCommand command = new AddCommentCommand(document, comment, parentId);
            return (Document)this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteDocumentComment(CMSServiceCtx cmsContext, Document document, String id) throws CMSException {
        try {
            DeleteCommentCommand command = new DeleteCommentCommand(document, id);
            this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }
}

