/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateProcedureCommand
implements INuxeoCommand {
    private final String path;
    private final String taskTitle;
    private final String actors;
    private final String additionalAuthorizations;
    private final PropertyMap properties;

    public UpdateProcedureCommand(String path, String title, Set<String> actors, Set<String> additionalAuthorizations, Map<String, Object> properties) {
        this.path = path;
        this.taskTitle = title;
        this.actors = StringUtils.trimToNull((String)StringUtils.join(actors, (String)","));
        this.additionalAuthorizations = StringUtils.trimToNull((String)StringUtils.join(additionalAuthorizations, (String)","));
        this.properties = new PropertyMap(properties);
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Services.UpdateProcedure");
        request.setInput((OperationInput)new DocRef(this.path));
        request.set("taskTitle", (Object)this.taskTitle);
        request.set("actors", (Object)this.actors);
        request.set("additionalAuthorizations", (Object)this.additionalAuthorizations);
        request.set("properties", (Object)this.properties);
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("/");
        builder.append(new Date().getTime());
        builder.append("/");
        builder.append(this.properties.getString("pi:procedureModelWebId"));
        builder.append("/");
        builder.append(this.properties.getString("pi:currentStep"));
        return builder.toString();
    }
}

