/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.publish;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.MenuComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.MenuOptions;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.NavigationDisplayItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.security.CmsPermissionHelper;

public class MenuPortlet
extends CMSPortlet {
    private static final String MAX_LEVELS_WINDOW_PROPERTY = "osivia.cms.maxLevels";
    private static final String START_LEVEL_WINDOW_PROPERTY = "osivia.cms.startLevel";
    private static final String OPEN_LEVELS_WINDOW_PROPERTY = "osivia.cms.openLevels";
    private static final String TEMPLATE_WINDOW_PROPERTY = "osivia.cms.template";
    private static final String FORCE_NAVIGATION_WINDOW_PROPERTY = "osivia.cms.forceNavigation";
    private static final String TYPE_FILTER_WINDOW_PROPERTY = "osivia.cms.type";
    private static final int DEFAULT_MAX_LEVELS = 3;
    private static final int DEFAULT_START_LEVEL = 1;
    private static final int DEFAULT_OPEN_LEVELS = 1;
    private static final String PATH_VIEW = "/WEB-INF/jsp/publish/view.jsp";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/publish/admin.jsp";
    private IBundleFactory bundleFactory;
    private INotificationsService notificationsService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        IInternationalizationService internationalizationService = (IInternationalizationService)portletContext.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)portletContext.getAttribute("NotificationsService");
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        String action = request.getParameter("javax.portlet.action");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("drop".equals(action)) {
                List<String> sourceIds = Arrays.asList(StringUtils.split((String)request.getParameter("sourceIds"), (String)","));
                String targetId = request.getParameter("targetId");
                String targetPath = this.getAuxiliaryPath(nuxeoController, targetId);
                MoveDocumentCommand command = new MoveDocumentCommand(sourceIds, targetId);
                try {
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    request.setAttribute("osivia.updateContents", (Object)"true");
                    response.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
                    String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_SUCCESS_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_SUCCESS_MESSAGE", new Object[]{sourceIds.size()});
                    this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
                }
                catch (NuxeoException e) {
                    String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_WARNING_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_WARNING_MESSAGE", new Object[]{sourceIds.size()});
                    this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
                }
                if (targetPath != null) {
                    response.setRenderParameter("auxiliaryPath", targetPath);
                }
            }
        } else if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                int openLevels = NumberUtils.toInt((String)request.getParameter("openLevels"));
                if (openLevels > 0) {
                    window.setProperty(OPEN_LEVELS_WINDOW_PROPERTY, String.valueOf(openLevels));
                } else {
                    window.setProperty(OPEN_LEVELS_WINDOW_PROPERTY, null);
                }
                int startLevel = NumberUtils.toInt((String)request.getParameter("startLevel"));
                if (startLevel > 0) {
                    window.setProperty(START_LEVEL_WINDOW_PROPERTY, String.valueOf(startLevel));
                } else {
                    window.setProperty(START_LEVEL_WINDOW_PROPERTY, null);
                }
                int maxLevels = NumberUtils.toInt((String)request.getParameter("maxLevels"));
                if (maxLevels > 0) {
                    window.setProperty(MAX_LEVELS_WINDOW_PROPERTY, String.valueOf(maxLevels));
                } else {
                    window.setProperty(MAX_LEVELS_WINDOW_PROPERTY, null);
                }
                String template = request.getParameter("template");
                window.setProperty(TEMPLATE_WINDOW_PROPERTY, template);
                String forceNavigation = request.getParameter("forceNavigation");
                window.setProperty(FORCE_NAVIGATION_WINDOW_PROPERTY, forceNavigation);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    private String getAuxiliaryPath(NuxeoController nuxeoController, String id) {
        String path;
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = this.getMenuCMSContext(nuxeoController);
        try {
            CMSItem item = cmsService.getContent(cmsContext, id);
            path = item.getPath();
        }
        catch (CMSException e) {
            path = null;
        }
        return path;
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        ICMSService cmsService = NuxeoController.getCMSService();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String typeFilter = window.getProperty(TYPE_FILTER_WINDOW_PROPERTY);
        if ("lazyLoading".equals(request.getParameter("action"))) {
            ArrayList<NavigationDisplayItem> children = null;
            String path = request.getParameter("path");
            if (StringUtils.isNotEmpty((String)path)) {
                CMSServiceCtx cmsContext = this.getMenuCMSContext(nuxeoController);
                MenuOptions options = this.getMenuOptions(nuxeoController);
                try {
                    List items = cmsService.getPortalNavigationSubitems(cmsContext, options.getBasePath(), path);
                    children = new ArrayList<NavigationDisplayItem>(items.size());
                    for (CMSItem item : items) {
                        if (!"1".equals(item.getProperties().get("menuItem"))) continue;
                        DocumentType type = item.getType();
                        if (typeFilter != null && (type == null || !typeFilter.equals(type.getName()))) continue;
                        Document document = (Document)item.getNativeItem();
                        Link link = nuxeoController.getLink(document, "menu");
                        NavigationDisplayItem navigationDisplayItemChild = new NavigationDisplayItem(document, link, false, false, false, item);
                        children.add(navigationDisplayItemChild);
                    }
                    MenuComparator comparator = new MenuComparator(nuxeoController);
                    Collections.sort(children, comparator);
                }
                catch (CMSException cMSException) {
                    // empty catch block
                }
            }
            response.setContentType("application/json");
            PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
            printWriter.write("[ ");
            if (CollectionUtils.isNotEmpty(children)) {
                boolean firstItem = true;
                for (NavigationDisplayItem child : children) {
                    if (firstItem) {
                        firstItem = false;
                    } else {
                        printWriter.write(", ");
                    }
                    this.writeNavigationDisplayItem(printWriter, child);
                }
            }
            printWriter.write(" ]");
            printWriter.close();
        } else {
            super.serveResource(request, response);
        }
    }

    private void writeNavigationDisplayItem(PrintWriter printWriter, NavigationDisplayItem item) {
        boolean browsable = false;
        String acceptedTypes = null;
        String glyph = null;
        if (item.getNavItem() != null && item.getNavItem().getType() != null) {
            DocumentType cmsItemType = item.getNavItem().getType();
            browsable = cmsItemType.isBrowsable();
            acceptedTypes = StringUtils.join((Collection)cmsItemType.getPortalFormSubTypes(), (String)",");
            glyph = cmsItemType.getGlyph();
        }
        printWriter.write("{ ");
        printWriter.write("\"title\" : \"");
        printWriter.write(item.getTitle());
        printWriter.write("\", ");
        printWriter.write("\"href\" : \"");
        printWriter.write(item.getUrl());
        printWriter.write("\", ");
        printWriter.write("\"folder\" : ");
        printWriter.write(String.valueOf(browsable));
        printWriter.write(", \"lazy\" : ");
        printWriter.write(String.valueOf(browsable));
        printWriter.write(", ");
        printWriter.write("\"id\" : \"");
        printWriter.write(item.getId());
        printWriter.write("\", ");
        printWriter.write("\"path\" : \"");
        printWriter.write(item.getNavItem().getPath());
        printWriter.write("\", ");
        if (acceptedTypes != null) {
            printWriter.write("\"acceptedtypes\" : \"");
            printWriter.write(acceptedTypes);
            printWriter.write("\", ");
        }
        if (glyph != null && !glyph.contains("folder")) {
            printWriter.write("\"iconclass\" : \"");
            printWriter.write(glyph);
            printWriter.write("\", ");
        }
        printWriter.write("\"extraClasses\" : \"text-muted\"");
        printWriter.write(" }");
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        INuxeoCustomizer customizer = nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String openLevels = window.getProperty(OPEN_LEVELS_WINDOW_PROPERTY);
        request.setAttribute("openLevels", (Object)openLevels);
        request.setAttribute("defaultOpenLevels", (Object)1);
        String startLevel = window.getProperty(START_LEVEL_WINDOW_PROPERTY);
        request.setAttribute("startLevel", (Object)startLevel);
        String maxLevels = window.getProperty(MAX_LEVELS_WINDOW_PROPERTY);
        request.setAttribute("maxLevels", (Object)maxLevels);
        request.setAttribute("defaultMaxLevels", (Object)3);
        SortedMap templates = customizer.getMenuTemplates(request.getLocale());
        request.setAttribute("templates", (Object)templates);
        String selectedTemplate = window.getProperty(TEMPLATE_WINDOW_PROPERTY);
        request.setAttribute("selectedTemplate", (Object)selectedTemplate);
        boolean forceNavigation = BooleanUtils.toBoolean((String)window.getProperty(FORCE_NAVIGATION_WINDOW_PROPERTY));
        request.setAttribute("forceNavigation", (Object)forceNavigation);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NavigationDisplayItem displayItem;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            CMSServiceCtx cmsContext = this.getMenuCMSContext(nuxeoController);
            MenuOptions options = this.getMenuOptions(nuxeoController);
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            request.setAttribute("template", (Object)window.getProperty(TEMPLATE_WINDOW_PROPERTY));
            request.setAttribute("startLevel", (Object)options.getStartLevel());
            request.setAttribute("openLevels", (Object)options.getOpenLevels());
            if (options.getBasePath() != null && (displayItem = this.getNavigationDisplayItem(nuxeoController, cmsContext, options)) != null) {
                if (displayItem.getTitle() != null) {
                    response.setTitle(displayItem.getTitle());
                }
                request.setAttribute("displayItem", (Object)displayItem);
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private NavigationDisplayItem getNavigationDisplayItem(NuxeoController nuxeoController, CMSServiceCtx cmsContext, MenuOptions options) throws CMSException {
        NavigationDisplayItem navigationDisplayItem;
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSItem navigationItem = cmsService.getPortalNavigationItem(cmsContext, options.getBasePath(), options.getBasePath());
        if (navigationItem == null) {
            navigationDisplayItem = null;
        } else {
            boolean lazy = "1".equals(navigationItem.getProperties().get("partialLoading"));
            options.setLazy(lazy);
            navigationDisplayItem = this.getNavigationDisplayItem(nuxeoController, cmsContext, options, navigationItem, 0);
        }
        return navigationDisplayItem;
    }

    private NavigationDisplayItem getNavigationDisplayItem(NuxeoController nuxeoController, CMSServiceCtx cmsContext, MenuOptions options, CMSItem navigationItem, int level) throws CMSException {
        List navigationDisplayChildren;
        NavigationDisplayItem navigationDisplayItem;
        boolean primaryPathSelected;
        Document document = (Document)navigationItem.getNativeItem();
        Link link = nuxeoController.getLink(document, "menu");
        boolean selected = false;
        boolean current = false;
        Boolean unfetchedChildren = BooleanUtils.toBooleanObject((String)((String)navigationItem.getProperties().get("unfetchedChildren")));
        boolean fetchedChildren = BooleanUtils.isFalse((Boolean)unfetchedChildren);
        if (this.isSelected(options.getCurrentPath(), navigationItem.getPath())) {
            selected = true;
            if (StringUtils.equals((String)options.getCurrentPath(), (String)navigationItem.getPath())) {
                current = true;
            }
        }
        boolean bl = primaryPathSelected = selected && !current;
        if (this.isSelected(options.getAuxiliaryPath(), navigationItem.getPath()) && !StringUtils.equals((String)options.getAuxiliaryPath(), (String)navigationItem.getPath())) {
            selected = true;
        }
        if (level + 1 >= options.getStartLevel()) {
            navigationDisplayItem = new NavigationDisplayItem(document, link, selected, current, fetchedChildren, navigationItem);
            navigationDisplayChildren = this.getNavigationDisplayItemChildren(nuxeoController, cmsContext, options, navigationItem, level, selected || fetchedChildren);
            navigationDisplayItem.getChildren().addAll(navigationDisplayChildren);
        } else if (selected) {
            navigationDisplayItem = null;
            navigationDisplayChildren = this.getNavigationDisplayItemChildren(nuxeoController, cmsContext, options, navigationItem, level, true);
            for (NavigationDisplayItem displayItemChild : navigationDisplayChildren) {
                if (!displayItemChild.isSelected()) continue;
                navigationDisplayItem = displayItemChild;
                break;
            }
            if (navigationDisplayItem == null && level == 0) {
                navigationDisplayItem = new NavigationDisplayItem(document, link, selected, current, fetchedChildren, navigationItem);
            }
        } else {
            navigationDisplayItem = null;
        }
        if (primaryPathSelected) {
            boolean lastSelected = true;
            for (NavigationDisplayItem item : navigationDisplayItem.getChildren()) {
                if (!item.isSelected()) continue;
                lastSelected = false;
                break;
            }
            navigationDisplayItem.setLastSelected(lastSelected);
        }
        return navigationDisplayItem;
    }

    private List<NavigationDisplayItem> getNavigationDisplayItemChildren(NuxeoController nuxeoController, CMSServiceCtx cmsContext, MenuOptions options, CMSItem navigationItem, int level, boolean loaded) throws CMSException {
        DocumentType cmsItemType;
        ArrayList<NavigationDisplayItem> navigationDisplayItemChildren;
        ICMSService cmsService = NuxeoController.getCMSService();
        Document document = (Document)navigationItem.getNativeItem();
        if (!options.isLazy() && level < options.getMaxLevels() || options.isLazy() && loaded) {
            List navigationItemChildren = cmsService.getPortalNavigationSubitems(cmsContext, options.getBasePath(), navigationItem.getPath());
            navigationDisplayItemChildren = new ArrayList(navigationItemChildren.size());
            for (CMSItem navigationItemChild : navigationItemChildren) {
                NavigationDisplayItem navigationDisplayItemChild;
                if (!"1".equals(navigationItemChild.getProperties().get("menuItem")) || (navigationDisplayItemChild = this.getNavigationDisplayItem(nuxeoController, cmsContext, options, navigationItemChild, level + 1)) == null) continue;
                navigationDisplayItemChildren.add(navigationDisplayItemChild);
            }
        } else {
            navigationDisplayItemChildren = new ArrayList<NavigationDisplayItem>(0);
        }
        if ((cmsItemType = (DocumentType)nuxeoController.getCMSItemTypes().get(document.getType())) == null || !cmsItemType.isOrdered()) {
            MenuComparator comparator = new MenuComparator(nuxeoController);
            Collections.sort(navigationDisplayItemChildren, comparator);
        }
        return navigationDisplayItemChildren;
    }

    private CMSServiceCtx getMenuCMSContext(NuxeoController nuxeoController) {
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        String cmsVersion = CmsPermissionHelper.getCurrentCmsVersion((InvocationContext)controllerContext);
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(nuxeoController.getPortalCtx());
        cmsContext.setScope(nuxeoController.getNavigationScope());
        if ("preview".equals(cmsVersion)) {
            cmsContext.setDisplayLiveVersion("1");
        }
        return cmsContext;
    }

    private MenuOptions getMenuOptions(NuxeoController nuxeoController) {
        PortletRequest request = nuxeoController.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        boolean forceNavigation = BooleanUtils.toBoolean((String)window.getProperty(FORCE_NAVIGATION_WINDOW_PROPERTY));
        String basePath = forceNavigation || nuxeoController.getMenuRootPath() == null ? nuxeoController.getBasePath() : nuxeoController.getMenuRootPath();
        String currentPath = nuxeoController.getItemNavigationPath();
        String auxiliaryPath = request.getParameter("auxiliaryPath");
        int openLevels = 1;
        String openLevelsWindowProperty = window.getProperty(OPEN_LEVELS_WINDOW_PROPERTY);
        if (StringUtils.isNotBlank((String)openLevelsWindowProperty)) {
            openLevels = NumberUtils.toInt((String)openLevelsWindowProperty);
        }
        int startLevel = 1;
        String startLevelWindowProperty = window.getProperty(START_LEVEL_WINDOW_PROPERTY);
        if (StringUtils.isNotBlank((String)startLevelWindowProperty)) {
            startLevel = NumberUtils.toInt((String)startLevelWindowProperty);
        }
        int maxLevels = 3;
        String maxLevelWindowProperty = window.getProperty(MAX_LEVELS_WINDOW_PROPERTY);
        if (StringUtils.isNotBlank((String)maxLevelWindowProperty)) {
            maxLevels = NumberUtils.toInt((String)maxLevelWindowProperty);
        }
        return new MenuOptions(basePath, currentPath, auxiliaryPath, openLevels, startLevel, maxLevels);
    }

    private boolean isSelected(String currentPath, String itemPath) {
        boolean selected = StringUtils.startsWith((String)currentPath, (String)itemPath);
        if (selected) {
            String[] splittedCurrentPath = StringUtils.split((String)currentPath, (String)"/");
            String[] splittedItemPath = StringUtils.split((String)itemPath, (String)"/");
            for (int i = 0; i < Math.min(splittedCurrentPath.length, splittedItemPath.length); ++i) {
                if (StringUtils.equals((String)splittedCurrentPath[i], (String)splittedItemPath[i])) continue;
                selected = false;
                break;
            }
        }
        return selected;
    }
}

