/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.search;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.search.SearchCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class SearchPortlet
extends CMSPortlet {
    private static final String PATH_VIEW = "/WEB-INF/jsp/search/view.jsp";
    private static final String PATH_RESULT = "/WEB-INF/jsp/search/result.jsp";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/search/admin.jsp";
    private IPortalUrlFactory portalUrlFactory;
    private IBundleFactory bundleFactory;
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute("UrlService");
        if (this.portalUrlFactory == null) {
            throw new PortletException("Cannot start TestPortlet due to service unavailability");
        }
        IInternationalizationService internationalizationService = (IInternationalizationService)this.getPortletContext().getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.documentDAO = DocumentDAO.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        String action = request.getParameter("javax.portlet.action");
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("search".equals(action)) {
                String keywords = request.getParameter("keywords");
                response.setRenderParameter("keywords", keywords);
            }
        } else if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String path = request.getParameter("path");
                window.setProperty("osivia.cms.uri", path);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.cms.uri");
        request.setAttribute("path", (Object)StringUtils.trimToEmpty((String)path));
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalWindow portalWindow = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String path = portalWindow.getProperty("osivia.cms.uri");
        String keywords = request.getParameter("keywords");
        if (keywords == null) {
            keywords = request.getParameter("osivia.keywords");
        }
        try {
            String requestDispatcherPath;
            if (keywords != null) {
                String currentPageParam = request.getParameter("currentPage");
                int currentPage = NumberUtils.toInt((String)currentPageParam);
                nuxeoController.setCacheTimeOut(0L);
                NuxeoQueryFilterContext queryFilter = new NuxeoQueryFilterContext();
                if (path != null && path.length() > 0) {
                    queryFilter = nuxeoController.getQueryFilterContextForPath(path);
                }
                SearchCommand command = new SearchCommand(queryFilter, path, keywords, currentPage);
                PaginableDocuments docs = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                ArrayList<DocumentDTO> documentsDTO = new ArrayList<DocumentDTO>(docs.size());
                for (Document document : docs) {
                    DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                    documentsDTO.add(documentDTO);
                }
                int minPage = Math.max(0, currentPage - docs.getPageSize());
                int maxPage = Math.min(currentPage + docs.getPageSize(), docs.getPageCount()) - 1;
                request.setAttribute("keywords", (Object)StringEscapeUtils.escapeHtml((String)keywords));
                request.setAttribute("documents", documentsDTO);
                request.setAttribute("totalSize", (Object)docs.getTotalSize());
                request.setAttribute("currentPage", (Object)currentPage);
                request.setAttribute("minPage", (Object)minPage);
                request.setAttribute("maxPage", (Object)maxPage);
                response.setTitle(bundle.getString("SEARCH_RESULT"));
                requestDispatcherPath = PATH_RESULT;
            } else {
                Window technicalWindow = (Window)request.getAttribute("osivia.window");
                Page page = (Page)technicalWindow.getParent();
                String pageId = PortalObjectUtils.getHTMLSafeId((PortalObjectId)page.getId());
                HashMap<String, String> windowProperties = new HashMap<String, String>();
                windowProperties.put("osivia.cms.uri", nuxeoController.getComputedPath(path));
                windowProperties.put("osivia.title", bundle.getString("SEARCH_RESULT"));
                windowProperties.put("osivia.hideDecorators", "1");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("keywords", "__REPLACE_KEYWORDS__");
                String url = this.portalUrlFactory.getStartPortletInRegionUrl(nuxeoController.getPortalCtx(), pageId, "toutatice-portail-cms-nuxeo-searchPortletInstance", "virtual", "portalServiceWindow", windowProperties, params);
                request.setAttribute("searchUrl", (Object)url);
                requestDispatcherPath = PATH_VIEW;
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(requestDispatcherPath).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }
}

