/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.TaskDirective;
import fr.toutatice.portail.cms.nuxeo.portlets.commands.DocumentFetchPublishedCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.commands.NuxeoCommandDelegate;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FetchDocumentByUUIDCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FileContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.InternalPictureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PictureContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PutInTrashDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.RequestPublishStatus;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentGetMediaLibraryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentPublishSpaceNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentsMetadataCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ExtendedDocumentInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.FullLoadedNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.FullLoadedNavigationItems;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetChildrenCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetTasksCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserSubscriptionsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ListCMSSubitemsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PartialNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PartialNavigationInvoker;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PublishInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ReloadNuxeoSessionCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.statistics.StatisticsCmsServiceDelegation;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.AskSetOnLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.CancelWorkflowCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentAddComplexPropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentDeleteCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentRemovePropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentUpdatePropertiesCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOffLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOnLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.ValidationPublishCommand;
import fr.toutatice.portail.cms.nuxeo.service.user.UserPreferencesDelegation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.naming.Name;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.identity.User;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.cache.services.IServiceInvoker;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.EcmViews;
import org.osivia.portal.api.ecm.IEcmCommandervice;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.player.Player;
import org.osivia.portal.api.statistics.SpaceStatistics;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItemRestriction;
import org.osivia.portal.api.taskbar.TaskbarItemType;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.api.theming.TemplateAdapter;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.api.user.UserPreferences;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSConfigurationItem;
import org.osivia.portal.core.cms.CMSEditableWindow;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.DocumentMetadata;
import org.osivia.portal.core.cms.DocumentsMetadata;
import org.osivia.portal.core.cms.DomainContextualization;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.NavigationItem;
import org.osivia.portal.core.cms.RegionInheritance;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;
import org.osivia.portal.core.profils.IProfilManager;

public class CMSService
implements ICMSService {
    private static final String EXTENDED_DOCUMENT_INFOS_ATTRIBUTE_PREFIX = "osivia.cms.extendedDocumentInfos.";
    private static final Log procLogger = LogFactory.getLog((String)"procedures");
    private static final Log LOG = LogFactory.getLog(CMSService.class);
    private static final String SLASH = "/";
    private final PortletContext portletCtx;
    private INuxeoCommandService nuxeoCommandService;
    private INuxeoService nuxeoService;
    private IProfilManager profilManager;
    private ICacheService serviceCache;
    private DefaultCMSCustomizer customizer;
    private IPortalUrlFactory urlFactory;
    private final INotificationsService notifsService;
    private final IInternationalizationService internationalizationService;
    private final ITaskbarService taskbarService;
    private final IFormsService formsService;
    private final IEcmCommandervice ecmCmdService;
    private final PersonService personService;
    private final GroupService groupService;
    private final StatisticsCmsServiceDelegation statisticsServiceDelegation;
    private final UserPreferencesDelegation prefsDelegation;

    public CMSService(PortletContext portletCtx) {
        this.portletCtx = portletCtx;
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        this.notifsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
        this.internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.formsService = NuxeoServiceFactory.getFormsService();
        this.ecmCmdService = (IEcmCommandervice)Locator.findMBean(IEcmCommandervice.class, (String)"osivia:service=EcmCommandService");
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        this.groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
        this.statisticsServiceDelegation = new StatisticsCmsServiceDelegation();
        this.prefsDelegation = new UserPreferencesDelegation();
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
    }

    public CMSItem createItem(CMSServiceCtx cmsCtx, String path, String displayName, Document doc) throws CMSException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("displayName", displayName);
        properties.put("type", doc.getType());
        if (BooleanUtils.toBoolean((String)doc.getString("ttc:showInMenu"))) {
            properties.put("menuItem", "1");
        }
        String domainId = doc.getString("ttc:domainID");
        String webId = doc.getString("ttc:webid");
        if (doc.getString("ttc:selectors") != null) {
            properties.put("selectors", doc.getString("ttc:selectors"));
        }
        CMSItem cmsItem = new CMSItem(path, domainId, webId, properties, (Object)doc);
        DocumentType type = (DocumentType)this.customizer.getCMSItemTypes().get(doc.getType());
        cmsItem.setType(type);
        return cmsItem;
    }

    public CMSItem createItem(CMSServiceCtx cmsContext, String path, String displayName, Document document, CMSPublicationInfos publicationInfos) throws CMSException {
        CMSItem cmsItem = this.createItem(cmsContext, path, displayName, document);
        if (publicationInfos != null) {
            cmsItem.setPublished(Boolean.valueOf(publicationInfos.isPublished()));
            cmsItem.setBeingModified(Boolean.valueOf(publicationInfos.isBeingModified()));
        }
        return cmsItem;
    }

    public CMSItem createNavigationItem(CMSServiceCtx cmsCtx, String path, String displayName, Document document, String publishSpacePath) throws CMSException {
        CMSItem cmsItem = this.createItem(cmsCtx, path, displayName, document);
        CMSItem publishSpaceItem = null;
        publishSpaceItem = publishSpacePath != null && !path.equals(publishSpacePath) ? this.getPortalNavigationItem(cmsCtx, publishSpacePath, publishSpacePath) : cmsItem;
        this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(cmsItem, publishSpaceItem);
        return cmsItem;
    }

    public IProfilManager getProfilManager() throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)this.portletCtx.getAttribute("ProfileService");
        }
        return this.profilManager;
    }

    public INuxeoService getNuxeoService() throws Exception {
        if (this.nuxeoService == null) {
            this.nuxeoService = (INuxeoService)this.portletCtx.getAttribute("NuxeoService");
        }
        return this.nuxeoService;
    }

    public ICacheService getCacheService() throws Exception {
        if (this.serviceCache == null) {
            this.serviceCache = (ICacheService)this.portletCtx.getAttribute("CacheService");
        }
        return this.serviceCache;
    }

    public INuxeoCommandService getNuxeoCommandService() throws Exception {
        if (this.nuxeoCommandService == null) {
            this.nuxeoCommandService = NuxeoCommandServiceFactory.getNuxeoCommandService((PortletContext)this.portletCtx);
        }
        return this.nuxeoCommandService;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        }
        return this.urlFactory;
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsCtx, INuxeoCommand command) throws Exception {
        NuxeoCommandContext commandCtx = null;
        if (cmsCtx.getServerInvocation() != null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx, cmsCtx.getServerInvocation());
        } else if (cmsCtx.getServletRequest() != null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx, cmsCtx.getServletRequest());
        }
        if (commandCtx == null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx);
        }
        commandCtx.setAsyncCacheRefreshing(cmsCtx.isAsyncCacheRefreshing());
        if (cmsCtx.isForceReload()) {
            commandCtx.setForceReload(true);
        }
        String scope = cmsCtx.getScope();
        commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
        commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if (scope != null && !"__nocache".equals(scope)) {
            if ("user_session".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_SESSION);
            } else if ("anonymous".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_context".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_no_cache".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            } else {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_PROFIL);
                commandCtx.setAuthProfil(this.getProfilManager().getProfil(scope));
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            }
        }
        return this.getNuxeoCommandService().executeCommand(commandCtx, (INuxeoServiceCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSItem fetchContent(CMSServiceCtx cmsContext, String path) throws Exception {
        CMSItem cmsItem;
        String savedScope = cmsContext.getScope();
        try {
            boolean saveAsync = cmsContext.isAsyncCacheRefreshing();
            cmsContext.setAsyncCacheRefreshing(false);
            CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, path);
            path = publicationInfos.getDocumentPath();
            cmsContext.setAsyncCacheRefreshing(saveAsync);
            boolean haveToGetLive = "1".equals(cmsContext.getDisplayLiveVersion());
            if (publicationInfos.getDocumentPath().equals(cmsContext.getForcedLivePath()) || publicationInfos.getLiveId().equals(cmsContext.getForcedLivePath())) {
                haveToGetLive = true;
            }
            if (!publicationInfos.isPublished() && StringUtils.isNotEmpty((String)publicationInfos.getPublishSpacePath()) && publicationInfos.isLiveSpace()) {
                haveToGetLive = true;
            }
            if (!publicationInfos.isPublished() && publicationInfos.getPublishSpacePath() == null) {
                haveToGetLive = true;
            }
            cmsContext.setScope("superuser_context");
            Object nuxeoCommand = haveToGetLive ? new DocumentFetchLiveCommand(path, "Read") : new DocumentFetchPublishedCommand(path);
            Document document = (Document)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
            cmsItem = this.createItem(cmsContext, path, document.getTitle(), document, publicationInfos);
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        return cmsItem;
    }

    public CMSItem getContent(CMSServiceCtx cmsContext, String path) throws CMSException {
        CMSItem content = null;
        try {
            content = this.fetchContent(cmsContext, path);
            DocumentType type = content.getType();
            if (type != null && type.isForcePortalContextualization()) {
                content.getProperties().put("supportsOnlyPortalContextualization", "1");
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return content;
    }

    public CMSBinaryContent getBinaryContent(CMSServiceCtx cmsCtx, String type, String docPath, String parameter) throws CMSException {
        CMSBinaryContent content = new CMSBinaryContent();
        if ("file".equals(type)) {
            content = this.getFileContent(cmsCtx, docPath, parameter);
        } else if ("attachedPicture".equals(type)) {
            content = this.getAttachedPicture(cmsCtx, docPath, parameter);
        } else if ("picture".equals(type)) {
            content = this.getPicture(cmsCtx, docPath, parameter);
        }
        return content;
    }

    public CMSBinaryContent getAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchAttachedPicture(cmsCtx, docPath, pictureIndex);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        try {
            CMSItem containerDoc = this.fetchContent(cmsCtx, docPath);
            if (containerDoc != null) {
                cmsCtx.setScope("superuser_context");
                pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new InternalPictureCommand((Document)containerDoc.getNativeItem(), pictureIndex));
            }
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchPicture(cmsCtx, docPath, content);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    private CMSBinaryContent fetchPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
        try {
            cmsCtx.setForcePublicationInfosScope("superuser_context");
            CMSPublicationInfos publiInfos = this.getPublicationInfos(cmsCtx, docPath);
            cmsCtx.setForcePublicationInfosScope(null);
            if (publiInfos.isAnonymouslyReadable()) {
                cmsCtx.setForcePublicationInfosScope("anonymous");
            }
            CMSItem picture = this.fetchContent(cmsCtx, publiInfos.getDocumentPath());
            cmsCtx.setScope("superuser_context");
            pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PictureContentCommand((Document)picture.getNativeItem(), content));
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    CMSBinaryContent cMSBinaryContent = null;
                    return cMSBinaryContent;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
            cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getFileContent(CMSServiceCtx cmsCtx, String docPath, String fieldName) throws CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchFileContent(cmsCtx, docPath, fieldName);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchFileContent(CMSServiceCtx cmsContext, String path, String fieldName) throws Exception {
        CMSBinaryContent content;
        String savedScope = cmsContext.getScope();
        if (StringUtils.isNotEmpty((String)savedScope)) {
            cmsContext.setForcePublicationInfosScope(savedScope);
        }
        try {
            Document nuxeoDocument = null;
            try {
                if (!"downloadVersion".equals(cmsContext.getDisplayContext())) {
                    CMSItem document = this.fetchContent(cmsContext, path);
                    if (document != null) {
                        nuxeoDocument = (Document)document.getNativeItem();
                    }
                } else {
                    FetchDocumentByUUIDCommand fetchVersion = new FetchDocumentByUUIDCommand(path);
                    cmsContext.setScope("superuser_context");
                    nuxeoDocument = (Document)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)fetchVersion);
                }
            }
            catch (CMSException e) {
                User u = (User)cmsContext.getServerInvocation().getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"user");
                LOG.warn((Object)("Unable to fetch content on " + path + " for " + u.getUserName()));
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            if (nuxeoDocument != null) {
                Long length;
                PropertyMap map;
                FileContentCommand command = new FileContentCommand(nuxeoDocument, fieldName);
                cmsContext.setScope("superuser_context");
                if (cmsContext.isStreamingSupport() && (map = nuxeoDocument.getProperties().getMap("file:content")) != null && (length = map.getLong("length")) != null && length > 102400L) {
                    command.setStreamingSupport(true);
                    cmsContext.setScope("superuser_no_cache");
                }
                content = (CMSBinaryContent)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            } else {
                content = null;
            }
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        return content;
    }

    public boolean checkContentAnonymousAccess(CMSServiceCtx cmsCtx, String path) throws CMSException {
        try {
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsCtx, path);
            return pubInfos.isAnonymouslyReadable();
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return false;
    }

    public Player getItemHandler(CMSServiceCtx ctx) throws CMSException {
        try {
            if (!"detailedView".equals(ctx.getDisplayContext())) {
                return this.getNuxeoService().getCMSCustomizer().getCMSPlayer(ctx);
            }
            return ((DefaultCMSCustomizer)this.getNuxeoService().getCMSCustomizer()).getCMSDefaultPlayer(ctx);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return null;
    }

    public Map<String, NavigationItem> loadPartialNavigationTree(CMSServiceCtx cmsCtx, CMSItem publishSpaceConfig, String path, boolean fetchSubItems) throws CMSException {
        String savedScope = cmsCtx.getScope();
        try {
            Map<String, Object> navItems = null;
            ArrayList<String> idsToFetch = new ArrayList<String>();
            boolean fetchRoot = false;
            String cacheId = "partial_navigation_tree/" + publishSpaceConfig.getPath();
            HttpServletRequest request = cmsCtx.getServerInvocation().getServerContext().getClientRequest();
            boolean refreshing = PageProperties.getProperties().isRefreshingPage();
            PartialNavigationInvoker partialNavInvoker = null;
            if (refreshing) {
                partialNavInvoker = (PartialNavigationInvoker)request.getAttribute("partialNavInvoker");
            }
            CacheInfo cacheInfos = new CacheInfo(cacheId, CacheInfo.CACHE_SCOPE_PORTLET_SESSION, null, (Object)request, this.portletCtx, false);
            cacheInfos.setExpirationDelay(200000L);
            navItems = (HashMap<String, NavigationItem>)this.getCacheService().getCache(cacheInfos);
            if (navItems == null) {
                navItems = new HashMap<String, NavigationItem>();
                fetchRoot = true;
            }
            String pathToCheck = path;
            CMSServiceCtx superUserCtx = new CMSServiceCtx();
            superUserCtx.setControllerContext(cmsCtx.getControllerContext());
            cmsCtx.setScope("superuser_context");
            boolean isParent = false;
            while (pathToCheck.contains(publishSpaceConfig.getPath())) {
                Document doc;
                NavigationItem navItem = (NavigationItem)navItems.get(pathToCheck);
                if (navItem != null && (fetchSubItems || isParent) && navItem.isUnfetchedChildren() && !idsToFetch.contains((doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(pathToCheck, "Read"))).getId())) {
                    idsToFetch.add(doc.getId());
                }
                if (navItem == null && !idsToFetch.contains((doc = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentFetchLiveCommand(pathToCheck, "Read"))).getId())) {
                    idsToFetch.add(doc.getId());
                }
                CMSObjectPath parentPath = CMSObjectPath.parse((String)pathToCheck).getParent();
                pathToCheck = parentPath.toString();
                isParent = true;
            }
            if (idsToFetch.size() > 0 || fetchRoot) {
                cmsCtx.setScope("__nocache");
                navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PartialNavigationCommand(publishSpaceConfig, navItems, idsToFetch, fetchRoot, path));
                cacheInfos.setForceReload(true);
                cacheInfos.setForceNOTReload(false);
                partialNavInvoker = new PartialNavigationInvoker(navItems);
                if (refreshing) {
                    request.setAttribute("partialNavInvoker", (Object)partialNavInvoker);
                }
                cacheInfos.setInvoker((IServiceInvoker)partialNavInvoker);
                this.getCacheService().getCache(cacheInfos);
            }
            HashMap<String, NavigationItem> hashMap = navItems;
            return hashMap;
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
    }

    public CMSItem getPortalNavigationItem(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            String livePath = DocumentHelper.computeNavPath((String)path);
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new CMSException(3);
            }
            Map navItems = null;
            boolean forceLiveVersion = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion()) || "1".equals(publishSpaceConfig.getProperties().get("displayLiveVersion"))) {
                forceLiveVersion = true;
            }
            if ((navItems = "1".equals(publishSpaceConfig.getProperties().get("partialLoading")) ? this.loadPartialNavigationTree(cmsCtx, publishSpaceConfig, path, false) : (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentPublishSpaceNavigationCommand(publishSpaceConfig, forceLiveVersion))) != null && (navItem = (NavigationItem)navItems.get(livePath)) != null) {
                CMSItem item = navItem.getAdaptedCMSItem();
                if (item == null) {
                    if (navItem.getMainDoc() != null) {
                        navItem.setAdaptedCMSItem(this.createNavigationItem(cmsCtx, livePath, ((Document)navItem.getMainDoc()).getTitle(), (Document)navItem.getMainDoc(), publishSpaceConfig.getPath()));
                    } else {
                        CMSItem cMSItem = null;
                        return cMSItem;
                    }
                }
                CMSItem cMSItem = navItem.getAdaptedCMSItem();
                return cMSItem;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    public List<CMSItem> getPortalNavigationSubitems(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new CMSException(3);
            }
            Map navItems = null;
            boolean forceLiveVersion = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion()) || "1".equals(publishSpaceConfig.getProperties().get("displayLiveVersion"))) {
                forceLiveVersion = true;
            }
            if ((navItems = "1".equals(publishSpaceConfig.getProperties().get("partialLoading")) ? this.loadPartialNavigationTree(cmsCtx, publishSpaceConfig, path, true) : (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentPublishSpaceNavigationCommand(publishSpaceConfig, forceLiveVersion))) != null && (navItem = (NavigationItem)navItems.get(path)) != null) {
                ArrayList<CMSItem> childrens = new ArrayList<CMSItem>();
                for (Object child : navItem.getChildren()) {
                    Document docChild = (Document)child;
                    String childNavPath = DocumentHelper.computeNavPath((String)docChild.getPath());
                    NavigationItem navChild = (NavigationItem)navItems.get(childNavPath);
                    CMSItem item = navChild.getAdaptedCMSItem();
                    if (item == null && navChild.getMainDoc() != null) {
                        item = this.createNavigationItem(cmsCtx, childNavPath, ((Document)navChild.getMainDoc()).getTitle(), (Document)navChild.getMainDoc(), publishSpacePath);
                        navChild.setAdaptedCMSItem(item);
                    }
                    if (item != null) {
                        item.getProperties().put("unfetchedChildren", BooleanUtils.toStringTrueFalse((boolean)navChild.isUnfetchedChildren()));
                    }
                    childrens.add(navChild.getAdaptedCMSItem());
                }
                ArrayList<CMSItem> arrayList = childrens;
                return arrayList;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CMSItem> getPortalSubitems(CMSServiceCtx cmsContext, String path) throws CMSException {
        try {
            String parentId;
            String version = cmsContext.getDisplayLiveVersion();
            try {
                cmsContext.setDisplayLiveVersion("1");
                Document parent = (Document)this.fetchContent(cmsContext, path).getNativeItem();
                parentId = parent.getId();
            }
            finally {
                cmsContext.setDisplayLiveVersion(version);
            }
            RequestPublishStatus publishStatus = RequestPublishStatus.setRequestPublishStatus((String)version);
            ListCMSSubitemsCommand nuxeoCommand = new ListCMSSubitemsCommand(cmsContext, parentId, publishStatus);
            return (List)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSPublicationInfos getPublicationInfos(CMSServiceCtx ctx, String path) throws CMSException {
        CMSPublicationInfos pubInfos = new CMSPublicationInfos();
        try {
            String savedScope = ctx.getScope();
            try {
                List errors;
                if (StringUtils.isNotEmpty((String)ctx.getForcePublicationInfosScope())) {
                    ctx.setScope(ctx.getForcePublicationInfosScope());
                } else if (ctx.getServerInvocation() != null) {
                    ServerInvocation invocation = ctx.getServerInvocation();
                    User user = (User)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"user");
                    if (user == null) {
                        ctx.setScope("anonymous");
                    } else {
                        ctx.setScope("user_session");
                    }
                }
                pubInfos = (CMSPublicationInfos)this.executeNuxeoCommand(ctx, (INuxeoCommand)new PublishInfosCommand(path));
                if (pubInfos != null && (errors = pubInfos.getErrorCodes()) != null) {
                    if (errors.contains(2)) {
                        throw new CMSException(1);
                    }
                    if (errors.contains(1)) {
                        throw new CMSException(3);
                    }
                }
            }
            finally {
                ctx.setScope(savedScope);
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return pubInfos;
    }

    public List<CMSItem> getWorkspaces(CMSServiceCtx cmsContext, boolean userWorkspaces, boolean administrator) throws CMSException {
        BrowserAdapter browserAdapter = this.customizer.getBrowserAdapter();
        List workspaces = userWorkspaces ? browserAdapter.getUserWorkspaces(cmsContext) : browserAdapter.getWorkspaces(cmsContext, administrator);
        return workspaces;
    }

    public Map<String, NavigationItem> getFullLoadedPortalNavigationItems(CMSServiceCtx cmsContext, String basePath) throws CMSException {
        LinkedHashMap navigationItems;
        boolean liveVersion = "1".equals(cmsContext.getDisplayLiveVersion());
        PortletRequest request = cmsContext.getRequest();
        if (request == null) {
            navigationItems = null;
        } else {
            String name = FullLoadedNavigationItems.getRequestAttributeName((String)basePath);
            FullLoadedNavigationItems fullLoadedNavigationItems = (FullLoadedNavigationItems)request.getAttribute(name);
            if (fullLoadedNavigationItems == null) {
                FullLoadedNavigationCommand command = new FullLoadedNavigationCommand(basePath, liveVersion);
                try {
                    Documents documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                    navigationItems = new LinkedHashMap(documents.size());
                    for (Document document : documents.list()) {
                        String path = StringUtils.removeEnd((String)document.getPath(), (String)".proxy");
                        NavigationItem navigationItem = this.getNavigationItem(navigationItems, path);
                        navigationItem.setMainDoc((Object)document);
                        CMSItem cmsItem = this.createNavigationItem(cmsContext, path, document.getTitle(), document, basePath);
                        navigationItem.setAdaptedCMSItem(cmsItem);
                        PortalObjectPath objectPath = PortalObjectPath.parse((String)path, (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT);
                        PortalObjectPath parentObjectPath = objectPath.getParent();
                        String parentPath = parentObjectPath.toString(PortalObjectPath.CANONICAL_FORMAT);
                        if (!StringUtils.startsWith((String)parentPath, (String)basePath)) continue;
                        NavigationItem parentNavigationItem = this.getNavigationItem(navigationItems, parentPath);
                        parentNavigationItem.getChildren().add(navigationItem);
                    }
                    fullLoadedNavigationItems = new FullLoadedNavigationItems(basePath, navigationItems);
                    request.setAttribute(name, (Object)fullLoadedNavigationItems);
                }
                catch (NuxeoException e) {
                    navigationItems = null;
                    e.rethrowCMSException();
                }
                catch (CMSException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CMSException((Throwable)e);
                }
            } else {
                navigationItems = fullLoadedNavigationItems.getNavigationItems();
            }
        }
        return navigationItems;
    }

    private NavigationItem getNavigationItem(Map<String, NavigationItem> items, String path) {
        NavigationItem item = items.get(path);
        if (item == null) {
            item = new NavigationItem();
            items.put(path, item);
        }
        return item;
    }

    public ExtendedDocumentInfos getExtendedDocumentInfos(CMSServiceCtx cmsContext, String path) throws CMSException {
        String attributeName;
        HttpServletRequest request = cmsContext.getServletRequest();
        ExtendedDocumentInfos infos = (ExtendedDocumentInfos)request.getAttribute(attributeName = EXTENDED_DOCUMENT_INFOS_ATTRIBUTE_PREFIX + StringEscapeUtils.escapeHtml((String)path));
        if (infos == null) {
            infos = new ExtendedDocumentInfos();
            try {
                if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_60) && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                    ExtendedDocumentInfosCommand command = new ExtendedDocumentInfosCommand(path);
                    infos = (ExtendedDocumentInfos)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                }
            }
            catch (NuxeoException e) {
                e.rethrowCMSException();
            }
            catch (CMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CMSException((Throwable)e);
            }
            request.setAttribute(attributeName, (Object)infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSItem getSpaceConfig(CMSServiceCtx cmsCtx, String publishSpacePath) throws CMSException {
        CMSItem configItem = null;
        HttpServletRequest portalRequest = cmsCtx.getServerInvocation().getServerContext().getClientRequest();
        boolean forceLiveVersion = false;
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            forceLiveVersion = true;
        }
        String requestKey = "osivia.cache.spaceConfig." + publishSpacePath + "." + forceLiveVersion;
        try {
            CMSItem value = (CMSItem)portalRequest.getAttribute(requestKey);
            if (value != null) {
                if (PageProperties.getProperties().isRefreshingPage() && portalRequest.getAttribute(requestKey + ".resfreshed") == null) {
                    portalRequest.setAttribute(requestKey + ".resfreshed", (Object)"1");
                    value = null;
                }
                if (value != null) {
                    return value;
                }
            }
            String savedScope = cmsCtx.getScope();
            String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
            try {
                cmsCtx.setForcePublicationInfosScope("superuser_context");
                configItem = this.fetchContent(cmsCtx, publishSpacePath);
                this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(configItem, configItem);
                portalRequest.setAttribute(requestKey, (Object)configItem);
            }
            finally {
                cmsCtx.setScope(savedScope);
                cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
            }
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
        return configItem;
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws CMSException {
        try {
            return this.customizer.parseCMSURL(cmsCtx, requestPath, requestParameters);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public String adaptWebPathToCms(CMSServiceCtx cmsContext, String requestPath) throws CMSException {
        try {
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsContext, requestPath);
            return pubInfos.getDocumentPath();
        }
        catch (NuxeoException e) {
            if (e.getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                return null;
            }
            throw new CMSException((Throwable)e);
        }
        catch (CMSException e) {
            throw e;
        }
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws CMSException {
        try {
            return this.customizer.computeUserPreloadedPages(cmsCtx);
        }
        catch (Exception e) {
            if (!(e instanceof CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                    return null;
                }
                throw new CMSException((Throwable)e);
            }
            throw (CMSException)((Object)e);
        }
    }

    public List<CMSEditableWindow> getEditableWindows(CMSServiceCtx cmsContext, String path, String publishSpacePath, String sitePath, String navigationScope, Boolean isSpaceSite) throws CMSException {
        ArrayList<CMSEditableWindow> windows = new ArrayList<CMSEditableWindow>();
        String workingPath = path == null ? sitePath : path;
        boolean editionMode = false;
        if ("1".equals(cmsContext.getDisplayLiveVersion())) {
            editionMode = true;
        }
        Map inheritedRegions = new HashMap();
        int windowsCount = 0;
        if (isSpaceSite.booleanValue()) {
            inheritedRegions = this.getInheritedRegions(cmsContext, workingPath, publishSpacePath, sitePath, navigationScope, editionMode);
            for (List inheritedWindows : inheritedRegions.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)inheritedWindows)) continue;
                windows.addAll(inheritedWindows);
            }
            windowsCount = windows.size();
        }
        try {
            PropertyList fragments;
            CMSItem pageItem = this.fetchContent(cmsContext, workingPath);
            Document document = (Document)pageItem.getNativeItem();
            if (publishSpacePath != null && (fragments = document.getProperties().getList("fgts:fragments")) != null && !fragments.isEmpty()) {
                Map editableWindows = this.customizer.getEditableWindows(cmsContext.getServerInvocation().getRequest().getLocales()[0]);
                int regionWindowsCount = 0;
                for (int i = 0; i < fragments.size(); ++i) {
                    PropertyMap fragment = fragments.getMap(i);
                    String regionId = fragment.getString("regionId");
                    if (inheritedRegions.get(regionId) != null) continue;
                    String category = fragment.getString("fragmentCategory");
                    EditableWindow editableWindow = (EditableWindow)editableWindows.get(category);
                    if (editableWindow != null) {
                        int windowId = windowsCount + regionWindowsCount;
                        Map properties = editableWindow.fillProps(document, fragment, Boolean.valueOf(editionMode));
                        CMSEditableWindow window = editableWindow.createNewEditabletWindow(windowId, properties);
                        windows.add(window);
                        ++regionWindowsCount;
                        continue;
                    }
                    LOG.warn((Object)("Type de fragment " + category + " non g\u00e9r\u00e9"));
                }
            }
        }
        catch (CMSException e) {
            if (e.getErrorCode() != 1) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return windows;
    }

    private Map<String, List<CMSEditableWindow>> getInheritedRegions(CMSServiceCtx cmsContext, String path, String publishSpacePath, String sitePath, String navigationScope, boolean editionMode) {
        boolean directInheritance;
        HashMap<String, List<CMSEditableWindow>> inheritedRegions = new HashMap<String, List<CMSEditableWindow>>();
        CMSServiceCtx navCMSContext = new CMSServiceCtx();
        if (cmsContext.getControllerContext() != null) {
            navCMSContext.setControllerContext(cmsContext.getControllerContext());
        } else if (cmsContext.getServerInvocation() != null) {
            navCMSContext.setServerInvocation(cmsContext.getServerInvocation());
        }
        navCMSContext.setScope(navigationScope);
        Set overridedRegions = this.getPageOverridedRegions(cmsContext, path, publishSpacePath);
        int windowId = 0;
        String parentPath = CMSObjectPath.parse((String)path).getParent().toString();
        while (StringUtils.startsWith((String)parentPath, (String)publishSpacePath)) {
            Map pagePropagatedRegions = this.getPagePropagatedRegions(navCMSContext, overridedRegions, windowId, parentPath, publishSpacePath, editionMode);
            inheritedRegions.putAll(pagePropagatedRegions);
            overridedRegions.addAll(pagePropagatedRegions.keySet());
            for (List windows : pagePropagatedRegions.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)windows)) continue;
                windowId += windows.size();
            }
            parentPath = CMSObjectPath.parse((String)parentPath).getParent().toString();
        }
        boolean bl = directInheritance = publishSpacePath != null && StringUtils.startsWith((String)path, (String)sitePath);
        if (!directInheritance) {
            Map pagePropagatedRegions = this.getPagePropagatedRegions(navCMSContext, overridedRegions, windowId, sitePath, sitePath, editionMode);
            inheritedRegions.putAll(pagePropagatedRegions);
        }
        return inheritedRegions;
    }

    private Set<String> getPageOverridedRegions(CMSServiceCtx cmsContext, String path, String publishSpacePath) {
        TreeSet<String> overridedRegions = new TreeSet<String>();
        try {
            CMSItem navItem = this.getPortalNavigationItem(cmsContext, publishSpacePath, path);
            if (navItem != null) {
                Map regionsInheritance = this.getCMSRegionsInheritance(navItem);
                for (Map.Entry region : regionsInheritance.entrySet()) {
                    if (RegionInheritance.DEFAULT.equals(region.getValue())) continue;
                    overridedRegions.add((String)region.getKey());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return overridedRegions;
    }

    private Map<String, List<CMSEditableWindow>> getPagePropagatedRegions(CMSServiceCtx cmsContext, Set<String> overridedRegions, int windowsCount, String path, String publishSpacePath, boolean editionMode) {
        HashMap<String, List<CMSEditableWindow>> pagePropagatedRegions;
        block14: {
            pagePropagatedRegions = new HashMap<String, List<CMSEditableWindow>>();
            try {
                String regionId;
                PropertyMap fragment;
                PropertyList fragments;
                CMSItem item;
                CMSItem navItem = this.getPortalNavigationItem(cmsContext, publishSpacePath, path);
                if (navItem == null) break block14;
                HashSet<Object> propagatedRegions = new HashSet<Object>();
                HashSet lockedRegions = new HashSet();
                Document document = null;
                boolean fetched = false;
                Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
                if (PortalObjectUtils.isSpaceSite((PortalObject)portal)) {
                    Map inheritance = this.getCMSRegionsInheritance(navItem);
                    for (Map.Entry region : inheritance.entrySet()) {
                        if (RegionInheritance.LOCKED.equals(region.getValue())) {
                            pagePropagatedRegions.put((String)region.getKey(), new ArrayList());
                            propagatedRegions.add(region.getKey());
                            lockedRegions.add(region.getKey());
                            continue;
                        }
                        if (overridedRegions.contains(region.getKey())) continue;
                        if (RegionInheritance.NO_INHERITANCE.equals(region.getValue())) {
                            pagePropagatedRegions.put((String)region.getKey(), (List<CMSEditableWindow>)null);
                            continue;
                        }
                        if (!RegionInheritance.PROPAGATED.equals(region.getValue())) continue;
                        pagePropagatedRegions.put((String)region.getKey(), new ArrayList());
                        propagatedRegions.add(region.getKey());
                    }
                } else {
                    item = this.fetchContent(cmsContext, path);
                    fetched = true;
                    if (item != null) {
                        document = (Document)item.getNativeItem();
                        fragments = document.getProperties().getList("fgts:fragments");
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragment = fragments.getMap(i);
                            regionId = fragment.getString("regionId");
                            if (propagatedRegions.contains(regionId)) continue;
                            pagePropagatedRegions.put(regionId, new ArrayList());
                            propagatedRegions.add(regionId);
                        }
                    }
                }
                if (!propagatedRegions.isEmpty()) {
                    if (!fetched && (item = this.fetchContent(cmsContext, path)) != null) {
                        document = (Document)item.getNativeItem();
                    }
                    if (document != null) {
                        int regionWindowsCount = 0;
                        fragments = document.getProperties().getList("fgts:fragments");
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragment = fragments.getMap(i);
                            regionId = fragment.getString("regionId");
                            if (!propagatedRegions.contains(regionId)) continue;
                            String category = fragment.getString("fragmentCategory");
                            Map editableWindows = this.customizer.getEditableWindows(cmsContext.getServerInvocation().getRequest().getLocales()[0]);
                            EditableWindow editableWindow = (EditableWindow)editableWindows.get(category);
                            if (editableWindow == null) continue;
                            List windows = (List)pagePropagatedRegions.get(regionId);
                            int windowId = windowsCount + regionWindowsCount;
                            Map properties = editableWindow.fillProps(document, fragment, Boolean.valueOf(editionMode));
                            properties.put("osivia.cms.inheritance.indicator", String.valueOf(true));
                            if (lockedRegions.contains(regionId)) {
                                properties.put("osivia.cms.inheritance.locked", String.valueOf(true));
                            }
                            CMSEditableWindow window = editableWindow.createNewEditabletWindow(windowId, properties);
                            windows.add(window);
                            ++regionWindowsCount;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pagePropagatedRegions;
    }

    public Map<String, RegionInheritance> getCMSRegionsInheritance(CMSItem item) {
        Document document;
        PropertyList regions;
        HashMap<String, RegionInheritance> regionsInheritance = new HashMap<String, RegionInheritance>();
        if (item != null && (regions = (document = (Document)item.getNativeItem()).getProperties().getList("rg:regions")) != null) {
            for (int i = 0; i < regions.size(); ++i) {
                PropertyMap region = regions.getMap(i);
                String id = region.getString("regionId");
                RegionInheritance inheritance = RegionInheritance.fromValue((String)region.getString("inheritance"));
                regionsInheritance.put(id, inheritance);
            }
        }
        return regionsInheritance;
    }

    public void saveCMSRegionInheritance(CMSServiceCtx cmsContext, String path, String regionName, RegionInheritance inheritance) throws CMSException {
        cmsContext.setDisplayLiveVersion("1");
        try {
            CMSItem cmsItem = this.getContent(cmsContext, path);
            Document document = (Document)cmsItem.getNativeItem();
            PropertyList regions = document.getProperties().getList("rg:regions");
            if (regions != null) {
                DocumentUpdatePropertiesCommand command;
                ArrayList<String> properties = new ArrayList<String>();
                for (int i = 0; i < regions.size(); ++i) {
                    PropertyMap region = regions.getMap(i);
                    if (!StringUtils.equals((String)regionName, (String)region.getString("regionId"))) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("rg:regions");
                    builder.append(SLASH);
                    builder.append(i);
                    builder.append(SLASH);
                    builder.append("inheritance");
                    builder.append("=");
                    builder.append(StringUtils.trimToEmpty((String)inheritance.getValue()));
                    properties.add(builder.toString());
                    break;
                }
                if (properties.isEmpty()) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("regionId", regionName);
                    value.put("inheritance", StringUtils.trimToEmpty((String)inheritance.getValue()));
                    command = new DocumentAddComplexPropertyCommand(document, "rg:regions", value);
                } else {
                    command = new DocumentUpdatePropertiesCommand(document, properties);
                }
                this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Set<CMSConfigurationItem> getCMSRegionLayoutsConfigurationItems(CMSServiceCtx cmsContext) throws CMSException {
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsContext);
        HashSet<CMSConfigurationItem> configurationItems = null;
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.REGION_LAYOUT);
            try {
                Documents documents = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)cmsContext, (CMSService)this, (WebConfigurationQueryCommand)command);
                configurationItems = new HashSet<CMSConfigurationItem>(documents.size());
                for (Document document : documents) {
                    PropertyMap properties = document.getProperties();
                    String code = properties.getString("wconf:code");
                    String additionalCode = properties.getString("wconf:code2");
                    CMSConfigurationItem configurationItem = new CMSConfigurationItem(document.getTitle(), code);
                    configurationItem.setAdditionalCode(additionalCode);
                    configurationItems.add(configurationItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configurationItems;
    }

    public Map<String, CMSConfigurationItem> getCMSRegionsSelectedLayout(CMSItem item, Set<CMSConfigurationItem> regionLayouts) throws CMSException {
        Document document;
        PropertyList regions;
        HashMap<String, CMSConfigurationItem> regionsLayout = new HashMap<String, CMSConfigurationItem>();
        if (item != null && (regions = (document = (Document)item.getNativeItem()).getProperties().getList("rg:regions")) != null) {
            for (int i = 0; i < regions.size(); ++i) {
                PropertyMap region = regions.getMap(i);
                String id = region.getString("regionId");
                String regionLayoutCode = region.getString("regionLayout");
                CMSConfigurationItem selectedRegionLayout = null;
                for (CMSConfigurationItem regionLayout : regionLayouts) {
                    if (!StringUtils.equals((String)regionLayout.getCode(), (String)regionLayoutCode)) continue;
                    selectedRegionLayout = regionLayout;
                    break;
                }
                regionsLayout.put(id, selectedRegionLayout);
            }
        }
        return regionsLayout;
    }

    public void saveCMSRegionSelectedLayout(CMSServiceCtx cmsContext, String path, String regionName, String regionLayoutName) throws CMSException {
        cmsContext.setDisplayLiveVersion("1");
        try {
            CMSItem cmsItem = this.getContent(cmsContext, path);
            Document document = (Document)cmsItem.getNativeItem();
            PropertyList regions = document.getProperties().getList("rg:regions");
            if (regions != null) {
                DocumentUpdatePropertiesCommand command;
                ArrayList<String> properties = new ArrayList<String>();
                for (int i = 0; i < regions.size(); ++i) {
                    PropertyMap region = regions.getMap(i);
                    if (!StringUtils.equals((String)regionName, (String)region.getString("regionId"))) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("rg:regions");
                    builder.append(SLASH);
                    builder.append(i);
                    builder.append(SLASH);
                    builder.append("regionLayout");
                    builder.append("=");
                    builder.append(StringUtils.trimToEmpty((String)regionLayoutName));
                    properties.add(builder.toString());
                    break;
                }
                if (properties.isEmpty()) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("regionId", regionName);
                    value.put("regionLayout", StringUtils.trimToEmpty((String)regionLayoutName));
                    command = new DocumentAddComplexPropertyCommand(document, "rg:regions", value);
                } else {
                    command = new DocumentUpdatePropertiesCommand(document, properties);
                }
                this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteFragment(CMSServiceCtx cmsCtx, String pagePath, String refURI) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        PropertyList fragments = doc.getProperties().getList("fgts:fragments");
        List propertiesToRemove = null;
        if (fragments != null && !fragments.isEmpty()) {
            for (int fragmentIndex = 0; fragmentIndex < fragments.size(); ++fragmentIndex) {
                if (!refURI.equals(fragments.getMap(fragmentIndex).get("uri"))) continue;
                String fragmentCategory = (String)fragments.getMap(fragmentIndex).get("fragmentCategory");
                Map editableWindows = this.customizer.getEditableWindows(cmsCtx.getServerInvocation().getRequest().getLocales()[0]);
                EditableWindow ew = (EditableWindow)editableWindows.get(fragmentCategory);
                if (ew == null) continue;
                propertiesToRemove = ew.prepareDelete(doc, refURI);
            }
        }
        try {
            if (propertiesToRemove != null) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentRemovePropertyCommand(doc, propertiesToRemove));
                cmsCtx.setForceReload(true);
                this.getContent(cmsCtx, pagePath);
                cmsCtx.setForceReload(false);
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public String getEcmDomain(CMSServiceCtx cmsCtx) {
        String fqdn = NuxeoConnectionProperties.getPublicDomainUri().toString();
        if (StringUtils.isBlank((String)fqdn) && cmsCtx != null && cmsCtx.getRequest() != null) {
            String vhost = null;
            if (cmsCtx.getServletRequest() != null) {
                vhost = cmsCtx.getServletRequest().getHeader("osivia-virtual-host");
            }
            if (StringUtils.isNotBlank(vhost)) {
                return vhost;
            }
            return cmsCtx.getRequest().getScheme() + "://" + cmsCtx.getRequest().getServerName();
        }
        return fqdn;
    }

    public String getEcmUrl(CMSServiceCtx cmsCtx, EcmViews command, String path, Map<String, String> requestParameters) throws CMSException {
        String uri = NuxeoConnectionProperties.getPublicBaseUri().toString();
        if (requestParameters == null) {
            requestParameters = new HashMap<String, String>();
        }
        String url = "";
        if (command == EcmViews.createPage) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_document?";
            requestParameters.put("type", "PortalPage");
        } else if (command == EcmViews.createDocument) {
            url = uri.toString() + "/nxpath/default" + path + "@toutatice_create?";
        } else if (command == EcmViews.editDocument) {
            url = uri.toString() + "/nxpath/default" + path + "@toutatice_edit?";
        } else if (command == EcmViews.editPage) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_edit_document?";
        } else if (command == EcmViews.createFgtInRegion) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_fragment?";
        } else if (command == EcmViews.createFgtBelowWindow) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_create_fragment?";
        } else if (command == EcmViews.editFgt) {
            url = uri.toString() + "/nxpath/default" + path + "@osivia_edit_fragment?";
        } else if (command == EcmViews.viewSummary) {
            url = uri.toString() + "/nxpath/default" + path + "@view_documents?";
        } else if (command == EcmViews.shareDocument) {
            url = uri.toString() + "/nxpath/default" + path + "@send_notification_email?";
        } else if (command == EcmViews.startValidationWf) {
            url = uri.toString() + "/nxpath/default" + path + "@choose_wf?";
        } else if (command == EcmViews.followWfValidation) {
            url = uri.toString() + "/nxpath/default" + path + "@current_task?";
        } else if (command == EcmViews.remotePublishing) {
            url = uri.toString() + "/nxpath/default" + path + "@remote_publishing?";
        } else if (command == EcmViews.validateRemotePublishing) {
            url = uri.toString() + "/nxpath/default" + path + "@validate_remote_publishing?";
        } else if (command == EcmViews.globalAdministration) {
            url = uri.toString() + "/nxadmin/default@view_admin?";
        } else if (command == EcmViews.gotoMediaLibrary) {
            Document mediaLibrary;
            try {
                String baseDomainPath = SLASH.concat(path.split(SLASH)[1]);
                mediaLibrary = (Document)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentGetMediaLibraryCommand(baseDomainPath));
            }
            catch (Exception e) {
                throw new CMSException((Throwable)e);
            }
            url = mediaLibrary != null ? uri.toString() + "/nxpath/default" + mediaLibrary.getPath() + "@view_documents?" : "";
        } else if (EcmViews.RELOAD.equals((Object)command)) {
            url = uri.toString() + "/nxpath/default@refresh_principal";
        }
        if (!EcmViews.gotoMediaLibrary.equals((Object)command) && !EcmViews.RELOAD.equals((Object)command)) {
            Document currentDoc;
            Portal portal;
            PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsCtx.getControllerContext());
            String portalUrl = this.getPortalUrlFactory().getBasePortalUrl(portalControllerContext);
            requestParameters.put("fromUrl", portalUrl);
            if ((command == EcmViews.editPage || command == EcmViews.editDocument) && PortalObjectUtils.isSpaceSite((PortalObject)(portal = PortalObjectUtils.getPortal((ControllerContext)ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext)))) && (currentDoc = (Document)cmsCtx.getDoc()) != null) {
                String webId = (String)currentDoc.getProperties().get("ttc:webid");
                String webPath = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, "/_id".concat(SLASH).concat(webId), null, null, cmsCtx.getDisplayContext(), cmsCtx.getHideMetaDatas(), null, cmsCtx.getDisplayLiveVersion(), null);
                if (StringUtils.isNotBlank((String)webPath)) {
                    webPath = StringUtils.substringBeforeLast((String)webPath, (String)SLASH).concat(SLASH);
                }
                requestParameters.put("portalWebPath", webPath);
            }
            for (Map.Entry<String, String> param : requestParameters.entrySet()) {
                url = url.concat(param.getKey()).concat("=").concat(param.getValue()).concat("&");
            }
        }
        return url;
    }

    public void moveFragment(CMSServiceCtx cmsCtx, String pagePath, String fromRegion, Integer fromPos, String toRegion, Integer toPos, String refUri) throws CMSException {
        cmsCtx.setForceReload(true);
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            List propertiesToUpdate = EditableWindowHelper.checkBeforeMove((Document)doc, (String)fromRegion, (Integer)fromPos, (String)refUri);
            if (propertiesToUpdate.size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                CMSItem content = this.getContent(cmsCtx, pagePath);
                doc = (Document)content.getNativeItem();
            }
            if ((propertiesToUpdate = EditableWindowHelper.prepareMove((Document)doc, (String)fromRegion, (Integer)fromPos, (String)toRegion, (Integer)toPos, (String)refUri)).size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                this.getContent(cmsCtx, pagePath);
            }
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        finally {
            cmsCtx.setForceReload(false);
        }
    }

    public boolean isCmsWebPage(CMSServiceCtx cmsCtx, String cmsPath) throws CMSException {
        CMSItem content = this.getContent(cmsCtx, cmsPath);
        Document nativeItem = (Document)content.getNativeItem();
        PropertyList list = nativeItem.getProperties().getList("fgts:fragments");
        return list != null;
    }

    public void publishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOnLineCommand(doc));
            cmsCtx.setDisplayLiveVersion("0");
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void unpublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        boolean isRemoteProxy;
        Document doc;
        String reloadPagePath = pagePath;
        cmsCtx.setDisplayLiveVersion("0");
        CMSItem cmsPublishedItem = this.getContent(cmsCtx, pagePath);
        Document publishedDoc = (Document)cmsPublishedItem.getNativeItem();
        String publishedDocPath = StringUtils.removeEnd((String)publishedDoc.getPath(), (String)".proxy");
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document inputDoc = doc = (Document)cmsItem.getNativeItem();
        boolean bl = isRemoteProxy = !publishedDocPath.equals(doc.getPath());
        if (isRemoteProxy) {
            inputDoc = publishedDoc;
            reloadPagePath = StringUtils.substringBeforeLast((String)pagePath, (String)SLASH);
            cmsCtx.setDisplayLiveVersion("0");
        }
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOffLineCommand(inputDoc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, reloadPagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void askToPublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new AskSetOnLineCommand(doc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void cancelPublishWorkflow(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new CancelWorkflowCommand(doc, "toutatice_online_approbation"));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void validatePublicationOfDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        this.callValidationCommand(cmsCtx, pagePath, true);
    }

    public void rejectPublicationOfDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        this.callValidationCommand(cmsCtx, pagePath, false);
    }

    public void callValidationCommand(CMSServiceCtx cmsCtx, String pagePath, boolean accept) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new ValidationPublishCommand(doc, accept));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public void deleteDocument(CMSServiceCtx cmsCtx, String pagePath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentDeleteCommand(doc));
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Map<String, String> getNxPathParameters(String cmsPath) {
        String params;
        HashMap<String, String> parameters = new HashMap<String, String>(0);
        if (StringUtils.contains((String)cmsPath, (String)"?") && StringUtils.isNotBlank((String)(params = StringUtils.substringAfter((String)cmsPath, (String)"?")))) {
            String[] keysValues;
            for (String keyValue : keysValues = StringUtils.split((String)params, (String)"&")) {
                String[] keyNValue = StringUtils.split((String)keyValue, (String)"=");
                parameters.put(keyNValue[0], keyNValue[1]);
            }
        }
        return parameters;
    }

    public void putDocumentInTrash(CMSServiceCtx cmsCtx, String docId) throws CMSException {
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PutInTrashDocumentCommand(docId));
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        return this.customizer.refreshUserAvatar(cmsCtx, username);
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws CMSException {
        return this.customizer.getBinaryResourceURL(cmsCtx, binary);
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        return this.customizer.validateBinaryDelegation(cmsCtx, path);
    }

    public void executeEcmCommand(CMSServiceCtx cmsCtx, EcmCommand command, String cmsPath) throws CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, cmsPath);
        Document doc = (Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new NuxeoCommandDelegate(command, doc));
            String refreshCmsPath = command.getStrategy().getRedirectionPathPath();
            cmsCtx.setDisplayLiveVersion("0");
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, refreshCmsPath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public String getParentPath(String documentPath) {
        if (StringUtils.endsWith((String)documentPath, (String)SLASH)) {
            documentPath = StringUtils.removeEnd((String)documentPath, (String)SLASH);
        }
        return StringUtils.substringBeforeLast((String)documentPath, (String)SLASH);
    }

    public TaskbarItems getTaskbarItems(CMSServiceCtx cmsContext) throws CMSException {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeTaskbarItems();
    }

    public List<TaskbarTask> getTaskbarTasks(CMSServiceCtx cmsContext, String basePath, boolean navigation) throws CMSException {
        CMSItem spaceCmsItem = this.getSpaceConfig(cmsContext, basePath);
        Document spaceDocument = (Document)spaceCmsItem.getNativeItem();
        String shortname = spaceDocument.getString("webc:url");
        CMSPublicationInfos publicationInfos = null;
        String webIdPrefix = "workspace_" + shortname + "_";
        List cmsItems = navigation ? this.getPortalNavigationSubitems(cmsContext, basePath, basePath) : this.getChildren(cmsContext, spaceDocument.getId(), 1);
        TaskbarItems taskbarItems = this.getTaskbarItems(cmsContext);
        TaskbarFactory factory = this.taskbarService.getFactory();
        ArrayList<TaskbarTask> tasks = new ArrayList<TaskbarTask>(cmsItems.size());
        for (CMSItem cmsItem : cmsItems) {
            TaskbarTask task;
            Document document = (Document)cmsItem.getNativeItem();
            DocumentType type = cmsItem.getType();
            String webId = document.getString("ttc:webid");
            boolean disabled = !"1".equals(cmsItem.getProperties().get("menuItem"));
            TaskbarItem taskbarItem = null;
            for (TaskbarItem item : taskbarItems.getAll()) {
                String expectedWebId;
                if (!TaskbarItemType.STAPLED.equals((Object)item.getType()) && !StringUtils.isEmpty((String)item.getDocumentType()) && !document.getType().equals(item.getDocumentType()) || !(expectedWebId = webIdPrefix + StringUtils.lowerCase((String)item.getId())).equals(webId)) continue;
                taskbarItem = item;
                break;
            }
            if (taskbarItem == null && type != null) {
                task = factory.createTaskbarTask(document.getId(), document.getTitle(), type.getGlyph(), document.getPath(), type.getName(), disabled);
            } else if (taskbarItem != null) {
                boolean granted;
                TaskbarItemRestriction restriction = taskbarItem.getRestriction();
                if (restriction == null) {
                    granted = true;
                } else {
                    if (publicationInfos == null) {
                        publicationInfos = this.getPublicationInfos(cmsContext, basePath);
                    }
                    granted = TaskbarItemRestriction.EDITION.equals((Object)restriction) ? publicationInfos.isEditableByUser() : (TaskbarItemRestriction.MANAGEMENT.equals((Object)restriction) ? publicationInfos.isManageableByUser() : false);
                }
                task = granted ? factory.createTaskbarTask(taskbarItem, document.getTitle(), document.getPath(), disabled) : null;
            } else {
                task = null;
            }
            if (task == null) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private List<CMSItem> getChildren(CMSServiceCtx cmsContext, String parentId, int state) throws CMSException {
        Documents documents;
        try {
            GetChildrenCommand command = new GetChildrenCommand(parentId, state);
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        ArrayList<CMSItem> cmsItems = new ArrayList<CMSItem>(documents.size());
        for (Document document : documents) {
            CMSItem cmsItem = this.createItem(cmsContext, document.getPath(), document.getTitle(), document);
            cmsItems.add(cmsItem);
        }
        return cmsItems;
    }

    public PanelPlayer getNavigationPanelPlayer(String instance) {
        return (PanelPlayer)this.customizer.getNavigationPanelPlayers().get(instance);
    }

    public String getMoveUrl(CMSServiceCtx cmsContext) throws CMSException {
        String url = null;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, document.getPath());
        DocumentType cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
        if (cmsItemType != null && cmsItemType.isSupportsPortalForms()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.move.documentPath", publicationInfos.getDocumentPath());
            properties.put("osivia.move.cmsBasePath", publicationInfos.getPublishSpacePath());
            properties.put("osivia.move.acceptedTypes", cmsItemType.getName());
            try {
                url = this.urlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                throw new CMSException((Throwable)e);
            }
        }
        return url;
    }

    public String getReorderUrl(CMSServiceCtx cmsContext) throws CMSException {
        String url = null;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, document.getPath());
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62) || !DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)publicationInfos) && publicationInfos.isLiveSpace()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.reorder.path", document.getPath());
            try {
                url = this.urlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-reorder-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                throw new CMSException((Throwable)e);
            }
        }
        return url;
    }

    public String getAdaptedNavigationPath(CMSServiceCtx cmsContext) throws CMSException {
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, document.getPath());
        if (publicationInfos.isDraft()) {
            return publicationInfos.getDraftContextualizationPath();
        }
        String navigationPath = null;
        List adapters = pluginManager.customizeNavigationAdapters();
        for (INavigationAdapterModule adapter : adapters) {
            navigationPath = adapter.adaptNavigationPath(portalControllerContext, (EcmDocument)document);
        }
        return navigationPath;
    }

    public DomainContextualization getDomainContextualization(CMSServiceCtx cmsContext, String domainPath) {
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        List domainContextualizations = pluginManager.customizeDomainContextualization();
        DomainContextualization result = null;
        for (DomainContextualization domainContextualization : domainContextualizations) {
            if (!domainContextualization.contextualize(portalControllerContext, domainPath)) continue;
            result = domainContextualization;
            break;
        }
        return result;
    }

    public DocumentMetadata getDocumentMetadata(CMSServiceCtx cmsContext) throws CMSException {
        DocumentMetadata metadata = new DocumentMetadata();
        Document document = (Document)cmsContext.getDoc();
        if (document != null) {
            PropertyList keywords;
            String author;
            metadata.setTitle(document.getTitle());
            Map seo = metadata.getSeo();
            String description = document.getString("dc:description");
            if (StringUtils.isNotBlank((String)description)) {
                seo.put("description", description);
            }
            if (StringUtils.isNotBlank((String)(author = document.getString("dc:creator")))) {
                seo.put("author", author);
            }
            if ((keywords = document.getProperties().getList("ttc:keywords")) != null && !keywords.isEmpty()) {
                seo.put("keywords", StringUtils.join((Collection)keywords.list(), (String)", "));
            }
        }
        return metadata;
    }

    public DocumentsMetadata getDocumentsMetadata(CMSServiceCtx cmsContext, String basePath, Long timestamp) throws CMSException {
        DocumentsMetadata metadata;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        List adapters = pluginManager.customizeNavigationAdapters();
        RequestPublishStatus version = "1".equals(cmsContext.getDisplayLiveVersion()) ? RequestPublishStatus.live : RequestPublishStatus.published;
        List symlinks = null;
        for (INavigationAdapterModule adapter : adapters) {
            List adapterSymlinks = adapter.getSymlinks(portalControllerContext);
            if (!CollectionUtils.isNotEmpty((Collection)adapterSymlinks)) continue;
            if (CollectionUtils.isEmpty(symlinks)) {
                symlinks = adapterSymlinks;
                continue;
            }
            symlinks.addAll(adapterSymlinks);
        }
        DocumentsMetadataCommand command = new DocumentsMetadataCommand(basePath, version, symlinks, timestamp);
        String savedScope = cmsContext.getScope();
        cmsContext.setScope("superuser_no_cache");
        try {
            metadata = (DocumentsMetadata)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        return metadata;
    }

    public Map<String, TabGroup> getTabGroups(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeTabGroups();
    }

    public List<MenubarModule> getMenubarModules(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeMenubarModules();
    }

    public DocumentContext<? extends EcmDocument> getDocumentContext(CMSServiceCtx cmsContext, String path) throws CMSException {
        NuxeoDocumentContext documentContext;
        try {
            documentContext = NuxeoController.getDocumentContext((CMSServiceCtx)cmsContext, (String)path);
        }
        catch (PortletException e) {
            throw new CMSException((Throwable)e);
        }
        return documentContext;
    }

    public List<TemplateAdapter> getTemplateAdapters(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeTemplateAdapters();
    }

    public List<EcmDocument> getTasks(CMSServiceCtx cmsContext, String user) throws CMSException {
        Documents documents;
        Set actors = this.getTaskActors(user);
        HashSet<String> directives = new HashSet<String>(TaskDirective.values().length);
        for (TaskDirective directive : TaskDirective.values()) {
            directives.add(directive.getId());
        }
        GetTasksCommand command = new GetTasksCommand(actors, true, directives);
        try {
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return new ArrayList<EcmDocument>(documents.list());
    }

    public EcmDocument getTask(CMSServiceCtx cmsContext, String user, String path, UUID uuid) throws CMSException {
        Document task;
        Documents documents;
        Set actors = this.getTaskActors(user);
        GetTasksCommand command = new GetTasksCommand(actors, path, uuid);
        try {
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        if (documents.size() == 1) {
            task = documents.get(0);
        } else {
            task = null;
            procLogger.error((Object)("Found " + documents.size() + " task(s) for " + user + " path=" + path + " uuid=" + uuid));
        }
        return task;
    }

    public boolean updateTask(CMSServiceCtx cmsContext, UUID uuid, String actionId, Map<String, String> variables) throws CMSException {
        boolean updated;
        ControllerContext controllerContext = cmsContext.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        String user = controllerContext.getServerInvocation().getServerContext().getClientRequest().getRemoteUser();
        if (StringUtils.isNotEmpty((String)user)) {
            Set actors = this.getTaskActors(user);
            GetTasksCommand command = new GetTasksCommand(actors, null, uuid);
            try {
                Documents documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                if (documents.size() == 1) {
                    Document task = documents.get(0);
                    this.formsService.proceed(portalControllerContext, task, actionId, variables);
                    updated = true;
                }
                updated = false;
            }
            catch (CMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CMSException((Throwable)e);
            }
        } else {
            throw new CMSException("Unknown user error.");
        }
        return updated;
    }

    public boolean updateTaskNoActor(CMSServiceCtx cmsContext, UUID uuid, String actionId, Map<String, String> variables) throws CMSException {
        boolean updated;
        ControllerContext controllerContext = cmsContext.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        GetTasksCommand command = new GetTasksCommand(null, null, uuid);
        try {
            cmsContext.setScope("superuser_no_cache");
            Documents documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            if (documents.size() == 1) {
                Document task = documents.get(0);
                this.formsService.proceed(portalControllerContext, task, actionId, variables);
                updated = true;
            } else {
                updated = false;
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return updated;
    }

    private Set<String> getTaskActors(String user) {
        HashSet<String> actors = null;
        if (user != null) {
            Name dn = this.personService.getEmptyPerson().buildDn(user);
            Group criteria = this.groupService.getEmptyGroup();
            criteria.setMembers(Arrays.asList(dn));
            List groups = this.groupService.search(criteria);
            actors = new HashSet<String>((groups.size() + 1) * 2);
            actors.add(user);
            actors.add("user:" + user);
            for (Group group : groups) {
                if (group == null) continue;
                String cn = group.getCn();
                actors.add(cn);
                actors.add("group:" + cn);
            }
        }
        return actors;
    }

    public void reloadSession(CMSServiceCtx cmsContext) throws CMSException {
        ControllerContext controllerContext = cmsContext.getControllerContext();
        HttpServletRequest servletRequest = controllerContext.getServerInvocation().getServerContext().getClientRequest();
        HttpSession session = servletRequest.getSession();
        ReloadNuxeoSessionCommand command = new ReloadNuxeoSessionCommand();
        try {
            this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        session.setAttribute("osivia.session.reload", (Object)true);
    }

    public List<EcmDocument> getUserSubscriptions(CMSServiceCtx cmsContext) throws CMSException {
        Documents documents;
        String savedScope = cmsContext.getScope();
        try {
            cmsContext.setScope("user_session");
            GetUserSubscriptionsCommand command = new GetUserSubscriptionsCommand();
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        ArrayList<EcmDocument> subscriptions = new ArrayList<EcmDocument>(documents.size());
        subscriptions.addAll(documents.list());
        return subscriptions;
    }

    public List<SpaceStatistics> getSpaceStatistics(CMSServiceCtx cmsContext, Set<String> paths) throws CMSException {
        if (cmsContext.getPortletCtx() == null) {
            cmsContext.setPortletCtx(this.portletCtx);
        }
        return this.statisticsServiceDelegation.getSpaceStatistics(cmsContext, paths);
    }

    public void updateStatistics(CMSServiceCtx cmsContext, HttpSession httpSession, List<SpaceStatistics> spaceStatistics) throws CMSException {
        if (cmsContext.getPortletCtx() == null) {
            cmsContext.setPortletCtx(this.portletCtx);
        }
        this.statisticsServiceDelegation.updateStatistics(cmsContext, httpSession, spaceStatistics);
    }

    public UserPreferences getUserPreferences(PortalControllerContext context) throws PortalException {
        return this.prefsDelegation.getPreferences(context);
    }

    public void updateUserPreferences(CMSServiceCtx cmsContext, HttpSession httpSession) {
        if (cmsContext.getPortletCtx() == null) {
            cmsContext.setPortletCtx(this.portletCtx);
        }
        this.prefsDelegation.updateUserPreferences(cmsContext, httpSession);
    }
}

