/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.binaries;

public class BytesRange {
    private final long start;
    private final long end;
    private final long length;
    private final long total;

    public BytesRange(long start, long end, long total) {
        this.start = start;
        this.end = end;
        this.length = end - start + 1L;
        this.total = total;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BytesRange [");
        builder.append(this.start);
        builder.append("-");
        builder.append(this.end);
        builder.append("/");
        builder.append(this.total);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BytesRange other = (BytesRange)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.total == other.total;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public long getTotal() {
        return this.total;
    }
}

