/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.RemotePublishedDocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceInvocationHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.CommentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.RemotePublishedDocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.avatar.AvatarServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.binaries.BinaryServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.document.GetPublishedDocumentsInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.FormsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.site.SitePictureServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.thumbnail.ThumbnailServlet;
import fr.toutatice.portail.cms.nuxeo.service.tag.NuxeoTagService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.IEcmCommandervice;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class ViewDocumentPortlet
extends CMSPortlet {
    private static final String HOST_JOKER = "__HOST__";
    public static final String PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String ONLY_DESCRIPTION_WINDOW_PROPERTY = "osivia.document.onlyDescription";
    public static final String ONLY_REMOTE_SECTIONS_WINDOW_PROPERTY = "osivia.document.onlyRemoteSections";
    public static final String REMOTE_SECTIONS_PAGE_WINDOW_PROPERTY = "osivia.document.remoteSectionsPage";
    public static final String HIDE_METADATA_WINDOW_PROPERTY = "osivia.cms.hideMetaDatas";
    public static final String HIDE_ATTACHMENTS_WINDOW_PROPERTY = "osivia.document.hideAttachments";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/document/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/document/view.jsp";
    private CMSService cmsService;
    private INuxeoService nuxeoService;
    private final DocumentDAO documentDao = DocumentDAO.getInstance();
    private final CommentDAO commentDao = CommentDAO.getInstance();
    private final RemotePublishedDocumentDAO publishedDocumentsDao = RemotePublishedDocumentDAO.getInstance();

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        try {
            this.nuxeoService = (INuxeoService)portletContext.getAttribute("NuxeoService");
            if (this.nuxeoService == null) {
                throw new PortletException("Cannot start ViewDocumentPortlet portlet due to service unavailability");
            }
            this.cmsService = new CMSService(portletContext);
            ICMSServiceLocator cmsLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            cmsLocator.register((ICMSService)this.cmsService);
            CMSCustomizer customizer = new CMSCustomizer(portletContext, this.cmsService);
            this.cmsService.setCustomizer((DefaultCMSCustomizer)customizer);
            this.nuxeoService.registerCMSCustomizer((INuxeoCustomizer)customizer);
            NuxeoTagService tagService = new NuxeoTagService();
            this.registerService((Object)this.nuxeoService.getTagService(), (Object)tagService);
            FormsServiceImpl formsService = new FormsServiceImpl((DefaultCMSCustomizer)customizer);
            this.registerService((Object)this.nuxeoService.getFormsService(), (Object)formsService);
            IEcmCommandervice ecmCmdService = (IEcmCommandervice)Locator.findMBean(IEcmCommandervice.class, (String)"osivia:service=EcmCommandService");
            for (EcmCommand command : customizer.getEcmCommands().values()) {
                ecmCmdService.registerCommand(command.getCommandName(), command);
            }
            ThumbnailServlet.setPortletContext((PortletContext)portletContext);
            SitePictureServlet.setPortletContext((PortletContext)portletContext);
            AvatarServlet.setPortletContext((PortletContext)portletContext);
            BinaryServlet.setPortletContext((PortletContext)portletContext);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void registerService(Object proxy, Object instance) {
        NuxeoServiceInvocationHandler invocationHandler = (NuxeoServiceInvocationHandler)Proxy.getInvocationHandler(proxy);
        invocationHandler.setInstance(instance);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                String path = request.getParameter("path");
                window.setProperty(PATH_WINDOW_PROPERTY, path);
                String onlyDescription = request.getParameter("onlyDescription");
                window.setProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY, onlyDescription);
                boolean displayMetadata = BooleanUtils.toBoolean((String)request.getParameter("metadata"));
                window.setProperty(HIDE_METADATA_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayMetadata, null, (String)"1"));
                boolean displayAttachments = BooleanUtils.toBoolean((String)request.getParameter("attachments"));
                window.setProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayAttachments, null, (String)"1"));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            this.processCommentAction(request, response);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
        boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
        request.setAttribute("onlyDescription", (Object)onlyDescription);
        boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(HIDE_METADATA_WINDOW_PROPERTY), null, (String)"1");
        request.setAttribute("metadata", (Object)metadata);
        boolean attachments = BooleanUtils.toBoolean((String)window.getProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY), null, (String)"1");
        request.setAttribute("attachments", (Object)attachments);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String theme = window.getPageProperty("theme.id");
            request.setAttribute("theme", (Object)theme);
            String path = window.getProperty(PATH_WINDOW_PROPERTY);
            path = nuxeoController.getComputedPath(path);
            if (StringUtils.isNotBlank((String)path)) {
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                boolean maximized = WindowState.MAXIMIZED.equals((Object)request.getWindowState());
                boolean onlyRemoteSections = BooleanUtils.toBoolean((String)window.getProperty(ONLY_REMOTE_SECTIONS_WINDOW_PROPERTY));
                request.setAttribute("onlyRemoteSections", (Object)onlyRemoteSections);
                boolean remoteSectionsPage = BooleanUtils.toBoolean((String)window.getProperty(REMOTE_SECTIONS_PAGE_WINDOW_PROPERTY));
                request.setAttribute("remoteSectionsPage", (Object)remoteSectionsPage);
                boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
                if (!maximized) {
                    request.setAttribute("onlyDescription", (Object)onlyDescription);
                }
                boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(HIDE_METADATA_WINDOW_PROPERTY), null, (String)"1");
                request.setAttribute("metadata", (Object)metadata);
                boolean attachments = BooleanUtils.toBoolean((String)window.getProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY), null, (String)"1");
                request.setAttribute("attachments", (Object)attachments);
                Document document = documentContext.getDocument();
                nuxeoController.setCurrentDoc(document);
                String dispatchJsp = window.getProperty("osivia.document.dispatch.jsp");
                if (StringUtils.isEmpty((String)dispatchJsp)) {
                    dispatchJsp = this.getDispatchJspName(nuxeoController, document, null);
                }
                request.setAttribute("dispatchJsp", (Object)dispatchJsp);
                String dispatchExtraJsp = this.getDispatchJspName(nuxeoController, document, "extra");
                request.setAttribute("dispatchExtraJsp", (Object)dispatchExtraJsp);
                String dispatchLayoutJsp = this.getDispatchJspName(nuxeoController, document, "layout");
                request.setAttribute("dispatchLayoutJsp", (Object)dispatchLayoutJsp);
                DocumentDTO documentDto = this.documentDao.toDTO(document);
                request.setAttribute("document", (Object)documentDto);
                String title = document.getTitle();
                if (StringUtils.isNotBlank((String)title)) {
                    response.setTitle(title);
                }
                if (onlyRemoteSections && maximized) {
                    this.generatePublishedDocumentsInfos(nuxeoController, documentContext, documentDto, Boolean.valueOf(true));
                } else if (!onlyDescription || maximized) {
                    nuxeoController.insertContentMenuBarItems();
                    this.generateAttachments(nuxeoController, document, documentDto);
                    this.generatePublishedDocumentsInfos(nuxeoController, documentContext, documentDto, Boolean.valueOf(false));
                    if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                        boolean commentsEnabled;
                        CMSPublicationInfos publicationInfos = this.cmsService.getPublicationInfos(cmsContext, path);
                        if (publicationInfos.isLiveSpace()) {
                            ExtendedDocumentInfos extendedDocumentInfos = ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) ? this.cmsService.getExtendedDocumentInfos(cmsContext, document.getPath()) : null;
                            this.addValidationState(document, documentDto, extendedDocumentInfos);
                        }
                        if ((commentsEnabled = this.areCommentsEnabled((ICMSService)this.cmsService, publicationInfos, cmsContext)) && publicationInfos.isCommentableByUser()) {
                            documentDto.setCommentable(true);
                            this.generateComments(nuxeoController, document, documentDto);
                        }
                        this.handleDriveEdition(nuxeoController.getPortalCtx(), document, documentDto, publicationInfos);
                    }
                }
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private String getDispatchJspName(NuxeoController nuxeoController, Document document, String suffix) throws CMSException {
        INuxeoCustomizer customizer = nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        PortletRequest request = nuxeoController.getRequest();
        String type = StringUtils.lowerCase((String)document.getType());
        StringBuilder path = new StringBuilder();
        path.append("/WEB-INF/jsp/document/view-");
        path.append(type);
        if (StringUtils.isNotEmpty((String)suffix)) {
            path.append("-");
            path.append(suffix);
        }
        path.append(".jsp");
        String name = customizer.getJSPName(path.toString(), this.getPortletContext(), request);
        String realPath = this.getPortletContext().getRealPath(name);
        File file = new File(realPath);
        String dispatchJspName = file.exists() ? type : "default";
        return dispatchJspName;
    }

    private void generateAttachments(NuxeoController nuxeoController, Document document, DocumentDTO documentDto) {
        String path = document.getPath();
        List attachments = documentDto.getAttachments();
        PropertyList list = document.getProperties().getList("files:files");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                PropertyMap map = list.getMap(i);
                DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                PropertyMap file = map.getMap("file");
                String name = file.getString("name");
                if (StringUtils.isEmpty((String)name)) {
                    name = map.getString("filename");
                }
                attachment.setName(name);
                String mimeType = file.getString("mime-type");
                String icon = this.documentDao.getIcon(mimeType);
                attachment.setIcon(icon);
                Long size = file.getLong("length");
                attachment.setSize(size);
                String url = nuxeoController.createAttachedFileLink(path, String.valueOf(i));
                attachment.setUrl(url);
                attachments.add(attachment);
            }
        }
    }

    private void addValidationState(Document document, DocumentDTO documentDTO, ExtendedDocumentInfos extendedDocumentInfos) {
        String color;
        String icon;
        String key;
        if (extendedDocumentInfos != null && extendedDocumentInfos.isValidationWorkflowRunning()) {
            key = "DOCUMENT_STATE_VALIDATION_IN_PROGRESS";
            icon = "glyphicons glyphicons-hourglass";
            color = "info";
        } else if ("approved".equals(document.getState())) {
            key = "DOCUMENT_STATE_VALID";
            icon = "glyphicons glyphicons-ok";
            color = "success";
        } else {
            key = null;
            icon = null;
            color = null;
        }
        if (key != null) {
            HashMap<String, String> validationState = new HashMap<String, String>();
            validationState.put("key", key);
            validationState.put("icon", icon);
            validationState.put("color", color);
            documentDTO.getProperties().put("validationState", validationState);
        }
    }

    private void generateComments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        GetCommentsCommand getCommentsCommand = new GetCommentsCommand(document);
        JSONArray jsonComments = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getCommentsCommand);
        for (int i = 0; i < jsonComments.size(); ++i) {
            JSONObject jsonComment = jsonComments.getJSONObject(i);
            CommentDTO commentDTO = this.commentDao.toDTO(jsonComment);
            documentDTO.getComments().add(commentDTO);
        }
    }

    protected boolean areCommentsEnabled(ICMSService cmsService, CMSPublicationInfos publicationInfos, CMSServiceCtx cmsContext) throws CMSException {
        boolean enable = true;
        String publishSpacePath = publicationInfos.getPublishSpacePath();
        if (StringUtils.isBlank((String)publishSpacePath)) {
            publishSpacePath = publicationInfos.getDocumentPath();
        }
        if (StringUtils.isNotBlank((String)publishSpacePath)) {
            boolean isPublishSpace;
            CMSItem spaceConfig = cmsService.getSpaceConfig(cmsContext, publishSpacePath);
            Document space = (Document)spaceConfig.getNativeItem();
            boolean bl = isPublishSpace = space.getFacets() != null && space.getFacets().list().contains("TTCPublishSpace");
            if (isPublishSpace) {
                enable = BooleanUtils.toBoolean((String)((String)spaceConfig.getProperties().get("spaceCommentable")));
            }
        }
        return enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generatePublishedDocumentsInfos(NuxeoController nuxeoController, NuxeoDocumentContext docCtx, DocumentDTO documentDTO, Boolean readFilter) {
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_61) && docCtx.getPublicationInfos().isLiveSpace()) {
            int cacheType = nuxeoController.getCacheType();
            int authType = nuxeoController.getAuthType();
            try {
                nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
                GetPublishedDocumentsInfosCommand getPublishedCommand = new GetPublishedDocumentsInfosCommand(docCtx.getDocument(), readFilter);
                JSONArray jsonPublishedDocumentsInfos = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getPublishedCommand);
                for (int index = 0; index < jsonPublishedDocumentsInfos.size(); ++index) {
                    JSONObject publishedDocumentInfos = jsonPublishedDocumentsInfos.getJSONObject(index);
                    RemotePublishedDocumentDTO publishedDocumentDTO = this.publishedDocumentsDao.toDTO(publishedDocumentInfos);
                    documentDTO.getPublishedDocuments().add(publishedDocumentDTO);
                }
            }
            finally {
                nuxeoController.setCacheType(cacheType);
                nuxeoController.setAuthType(authType);
            }
        }
    }

    private void handleDriveEdition(PortalControllerContext portalControllerContext, Document document, DocumentDTO documentDto, CMSPublicationInfos publicationInfos) {
        DocumentType documentType;
        PortletRequest request = portalControllerContext.getRequest();
        if (publicationInfos.isEditableByUser() && (documentType = documentDto.getType()) != null && documentType.isFile()) {
            String driveEditUrl = publicationInfos.getDriveEditURL();
            if (StringUtils.contains((String)driveEditUrl, (String)HOST_JOKER)) {
                String vhost = portalControllerContext.getHttpServletRequest().getHeader("osivia-virtual-host");
                vhost = StringUtils.isBlank((String)vhost) ? request.getScheme() + "/" + request.getServerName() : vhost.replace("://", "/");
                StringBuilder builder = new StringBuilder();
                builder.append(vhost);
                builder.append("/nuxeo");
                driveEditUrl = StringUtils.replace((String)driveEditUrl, (String)HOST_JOKER, (String)builder.toString());
            }
            boolean driveEnabled = BooleanUtils.isTrue((Boolean)publicationInfos.isDriveEnabled());
            if (driveEditUrl != null || driveEnabled) {
                request.setAttribute("driveEditUrl", (Object)driveEditUrl);
                request.setAttribute("driveEnabled", (Object)driveEnabled);
            }
        }
    }
}

