/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.cms.LockStatus;
import fr.toutatice.portail.cms.nuxeo.api.cms.SubscriptionStatus;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import java.io.InputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.FileBlob;

public class ExtendedDocumentInfosCommand
implements INuxeoCommand {
    private String path;

    public ExtendedDocumentInfosCommand(String path) {
        this.path = path;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        ExtendedDocumentInfos docInfos = new ExtendedDocumentInfos();
        OperationRequest request = nuxeoSession.newRequest("Document.FetchExtendedDocInfos");
        if (this.path.startsWith("webId:")) {
            request.set("webid", (Object)this.path.replaceAll("webId:", ""));
        } else {
            request.set("path", (Object)this.path);
        }
        Blob infosAsBlob = (Blob)request.execute();
        if (infosAsBlob != null) {
            String infosContentStr = IOUtils.toString((InputStream)infosAsBlob.getStream(), (String)"UTF-8");
            JSONArray infosContent = JSONArray.fromObject((Object)infosContentStr);
            for (JSONObject infos : infosContent) {
                String status;
                String taskName;
                if (infos.containsKey((Object)"taskName") && StringUtils.isNotBlank((String)(taskName = infos.getString("taskName")))) {
                    docInfos.setTaskName(taskName);
                    docInfos.setOnlineTaskPending(infos.getBoolean("isTaskPending"));
                    docInfos.setCanUserValidateOnlineTask(infos.getBoolean("canManageTask"));
                    docInfos.setUserOnlineTaskInitiator(infos.getBoolean("isTaskInitiator"));
                }
                if (infos.containsKey((Object)"isValidationWfRunning")) {
                    docInfos.setValidationWorkflowRunning(infos.getBoolean("isValidationWfRunning"));
                }
                if (infos.containsKey((Object)"subscription_status")) {
                    status = StringUtils.upperCase((String)infos.get("subscription_status").toString());
                    docInfos.setSubscriptionStatus(SubscriptionStatus.valueOf((String)status));
                }
                if (infos.containsKey((Object)"lockStatus")) {
                    status = StringUtils.upperCase((String)infos.get("lockStatus").toString());
                    docInfos.setLockStatus(LockStatus.valueOf((String)status));
                    if (infos.containsKey((Object)"lockOwner")) {
                        docInfos.setLockOwner(infos.get("lockOwner").toString());
                    }
                }
                if (infos.containsKey((Object)"canSynchronize")) {
                    docInfos.setCanSynchronize(BooleanUtils.toBoolean((String)infos.get("canSynchronize").toString()));
                }
                if (infos.containsKey((Object)"canUnsynchronize")) {
                    docInfos.setCanUnsynchronize(BooleanUtils.toBoolean((String)infos.get("canUnsynchronize").toString()));
                }
                if (infos.containsKey((Object)"synchronizationRootPath")) {
                    docInfos.setSynchronizationRootPath(infos.get("synchronizationRootPath").toString());
                }
                if (infos.containsKey((Object)"draftCount")) {
                    docInfos.setDraftCount(infos.getInt("draftCount"));
                }
                if (infos.containsKey((Object)"isPdfConvertible")) {
                    docInfos.setPdfConvertible(infos.getBoolean("isPdfConvertible"));
                }
                if (infos.containsKey((Object)"errorOnPdfConversion")) {
                    docInfos.setErrorOnPdfConversion(infos.getBoolean("errorOnPdfConversion"));
                }
                if (!infos.containsKey((Object)"parentWebId")) continue;
                docInfos.setParentWebId(infos.getString("parentWebId"));
            }
        }
        if (infosAsBlob instanceof FileBlob) {
            ((FileBlob)infosAsBlob).getFile().delete();
        }
        return docInfos;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        builder.append(this.path);
        return builder.toString();
    }
}

