/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.binaries;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class FetchByShareLinkCommand
implements INuxeoCommand {
    private final String linkId;
    private boolean enabledLinkOnly;

    public FetchByShareLinkCommand(String linkId, boolean enabledLinkOnly) {
        this.linkId = linkId;
        this.enabledLinkOnly = enabledLinkOnly;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("rshr:linkId = '");
        clause.append(this.linkId);
        clause.append("' ");
        if (this.enabledLinkOnly) {
            clause.append(" AND rshr:enabledLink = 1");
        }
        clause.append(" ORDER BY ecm:pos ASC");
        NuxeoQueryFilterContext filterContext = new NuxeoQueryFilterContext(2);
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)filterContext, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"*");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        builder.append(this.linkId);
        return builder.toString();
    }
}

