/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.Customizable;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.portal.api.set.SetType;
import org.osivia.portal.api.statistics.StatisticsModule;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.tasks.TaskModule;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.api.theming.TemplateAdapter;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.DomainContextualization;
import org.osivia.portal.core.customization.ICMSCustomizationObserver;
import org.osivia.portal.core.customization.ICustomizationService;

public class CustomizationPluginMgr
implements ICMSCustomizationObserver {
    private static final String CUSTOM_JSP_EXTENSION = "-custom-";
    private static final String WEB_INF_JSP = "/WEB-INF/jsp";
    private static final Hashtable<String, ReentrantLock> customizeJSPLockTable = new Hashtable();
    private final DefaultCMSCustomizer customizer;
    private final ICustomizationService customizationService;
    private final Map<Locale, Map<String, Object>> customizationAttributesCache;
    private final Map<String, CustomizedJsp> customizedJavaServerPagesCache;
    private final Map<Locale, Map<String, FragmentType>> fragmentsCache;
    private final Map<Locale, Map<String, EditableWindow>> ewCache;
    private final Map<Locale, List<ListTemplate>> templatesCache;
    private final Map<Locale, SortedMap<String, String>> menuTemplatesCache;
    private final Map<String, List<IPortletModule>> documentModulesCache;
    private List<IPlayerModule> dynamicModules;
    private Map<String, DocumentType> typesCache;
    private List<INavigationAdapterModule> navigationAdaptersCache;
    private List<DomainContextualization> domainContextualizationCache;
    private Map<String, TabGroup> tabGroupsCache;
    private TaskbarItems taskbarItemsCache;
    private List<MenubarModule> menubarModulesCache;
    private List<TemplateAdapter> templateAdaptersCache;
    private Map<String, FormFilter> formFiltersCache;
    private Map<String, SetType> setTypesCache;
    private List<TaskModule> taskModulesCache;
    private List<StatisticsModule> statisticsModulesCache;
    private long customizationDeployementTS;

    public CustomizationPluginMgr(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
        this.customizationService = (ICustomizationService)Locator.findMBean(ICustomizationService.class, (String)"osivia:service=CustomizationService");
        this.customizationService.setCMSObserver((ICMSCustomizationObserver)this);
        this.customizationAttributesCache = new ConcurrentHashMap<Locale, Map<String, Object>>();
        this.customizedJavaServerPagesCache = new ConcurrentHashMap<String, CustomizedJsp>();
        this.fragmentsCache = new ConcurrentHashMap<Locale, Map<String, FragmentType>>();
        this.ewCache = new ConcurrentHashMap<Locale, Map<String, EditableWindow>>();
        this.templatesCache = new ConcurrentHashMap<Locale, List<ListTemplate>>();
        this.menuTemplatesCache = new ConcurrentHashMap<Locale, SortedMap<String, String>>();
        this.documentModulesCache = new ConcurrentHashMap<String, List<IPortletModule>>();
        this.customizationDeployementTS = System.currentTimeMillis();
    }

    private Map<String, Object> getCustomizationAttributes(Locale locale) {
        Map<String, Object> attributes = this.customizationAttributesCache.get(locale);
        if (attributes == null) {
            ConcurrentHashMap<String, Map<String, DocumentType>> customizationAttributes = new ConcurrentHashMap<String, Map<String, DocumentType>>();
            CustomizationContext customizationContext = new CustomizationContext(customizationAttributes, locale);
            List<DocumentType> defaultTypes = this.customizer.getDefaultCMSItemTypes();
            Map<String, DocumentType> types = Collections.synchronizedMap(new LinkedHashMap(defaultTypes.size()));
            for (DocumentType defaultType : defaultTypes) {
                types.put(defaultType.getName(), defaultType.clone());
            }
            List<DocumentType> customizedTypes = this.customizer.getCustomizedCMSItemTypes();
            for (DocumentType customizedType : customizedTypes) {
                types.put(customizedType.getName(), customizedType.clone());
            }
            customizationAttributes.put(Customizable.DOC_TYPE.toString(), types);
            this.customizationService.customize("osivia.customizer.cms.id", customizationContext);
            this.customizationAttributesCache.put(locale, customizationAttributes);
        }
        return this.customizationAttributesCache.get(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomizedJsp customizeJSP(String name, PortletContext portletContext, PortletRequest request) throws IOException {
        CustomizedJsp customizedPage = this.customizedJavaServerPagesCache.get(name);
        if (customizedPage == null && name != null) {
            ReentrantLock customizeJSPLock = customizeJSPLockTable.get(name);
            if (customizeJSPLock == null) {
                customizeJSPLock = new ReentrantLock();
                customizeJSPLockTable.put(name, customizeJSPLock);
            }
            customizeJSPLock.lock();
            try {
                customizedPage = this.customizedJavaServerPagesCache.get(name);
                if (customizedPage == null) {
                    String relativePath;
                    CustomizedJsp page;
                    Locale locale = request.getLocale();
                    Map<String, Object> customizationAttributes = this.getCustomizationAttributes(locale);
                    customizedPage = new CustomizedJsp(name, null);
                    Map customizedPages = (Map)customizationAttributes.get(Customizable.JSP.toString());
                    if (name != null && customizedPages != null && (page = (CustomizedJsp)customizedPages.get(relativePath = StringUtils.removeStart((String)name, (String)WEB_INF_JSP))) != null && name.contains(".")) {
                        StringBuilder destination = new StringBuilder();
                        destination.append(StringUtils.substringBeforeLast((String)name, (String)"."));
                        destination.append(CUSTOM_JSP_EXTENSION);
                        destination.append(this.customizationDeployementTS);
                        destination.append(".");
                        destination.append(StringUtils.substringAfterLast((String)name, (String)"."));
                        String directoryPath = portletContext.getRealPath("/");
                        File directory = new File(directoryPath);
                        File destinationFile = new File(directory, destination.toString());
                        destinationFile.delete();
                        File sourceFile = new File(page.getName());
                        FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                        customizedPage = new CustomizedJsp(destination.toString(), page.getClassLoader());
                    }
                    this.customizedJavaServerPagesCache.put(name, customizedPage);
                }
            }
            finally {
                customizeJSPLock.unlock();
            }
        }
        return customizedPage;
    }

    public List<ListTemplate> customizeListTemplates(Locale locale) {
        List<ListTemplate> templates = this.templatesCache.get(locale);
        if (templates == null) {
            templates = this.customizer.initListTemplates(locale);
            Map<String, Object> customizationAttributes = this.getCustomizationAttributes(locale);
            Map templatesMap = (Map)customizationAttributes.get(Customizable.LIST_TEMPLATE.toString() + locale);
            if (templatesMap != null) {
                Set customTemplates = templatesMap.entrySet();
                for (Map.Entry customTemplate : customTemplates) {
                    templates.add((ListTemplate)customTemplate.getValue());
                }
            }
            this.templatesCache.put(locale, templates);
        }
        return templates;
    }

    public Map<String, FragmentType> getFragments(Locale locale) {
        Map<String, FragmentType> fragments = this.fragmentsCache.get(locale);
        if (fragments == null) {
            List<FragmentType> initList = this.customizer.initListFragments(locale);
            fragments = new Hashtable<String, FragmentType>();
            for (FragmentType fragment : initList) {
                fragments.put(fragment.getKey(), fragment);
            }
            Map<String, Object> customizationAttributes = this.getCustomizationAttributes(locale);
            List fragmentsList = (List)customizationAttributes.get(Customizable.FRAGMENT.toString() + locale);
            if (fragmentsList != null) {
                for (FragmentType customFragment : fragmentsList) {
                    fragments.put(customFragment.getKey(), customFragment);
                }
            }
            this.fragmentsCache.put(locale, fragments);
        }
        return fragments;
    }

    public Map<String, EditableWindow> customizeEditableWindows(Locale locale) {
        Map<String, EditableWindow> ew = this.ewCache.get(locale);
        if (ew == null) {
            Map<String, EditableWindow> initList = this.customizer.initEditableWindows(locale);
            ew = new Hashtable<String, EditableWindow>();
            for (Map.Entry<String, EditableWindow> customEw : initList.entrySet()) {
                ew.put(customEw.getKey(), customEw.getValue());
            }
            Map<String, Object> customizationAttributes = this.getCustomizationAttributes(locale);
            Map ewList = (Map)customizationAttributes.get(Customizable.EDITABLE_WINDOW.toString() + locale);
            if (ewList != null) {
                for (Map.Entry customEw : ewList.entrySet()) {
                    ew.put((String)customEw.getKey(), (EditableWindow)customEw.getValue());
                }
            }
            this.ewCache.put(locale, ew);
        }
        return ew;
    }

    public Map<String, DocumentType> customizeCMSItemTypes() {
        if (this.typesCache == null) {
            Map<String, Object> customizationAttributes = this.getCustomizationAttributes(Locale.getDefault());
            this.typesCache = (Map)customizationAttributes.get(Customizable.DOC_TYPE.toString());
        }
        return this.typesCache;
    }

    public List<MenubarModule> customizeMenubarModules() {
        if (this.menubarModulesCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.menubarModulesCache = (List)attributes.get(Customizable.MENUBAR.toString());
            if (this.menubarModulesCache == null) {
                this.menubarModulesCache = new ArrayList<MenubarModule>(0);
            }
        }
        return this.menubarModulesCache;
    }

    public List<IPlayerModule> customizeModules() {
        if (this.dynamicModules == null) {
            Map<String, Object> customizationAttributes = this.getCustomizationAttributes(Locale.getDefault());
            List players = (List)customizationAttributes.get(Customizable.PLAYER.toString());
            this.dynamicModules = new ArrayList<IPlayerModule>();
            if (players != null) {
                this.dynamicModules.addAll(players);
            }
        }
        return this.dynamicModules;
    }

    public SortedMap<String, String> customizeMenuTemplates(Locale locale) {
        SortedMap<String, String> templates = this.menuTemplatesCache.get(locale);
        if (templates == null) {
            templates = this.customizer.initMenuTemplates(locale);
            Map<String, Object> customizationAttributes = this.getCustomizationAttributes(locale);
            SortedMap customizedTemplates = (SortedMap)customizationAttributes.get(Customizable.MENU_TEMPLATE.toString() + locale);
            if (customizedTemplates != null) {
                Set entrySet = customizedTemplates.entrySet();
                Iterator iterator = entrySet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry customizedTemplate = entry = iterator.next();
                    String key = (String)customizedTemplate.getKey();
                    String label = (String)customizedTemplate.getValue();
                    templates.put(key, label);
                }
            }
            this.menuTemplatesCache.put(locale, templates);
        }
        return templates;
    }

    public List<INavigationAdapterModule> customizeNavigationAdapters() {
        if (this.navigationAdaptersCache == null) {
            this.navigationAdaptersCache = new ArrayList<INavigationAdapterModule>();
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            List customizedModules = (List)attributes.get(Customizable.NAVIGATION_ADAPTERS.toString());
            if (customizedModules != null) {
                CollectionUtils.addAll(this.navigationAdaptersCache, customizedModules.iterator());
            }
        }
        return this.navigationAdaptersCache;
    }

    public List<DomainContextualization> customizeDomainContextualization() {
        if (this.domainContextualizationCache == null) {
            this.domainContextualizationCache = new ArrayList<DomainContextualization>();
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            List customizedModules = (List)attributes.get(Customizable.DOMAIN_CONTEXTUALIZATION.toString());
            if (customizedModules != null) {
                CollectionUtils.addAll(this.domainContextualizationCache, customizedModules.iterator());
            }
        }
        return this.domainContextualizationCache;
    }

    public Map<String, TabGroup> customizeTabGroups() {
        if (this.tabGroupsCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            Map tabGroups = (Map)attributes.get(Customizable.TAB_GROUPS.toString());
            this.tabGroupsCache = tabGroups == null ? new ConcurrentHashMap<String, TabGroup>() : tabGroups;
        }
        return this.tabGroupsCache;
    }

    public TaskbarItems customizeTaskbarItems() throws CMSException {
        if (this.taskbarItemsCache == null) {
            TaskbarItems defaultTaskbarItems = this.customizer.getDefaultTaskbarItems();
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            TaskbarItems customizedTaskbarItems = (TaskbarItems)attributes.get(Customizable.TASKBAR_ITEMS.toString());
            if (defaultTaskbarItems != null) {
                this.taskbarItemsCache = defaultTaskbarItems;
                if (customizedTaskbarItems != null) {
                    this.taskbarItemsCache.add(customizedTaskbarItems.getAll());
                }
            } else if (customizedTaskbarItems != null) {
                this.taskbarItemsCache = customizedTaskbarItems;
            }
        }
        return this.taskbarItemsCache;
    }

    public List<TemplateAdapter> customizeTemplateAdapters() {
        if (this.templateAdaptersCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.templateAdaptersCache = (List)attributes.get(Customizable.TEMPLATE_ADAPTERS.toString());
            if (this.templateAdaptersCache == null) {
                this.templateAdaptersCache = new ArrayList<TemplateAdapter>(0);
            }
        }
        return this.templateAdaptersCache;
    }

    public Map<String, FormFilter> getFormFilters() {
        if (this.formFiltersCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.formFiltersCache = (Map)attributes.get(Customizable.FORM_FILTERS.toString());
            if (this.formFiltersCache == null) {
                this.formFiltersCache = new ConcurrentHashMap<String, FormFilter>(0);
            }
        }
        return this.formFiltersCache;
    }

    public Map<String, SetType> getSetTypes() {
        if (this.setTypesCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.setTypesCache = (Map)attributes.get(Customizable.SET_TYPES.toString());
            if (this.setTypesCache == null) {
                this.setTypesCache = new ConcurrentHashMap<String, SetType>(0);
            }
        }
        return this.setTypesCache;
    }

    public List<TaskModule> getTaskModules() {
        if (this.taskModulesCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.taskModulesCache = (List)attributes.get(Customizable.TASK_MODULES.toString());
            if (this.taskModulesCache == null) {
                this.taskModulesCache = new ArrayList<TaskModule>(0);
            }
        }
        return this.taskModulesCache;
    }

    public List<IPortletModule> getDocumentModules(String type) {
        ArrayList modules = this.documentModulesCache.get(type);
        if (modules == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            Map value = (Map)attributes.get(Customizable.DOCUMENT_MODULES.toString());
            if (MapUtils.isNotEmpty((Map)value)) {
                modules = (ArrayList)value.get(type);
            }
            if (modules == null) {
                modules = new ArrayList();
            }
            this.documentModulesCache.put(type, modules);
        }
        return modules;
    }

    public List<StatisticsModule> getStatisticsModules() {
        if (this.statisticsModulesCache == null) {
            Map<String, Object> attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.statisticsModulesCache = (List)attributes.get(Customizable.STATISTICS_MODULES.toString());
            if (this.statisticsModulesCache == null) {
                this.statisticsModulesCache = new ArrayList<StatisticsModule>();
            }
        }
        return this.statisticsModulesCache;
    }

    public List<String> getRegisteredPluginNames() {
        return this.customizationService.getRegisteredPluginNames();
    }

    public boolean isPluginRegistered(String pluginName) {
        return this.customizationService.isPluginRegistered(pluginName);
    }

    public void notifyDeployment() {
        this.customizationDeployementTS = System.currentTimeMillis();
        this.dynamicModules = null;
        this.typesCache = null;
        this.navigationAdaptersCache = null;
        this.domainContextualizationCache = null;
        this.tabGroupsCache = null;
        this.taskbarItemsCache = null;
        this.menubarModulesCache = null;
        this.templateAdaptersCache = null;
        this.formFiltersCache = null;
        this.setTypesCache = null;
        this.taskModulesCache = null;
        this.statisticsModulesCache = null;
        this.customizationAttributesCache.clear();
        this.customizedJavaServerPagesCache.clear();
        this.fragmentsCache.clear();
        this.ewCache.clear();
        this.templatesCache.clear();
        this.menuTemplatesCache.clear();
        this.documentModulesCache.clear();
    }
}

