/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.avatar.AvatarModule;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.CommentsFormatter;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.NuxeoCommentsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.AvatarInfo;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.AvatarUtils;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.BinaryTimestamp;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.DefaultPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesLoader;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WysiwygParser;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.XSLFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.ContextDocumentsHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.ProcedureTemplateModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.AttachmentsFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.DocumentPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.LinkFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.NavigationPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.PropertyFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SitePictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SpaceMenubarFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.service.commands.AddToQuickAccessCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.DeleteDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.EraseModificationsCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.LockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.RemoveFromQuickAccessCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnlockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.FragmentEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.HTMLEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.ListEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.PictureEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.PortletEditableWindow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpSessionEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerInvocationContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.FileMimeType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.EcmCommonCommands;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.portal.api.player.Player;
import org.osivia.portal.api.set.SetType;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.customization.ICustomizationService;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.web.IWebIdService;
import org.osivia.portal.core.web.IWebUrlService;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DefaultCMSCustomizer
implements INuxeoCustomizer {
    public static final String DEFAULT_SCHEMAS = "dublincore, common, toutatice, file";
    public static final String PROCEDURE_SCHEMAS = "dublincore, common, toutatice, files, procedureInstance, record";
    public static final String TEMPLATE_DOWNLOAD = "download";
    private static final String AVATAR_SERVLET = "/" + NuxeoController.getCMSNuxeoWebContextName() + "/avatar?username=";
    private static final String BINARY_SERVLET = "/" + NuxeoController.getCMSNuxeoWebContextName() + "/binary";
    private static final String TABS_PROPERTY = "osivia.navigationInSpaceTabs";
    private static final Pattern QUERY_FILTER_PATTERN = Pattern.compile("(.*)ORDER([ ]*)BY(.*)");
    private final Log log = LogFactory.getLog(this.getClass());
    private final PortletContext portletContext;
    private final CMSService cmsService;
    private final Map<String, Map<String, BinaryDelegation>> delegations;
    private final Map<String, INuxeoPlayerModule> players;
    private final Map<String, PanelPlayer> navigationPanelPlayers;
    private final Map<String, BinaryTimestamp> binaryTimestamps;
    private final CustomizationPluginMgr pluginManager;
    private final NuxeoConnectionProperties nuxeoConnection;
    private final UserPagesLoader userPagesLoader;
    private final MenuBarFormater menubarFormater;
    private final BrowserAdapter browserAdapter;
    @Deprecated
    private final NavigationItemAdapter navigationItemAdapter;
    private final ClassLoader classLoader;
    private final XMLReader parser;
    private final IPortalUrlFactory portalUrlFactory;
    private final IWebIdService webIdService;
    private final IWebUrlService webUrlService;
    private final ITaskbarService taskbarService;
    private final ICustomizationService customizationService;
    private final INuxeoCommentsService nuxeoCommentsService;
    private final IInternationalizationService internationalizationService;
    private final IBundleFactory bundleFactory;
    private final INotificationsService notificationsService;
    private Map<String, FileMimeType> fileMimeTypes;

    public DefaultCMSCustomizer(PortletContext portletContext, CMSService cmsService) {
        this.portletContext = portletContext;
        this.cmsService = cmsService;
        this.delegations = new ConcurrentHashMap();
        this.players = new ConcurrentHashMap();
        this.players.put("defaultPlayer", new DefaultPlayer());
        this.navigationPanelPlayers = new ConcurrentHashMap();
        this.navigationPanelPlayers.put("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance", this.getFileBrowserPanelPlayer());
        this.binaryTimestamps = new ConcurrentHashMap();
        this.pluginManager = new CustomizationPluginMgr(this);
        this.nuxeoConnection = new NuxeoConnectionProperties();
        this.userPagesLoader = new UserPagesLoader();
        this.menubarFormater = new MenuBarFormater(this);
        this.browserAdapter = BrowserAdapter.getInstance((CMSService)cmsService);
        this.navigationItemAdapter = new NavigationItemAdapter(this);
        try {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            this.parser = WysiwygParser.getInstance().getParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        this.webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");
        this.webUrlService = (IWebUrlService)Locator.findMBean(IWebUrlService.class, (String)"osivia:service=webUrlService");
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        this.customizationService = (ICustomizationService)Locator.findMBean(ICustomizationService.class, (String)"osivia:service=CustomizationService");
        this.nuxeoCommentsService = new NuxeoCommentsServiceImpl(this.cmsService);
        this.internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = this.internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
        AvatarUtils.portletContext = portletContext;
    }

    public static String getSearchSchema() {
        return "dublincore,common,file,toutatice";
    }

    public final Map<String, EditableWindow> getEditableWindows(Locale locale) {
        return this.pluginManager.customizeEditableWindows(locale);
    }

    public Map<String, EditableWindow> initEditableWindows(Locale locale) {
        HashMap<String, EditableWindow> map = new HashMap<String, EditableWindow>();
        map.put("fgt.html", (EditableWindow)new HTMLEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "html_Frag_"));
        map.put("fgt.list", (EditableWindow)new ListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "liste_Frag_"));
        map.put("fgt.picture", (EditableWindow)new PictureEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "picture_Frag_"));
        map.put("fgt.portlet", (EditableWindow)new PortletEditableWindow("", "portlet_Frag_"));
        map.put("ew.fragment", (EditableWindow)new FragmentEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "ew_frag_"));
        return map;
    }

    public final List<ListTemplate> getListTemplates(Locale locale) {
        return this.pluginManager.customizeListTemplates(locale);
    }

    public List<ListTemplate> initListTemplates(Locale locale) {
        ArrayList<ListTemplate> templates = new ArrayList<ListTemplate>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.add(new ListTemplate("mini", bundle.getString("LIST_TEMPLATE_MINI"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("normal", bundle.getString("LIST_TEMPLATE_NORMAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("detailed", bundle.getString("LIST_TEMPLATE_DETAILED"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("editorial", bundle.getString("LIST_TEMPLATE_EDITORIAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("contextual-links", bundle.getString("LIST_TEMPLATE_CONTEXTUAL_LINKS"), DEFAULT_SCHEMAS));
        ListTemplate procedureTemplate = new ListTemplate("procedure", bundle.getString("LIST_TEMPLATE_PROCEDURE"), PROCEDURE_SCHEMAS);
        procedureTemplate.setModule((IPortletModule)new ProcedureTemplateModule(this.portletContext));
        templates.add(procedureTemplate);
        templates.add(new ListTemplate("search-results", bundle.getString("LIST_TEMPLATE_SEARCH_RESULTS"), DEFAULT_SCHEMAS));
        return templates;
    }

    public final Map<String, FragmentType> getFragmentTypes(Locale locale) {
        return this.pluginManager.getFragments(locale);
    }

    public Map<String, FormFilter> getFormsFilters() {
        return this.pluginManager.getFormFilters();
    }

    public List<FragmentType> initListFragments(Locale locale) {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        fragmentTypes.add(new FragmentType("text_property", bundle.getString("FRAGMENT_TYPE_TEXT"), (IFragmentModule)new PropertyFragmentModule(this.portletContext, false)));
        fragmentTypes.add(new FragmentType("html_property", bundle.getString("FRAGMENT_TYPE_HTML"), (IFragmentModule)new PropertyFragmentModule(this.portletContext, true)));
        fragmentTypes.add(new FragmentType("navigation_picture", bundle.getString("FRAGMENT_TYPE_NAVIGATION_PICTURE"), (IFragmentModule)new NavigationPictureFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("document_picture", bundle.getString("FRAGMENT_TYPE_DOCUMENT_PICTURE"), (IFragmentModule)new DocumentPictureFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("doc_link", bundle.getString("FRAGMENT_TYPE_LINK"), (IFragmentModule)new LinkFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("space_menubar", bundle.getString("FRAGMENT_TYPE_MENUBAR"), (IFragmentModule)new SpaceMenubarFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("site_picture", bundle.getString("FRAGMENT_TYPE_SITE_PICTURE"), (IFragmentModule)new SitePictureFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("attachments", bundle.getString("FRAGMENT_TYPE_ATTACHMENTS"), (IFragmentModule)new AttachmentsFragmentModule(this.portletContext)));
        return fragmentTypes;
    }

    public SortedMap<String, String> getMenuTemplates(Locale locale) {
        return this.pluginManager.customizeMenuTemplates(locale);
    }

    public SortedMap<String, String> initMenuTemplates(Locale locale) {
        SortedMap<String, String> templates = Collections.synchronizedSortedMap(new TreeMap());
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.put("", bundle.getString("MENU_TEMPLATE_DEFAULT"));
        templates.put("horizontal", bundle.getString("MENU_TEMPLATE_HORIZONTAL"));
        templates.put("footer", bundle.getString("MENU_TEMPLATE_FOOTER"));
        templates.put("fancytree-lazy", bundle.getString("MENU_TEMPLATE_FANCYTREE_LAZY"));
        templates.put("fancytree-filter", bundle.getString("MENU_TEMPLATE_FANCYTREE_FILTER"));
        return templates;
    }

    public Player getCMSDefaultPlayer(CMSServiceCtx cmsContext) throws PortletException {
        NuxeoDocumentContext documentContext;
        Document document = (Document)cmsContext.getDoc();
        try {
            documentContext = this.cmsService.getDocumentContext(cmsContext, document.getPath());
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        return this.getCMSDefaultPlayer(documentContext);
    }

    public Player getCMSDefaultPlayer(NuxeoDocumentContext docCtx) {
        INuxeoPlayerModule module = (INuxeoPlayerModule)this.players.get("defaultPlayer");
        return module.getCMSPlayer((DocumentContext)docCtx);
    }

    public Player getCMSOrderedFolderPlayer(NuxeoDocumentContext documentContext) throws CMSException {
        Document document = documentContext.getDocument();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest((NuxeoDocumentContext)documentContext, (boolean)true));
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", documentContext.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", documentContext.getDocumentState().toString());
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", "Dossier " + document.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player getCMSFileBrowser(NuxeoDocumentContext documentContext) {
        Document document = documentContext.getDocument();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.displayLiveVersion", documentContext.getDocumentState().toString());
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance");
        return linkProps;
    }

    public Player getCMSFolderPlayer(NuxeoDocumentContext documentContext) throws CMSException {
        Document document = documentContext.getDocument();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest((NuxeoDocumentContext)documentContext, (boolean)false));
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", documentContext.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", documentContext.getDocumentState().toString());
        windowProperties.put("osivia.title", document.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player getCMSSectionPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", "ecm:path STARTSWITH '" + doc.getPath() + "' AND ecm:mixinType != 'Folderish' ORDER BY dc:modified DESC");
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player createPortletLink(CMSServiceCtx ctx, String portletInstance, String uid) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", uid);
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance(portletInstance);
        return linkProps;
    }

    public Player getCMSPlayer(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsContext, document.getPath());
        boolean workspace = cmsContext.getContextualizationBasePath() != null && pubInfos.isLiveSpace();
        List modules = this.pluginManager.customizeModules();
        NuxeoDocumentContext docCtx = this.cmsService.getDocumentContext(cmsContext, document.getPath());
        for (IPlayerModule module : modules) {
            Player player = module.getCMSPlayer((DocumentContext)docCtx);
            if (player == null) continue;
            return player;
        }
        if ("UserWorkspace".equals(document.getType())) {
            cmsContext.setDisplayLiveVersion("1");
            return this.getCMSFileBrowser(docCtx);
        }
        if ("Folder".equals(document.getType()) || "OrderedFolder".equals(document.getType()) || "Section".equals(document.getType())) {
            if (workspace) {
                cmsContext.setDisplayLiveVersion("1");
                Player player = this.getCMSFileBrowser(docCtx);
                Map properties = player.getWindowProperties();
                properties.put("osivia.title", document.getTitle());
                properties.put("osivia.title.metadata", String.valueOf(true));
                properties.put("osivia.subtitle", document.getString("dc:description"));
                PropertyMap vignetteProperties = document.getProperties().getMap("ttc:vignette");
                if (vignetteProperties != null && StringUtils.isNotEmpty((String)vignetteProperties.getString("data"))) {
                    BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, document.getPath());
                    binary.setFieldName("ttc:vignette");
                    binary.setDocument((Object)document);
                    Link vignetteLink = this.cmsService.getBinaryResourceURL(cmsContext, binary);
                    properties.put("osivia.vignette.url", vignetteLink.getUrl());
                }
                return player;
            }
            if ("Folder".equals(document.getType())) {
                return this.getCMSFolderPlayer(docCtx);
            }
            return this.getCMSOrderedFolderPlayer(docCtx);
        }
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsContext);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.CMS_PLAYER);
            Documents configs = null;
            try {
                configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)cmsContext, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configs != null && configs.size() > 0) {
                for (Document config : configs) {
                    String documentType = config.getProperties().getString("wconf:code");
                    String playerInstance = config.getProperties().getString("wconf:code2");
                    if (!document.getType().equals(documentType) || !this.players.containsKey(playerInstance)) continue;
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    PropertyList list = config.getProperties().getList("wconf:options");
                    for (Object o : list.list()) {
                        if (!(o instanceof PropertyMap)) continue;
                        PropertyMap map = (PropertyMap)o;
                        windowProperties.put(map.get("propertyName").toString(), map.get("propertyDefaultValue").toString());
                    }
                    return ((INuxeoPlayerModule)this.players.get(playerInstance)).getCMSPlayer((DocumentContext)docCtx);
                }
            }
        }
        return ((INuxeoPlayerModule)this.players.get("defaultPlayer")).getCMSPlayer((DocumentContext)docCtx);
    }

    public String getDefaultExternalViewer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        String externalUrl = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents";
        return externalUrl;
    }

    public String createPortletDelegatedExternalLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId());
        resourceURL.setParameter("type", "link");
        return resourceURL.toString();
    }

    public String createPortletDelegatedFileContentLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId() + "/file:content");
        resourceURL.setParameter("type", "file");
        resourceURL.setParameter("docPath", doc.getPath());
        resourceURL.setParameter("fieldName", "file:content");
        resourceURL.setCacheability("cacheLevelPage");
        return resourceURL.toString();
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        if ("file-browser-menu-workspace".equals(ctx.getDisplayContext())) {
            return this.getDefaultExternalViewer(ctx);
        }
        return null;
    }

    public Link createCustomLink(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        String displayContext = cmsContext.getDisplayContext();
        String url = null;
        boolean externalLink = false;
        boolean downloadable = false;
        if (!"detailedView".equals(displayContext)) {
            if (("File".equals(document.getType()) || "Audio".equals(document.getType()) || "Video".equals(document.getType()) || "Picture".equals(document.getType())) && (TEMPLATE_DOWNLOAD.equals(displayContext) || "downloadVersion".equals(displayContext))) {
                url = this.createFileDownloadLink(cmsContext, document, displayContext);
                boolean bl = downloadable = url != null;
            }
            if ("ContextualLink".equals(document.getType()) && !"document".equals(displayContext) && !"fileExplorer".equals(displayContext)) {
                url = this.createPortletDelegatedExternalLink(cmsContext);
                externalLink = true;
            }
            if (url == null) {
                url = this.getNuxeoNativeViewerUrl(cmsContext);
                externalLink = true;
            }
        }
        if (url != null) {
            Link link = new Link(url, externalLink);
            link.setDownloadable(downloadable);
            return link;
        }
        return null;
    }

    public String createFileDownloadLink(CMSServiceCtx cmsContext, Document document, String displayContext) {
        String downloadUrl = null;
        PropertyMap attachedFileProperties = document.getProperties().getMap("file:content");
        if (attachedFileProperties != null && !attachedFileProperties.isEmpty()) {
            NuxeoController nuxeoCtl = new NuxeoController(cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse(), cmsContext.getPortletCtx());
            nuxeoCtl.setCurrentDoc(document);
            if (TEMPLATE_DOWNLOAD.equals(displayContext)) {
                downloadUrl = nuxeoCtl.createFileLink(document, "file:content");
            } else if ("downloadVersion".equals(displayContext)) {
                downloadUrl = nuxeoCtl.createFileLinkOfVersion(document, "file:content");
            }
        }
        return downloadUrl;
    }

    public void formatContentMenuBar(CMSServiceCtx ctx) throws Exception {
        CMSPublicationInfos publicationInfos = null;
        ExtendedDocumentInfos extendedDocumentInfos = null;
        if (ctx.getDoc() != null) {
            Document doc = (Document)ctx.getDoc();
            publicationInfos = this.cmsService.getPublicationInfos(ctx, doc.getPath());
            if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)ctx) || WindowState.MAXIMIZED.equals((Object)ctx.getRequest().getWindowState())) {
                extendedDocumentInfos = this.cmsService.getExtendedDocumentInfos(ctx, doc.getPath());
            }
        }
        this.menubarFormater.formatContentMenuBar(ctx, publicationInfos, extendedDocumentInfos);
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        return this.userPagesLoader.computeUserPreloadedPages(cmsCtx);
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        return null;
    }

    public String addPublicationFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy, boolean ignoreNavigationElements) throws Exception {
        String requestFilter = "";
        String hiddenInNavigation = "";
        if (ignoreNavigationElements) {
            hiddenInNavigation = "ecm:mixinType != 'HiddenInNavigation' AND ";
        }
        requestFilter = "1".equals(ctx.getDisplayLiveVersion()) ? hiddenInNavigation + "ecm:isProxy = 0  AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0 " : ("2".equals(ctx.getDisplayLiveVersion()) ? hiddenInNavigation + "ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0 AND ecm:mixinType <> 'isLocalPublishLive'" : "ecm:isProxy = 1 AND " + hiddenInNavigation + "ecm:currentLifeCycleState <> 'deleted' AND ecm:isCheckedInVersion = 0");
        return this.addExtraNxQueryFilters(ctx, nuxeoRequest, requestFilteringPolicy, requestFilter);
    }

    protected String addExtraNxQueryFilters(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy, String requestFilter) throws Exception {
        PortalObjectContainer portalObjectContainer;
        String policyFilter = null;
        ServerInvocation invocation = ctx.getServerInvocation();
        String portalName = null;
        if (invocation != null) {
            portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        }
        if (portalName != null && (portalObjectContainer = (PortalObjectContainer)invocation.getAttribute(Scope.REQUEST_SCOPE, (Object)"osivia.portalObjectContainer")) != null) {
            String extraFilter;
            PortalObject po = portalObjectContainer.getObject(PortalObjectId.parse((String)"", (String)("/" + portalName), (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT));
            if (requestFilteringPolicy != null) {
                policyFilter = requestFilteringPolicy;
            } else {
                String sitePolicy = po.getProperty("osivia.cms.requestFilteringPolicy");
                if (sitePolicy != null) {
                    if ("local".equals(sitePolicy)) {
                        policyFilter = "local";
                    }
                } else {
                    String portalType = po.getProperty("osivia.portal.portalType");
                    if ("space".equals(portalType)) {
                        policyFilter = "local";
                    }
                }
            }
            if ("local".equals(policyFilter)) {
                ArrayList<String> paths;
                List domains = (List)invocation.getAttribute(Scope.SESSION_SCOPE, (Object)"osivia.user.domains");
                if (CollectionUtils.isEmpty((Collection)domains)) {
                    if (po == null) {
                        paths = null;
                    } else {
                        Collection children = po.getChildren(4);
                        paths = new ArrayList(children.size());
                        Iterator iterator = children.iterator();
                        while (iterator.hasNext()) {
                            PortalObject child = (PortalObject)iterator.next();
                            String path = child.getDeclaredProperty("osivia.cms.basePath");
                            if (!StringUtils.isNotBlank((String)path)) continue;
                            paths.add(path);
                        }
                    }
                } else {
                    paths = new ArrayList<String>(domains.size());
                    for (Object domain : domains) {
                        if (!(domain instanceof String)) continue;
                        String path = (String)domain;
                        paths.add(path);
                    }
                }
                if (CollectionUtils.isNotEmpty(paths)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(" AND (");
                    boolean first = true;
                    for (String path : paths) {
                        if (first) {
                            first = false;
                        } else {
                            builder.append(" OR ");
                        }
                        builder.append("ecm:path STARTSWITH '").append(path).append("'");
                    }
                    builder.append(") ");
                    requestFilter = requestFilter + builder.toString();
                }
            }
            if ((extraFilter = this.getExtraRequestFilter(ctx, requestFilteringPolicy)) != null) {
                requestFilter = requestFilter + " OR (" + extraFilter + ")";
            }
        }
        String beforeOrderBy = "";
        String orderBy = "";
        String editedNuxeoRequest = nuxeoRequest;
        try {
            Pattern ressourceExp = QUERY_FILTER_PATTERN;
            Matcher m = ressourceExp.matcher(editedNuxeoRequest.toUpperCase());
            m.matches();
            if (m.groupCount() == 3) {
                beforeOrderBy = editedNuxeoRequest.substring(0, m.group(1).length());
                orderBy = editedNuxeoRequest.substring(m.group(1).length());
            }
        }
        catch (IllegalStateException e) {
            beforeOrderBy = editedNuxeoRequest;
        }
        String finalRequest = beforeOrderBy;
        if (finalRequest.length() > 0) {
            finalRequest = "(" + finalRequest + ") AND ";
        }
        finalRequest = finalRequest + "(" + requestFilter + ") ";
        editedNuxeoRequest = finalRequest = finalRequest + " " + orderBy;
        return editedNuxeoRequest;
    }

    public String addSearchFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        StringBuilder filter = new StringBuilder();
        filter.append(" ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
        filter.append(" AND ecm:mixinType <> 'isLocalPublishLive'");
        return this.addExtraNxQueryFilters(ctx, nuxeoRequest, requestFilteringPolicy, filter.toString());
    }

    public String getExtraRequestFilter(CMSServiceCtx ctx, String requestFilteringPolicy) throws Exception {
        String extraRequetFilter = null;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.EXTRA_REQUEST_FILTER);
            Documents configs = null;
            configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            if (configs.size() > 0) {
                extraRequetFilter = "";
                int i = 0;
                for (Document config : configs) {
                    String nxqlCode = config.getProperties().getString("wconf:code");
                    if (nxqlCode == null) continue;
                    if (i > 0) {
                        extraRequetFilter = extraRequetFilter.concat("OR");
                    }
                    extraRequetFilter = extraRequetFilter.concat(" ").concat(nxqlCode);
                    ++i;
                }
            }
        }
        return extraRequetFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformHTMLContent(CMSServiceCtx ctx, String htmlContent) throws Exception {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Transformer transformer = WysiwygParser.getInstance().getTemplate().newTransformer();
            transformer.setParameter("bridge", new XSLFunctions((INuxeoCustomizer)this, ctx));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XMLReader parser = WysiwygParser.getInstance().getParser();
            transformer.transform(new SAXSource(parser, new InputSource(new StringReader(htmlContent))), new StreamResult(output));
            String string = ((Object)output).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public String transformLink(CMSServiceCtx ctx, String link) {
        XSLFunctions xslFunctions = new XSLFunctions((INuxeoCustomizer)this, ctx);
        return xslFunctions.link(link);
    }

    public Link getLinkFromNuxeoURL(CMSServiceCtx cmsContext, String url) {
        return this.getLinkFromNuxeoURL(cmsContext, url, null);
    }

    public Link getLinkFromNuxeoURL(CMSServiceCtx cmsContext, String url, String displayContext) {
        Link link;
        String anchor;
        Page page;
        Window window;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        String currentPagePath = null;
        if (cmsContext.getRequest() != null && (window = (Window)cmsContext.getRequest().getAttribute("osivia.window")) != null && (page = window.getPage()) != null) {
            currentPagePath = page.getId().toString(PortalObjectPath.CANONICAL_FORMAT);
        }
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/")) {
            String nuxeoURL = StringUtils.substringBefore((String)url, (String)"#");
            anchor = StringUtils.substringAfter((String)url, (String)"#");
            String cmsPath = this.transformNuxeoURL(cmsContext, nuxeoURL);
            String portalURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, currentPagePath, cmsPath, null, null, displayContext, null, null, null, null);
            if (StringUtils.isNotBlank((String)anchor)) {
                portalURL = portalURL + "#" + anchor;
            }
            link = new Link(portalURL, false);
        } else if (StringUtils.startsWith((String)url, (String)"/")) {
            String relativeUrl = StringUtils.substringBefore((String)url, (String)"#");
            anchor = StringUtils.substringAfter((String)url, (String)"#");
            ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
            ServerInvocationContext serverContext = controllerContext.getServerInvocation().getServerContext();
            String contextPath = serverContext.getPortalContextPath();
            if (StringUtils.startsWith((String)relativeUrl, (String)(StringUtils.removeEnd((String)contextPath, (String)"/auth") + "/"))) {
                String portalUrl = this.portalUrlFactory.adaptPortalUrlToNavigation(portalControllerContext, relativeUrl);
                if (StringUtils.isNotBlank((String)anchor)) {
                    portalUrl = portalUrl + "#" + anchor;
                }
                link = new Link(portalUrl, false);
            } else {
                link = new Link(url, true);
            }
        } else if (StringUtils.isBlank((String)url)) {
            link = new Link("#", false);
        } else {
            boolean external;
            StringBuilder builder = new StringBuilder();
            if (!StringUtils.startsWithIgnoreCase((String)url, (String)"http://") && !StringUtils.startsWithIgnoreCase((String)url, (String)"https://")) {
                builder.append("http://");
            }
            builder.append(url);
            String absoluteURL = builder.toString();
            try {
                URL urlObject = new URL(absoluteURL);
                String serverName = cmsContext.getRequest().getServerName();
                external = !StringUtils.equals((String)urlObject.getHost(), (String)serverName);
            }
            catch (Exception e) {
                external = false;
            }
            link = new Link(absoluteURL, external);
        }
        return link;
    }

    private String transformNuxeoURL(CMSServiceCtx cmsContext, String url) {
        String cmsPath = null;
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/web/")) {
            String webId = StringUtils.removeStart((String)url, (String)"/nuxeo/web/");
            if (webId.contains("/")) {
                webId = StringUtils.substringAfterLast((String)webId, (String)"/");
            }
            if (webId.contains(".")) {
                webId = StringUtils.substringBefore((String)webId, (String)".");
            }
            cmsPath = this.webIdService.webIdToCmsPath(webId);
        } else if (StringUtils.startsWith((String)url, (String)"/nuxeo/nxpath/")) {
            cmsPath = StringUtils.removeStart((String)url, (String)"/nuxeo/nxpath/");
            cmsPath = "/" + StringUtils.substringAfter((String)cmsPath, (String)"/");
        }
        if (cmsPath == null) {
            this.log.warn((Object)("Invalid Nuxeo URL: '" + url + "'."));
        }
        return cmsPath;
    }

    public Map<String, DocumentType> getCMSItemTypes() {
        return this.getDocumentTypes();
    }

    public Map<String, DocumentType> getDocumentTypes() {
        return this.pluginManager.customizeCMSItemTypes();
    }

    protected List<DocumentType> getCustomizedCMSItemTypes() {
        return new ArrayList<DocumentType>();
    }

    public List<DocumentType> getDefaultCMSItemTypes() {
        ArrayList<DocumentType> defaultTypes = new ArrayList<DocumentType>();
        DocumentType workspace = DocumentType.createRoot((String)"Workspace");
        workspace.addSubtypes(new String[]{"Folder", "Note", "Room"});
        workspace.setIcon("glyphicons glyphicons-filetypes-folder-users");
        workspace.setPreventedCreation(true);
        workspace.setTemplate("/default/templates/workspace");
        defaultTypes.add(workspace);
        DocumentType portalSite = DocumentType.createRoot((String)"PortalSite");
        portalSite.addSubtypes(new String[]{"File", "PortalPage", "ContextualLink", "Note"});
        portalSite.setIcon("glyphicons glyphicons-basic-globe");
        portalSite.setEditable(true);
        defaultTypes.add(portalSite);
        DocumentType portalPage = DocumentType.createNode((String)"PortalPage");
        portalPage.addSubtypes(new String[]{"File", "PortalPage", "ContextualLink", "Note"});
        portalPage.setIcon("glyphicons glyphicons-basic-passport");
        portalPage.setEditable(true);
        portalPage.setMovable(true);
        portalPage.setOrdered(true);
        portalPage.setForceContextualization(true);
        defaultTypes.add(portalPage);
        DocumentType folder = DocumentType.createNode((String)"Folder");
        folder.addSubtypes(new String[]{"File", "Folder", "Note"});
        folder.setIcon("glyphicons glyphicons-basic-folder");
        folder.setEditable(true);
        folder.setMovable(true);
        folder.setTemplate("/default/templates/folder");
        defaultTypes.add(folder);
        DocumentType orderedFolder = DocumentType.createNode((String)"OrderedFolder");
        orderedFolder.addSubtypes(new String[]{"File", "Folder", "Note"});
        orderedFolder.setIcon("glyphicons glyphicons-basic-folder");
        orderedFolder.setEditable(true);
        orderedFolder.setMovable(true);
        orderedFolder.setOrdered(true);
        defaultTypes.add(orderedFolder);
        DocumentType file = DocumentType.createFile((String)"File");
        file.setIcon("glyphicons glyphicons-basic-file");
        file.setEditable(true);
        file.setMovable(true);
        defaultTypes.add(file);
        DocumentType note = DocumentType.createLeaf((String)"Note");
        note.setIcon("glyphicons glyphicons-basic-notes");
        note.setEditable(true);
        note.setMovable(true);
        defaultTypes.add(note);
        DocumentType contextualLink = DocumentType.createLeaf((String)"ContextualLink");
        contextualLink.setIcon("glyphicons glyphicons-basic-link");
        contextualLink.setEditable(true);
        contextualLink.setMovable(true);
        defaultTypes.add(contextualLink);
        DocumentType room = DocumentType.createNode((String)"Room");
        room.addSubtypes(new String[]{"Folder", "Note", "Room"});
        room.setIcon("glyphicons glyphicons-basic-three-dimensional-full");
        room.setOrdered(true);
        room.setPreventedCreation(true);
        room.setTemplate("/default/templates/room");
        defaultTypes.add(room);
        DocumentType staple = DocumentType.createLeaf((String)"Staple");
        staple.setIcon("glyphicons glyphicons-filetypes-file-settings");
        staple.setNavigable(true);
        defaultTypes.add(staple);
        return defaultTypes;
    }

    public Map<String, FileMimeType> getFileMimeTypes() throws IOException {
        if (this.fileMimeTypes == null) {
            this.loadFileMimeTypes();
        }
        return this.fileMimeTypes;
    }

    private synchronized void loadFileMimeTypes() throws IOException {
        if (this.fileMimeTypes == null) {
            InputStream input = this.getClass().getResourceAsStream("/mime-types.csv");
            CSVParser parser = CSVParser.parse((InputStream)input, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));
            int count = Long.valueOf(parser.getRecordNumber()).intValue();
            ConcurrentHashMap<String, FileMimeType> map = new ConcurrentHashMap<String, FileMimeType>(count);
            for (CSVRecord record : parser) {
                MimeType mimeTypeObject;
                String mimeType = record.get("mime-type");
                try {
                    mimeTypeObject = new MimeType(mimeType);
                }
                catch (MimeTypeParseException e) {
                    mimeTypeObject = null;
                    this.log.error((Object)e.getMessage(), e.getCause());
                }
                if (mimeTypeObject == null) continue;
                FileMimeType fileMimeType = new FileMimeType();
                fileMimeType.setMimeType(mimeTypeObject);
                fileMimeType.setExtension(record.get("extension"));
                fileMimeType.setDescription(record.get("description"));
                fileMimeType.setDisplay(record.get("display"));
                fileMimeType.setIcon(record.get("icon"));
                fileMimeType.setPdfConvertible(Boolean.parseBoolean(record.get("pdfConvertible")));
                fileMimeType.setHideExtension(Boolean.parseBoolean(record.get("hideExtension")));
                map.put(mimeType, fileMimeType);
            }
            this.fileMimeTypes = map;
        }
    }

    public FileMimeType getFileMimeType(String mimeType) throws IOException {
        FileMimeType result;
        if (StringUtils.isEmpty((String)mimeType)) {
            result = null;
        } else {
            Map mimeTypes = this.getFileMimeTypes();
            result = (FileMimeType)mimeTypes.get(mimeType);
            if (result == null) {
                try {
                    MimeType mimeTypeObject = new MimeType(mimeType);
                    MimeType genericMimeTypeObject = new MimeType(mimeTypeObject.getPrimaryType(), "*");
                    String genericMimeType = genericMimeTypeObject.getBaseType();
                    result = (FileMimeType)mimeTypes.get(genericMimeType);
                }
                catch (MimeTypeParseException e) {
                    this.log.error((Object)e.getMessage(), e.getCause());
                }
            }
        }
        return result;
    }

    public String getCommentsHTMLContent(CMSServiceCtx cmsContext, Document document) throws CMSException {
        List comments = this.getNuxeoCommentsService().getDocumentComments(cmsContext, document);
        CommentsFormatter formatter = new CommentsFormatter(comments);
        Locale locale = cmsContext.getRequest().getLocale();
        return formatter.generateHTMLContent(locale);
    }

    public String getContentWebIdPath(CMSServiceCtx cmsCtx) {
        return this.getContentWebIdPath(cmsCtx, null, null);
    }

    public String getContentWebIdPath(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos) {
        Document document = (Document)cmsCtx.getDoc();
        String path = document.getPath();
        String webId = DocumentHelper.getWebId((Document)document);
        boolean forceCmsPath = false;
        if (StringUtils.isNotBlank((String)webId)) {
            if (pubInfos != null) {
                if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsCtx, (CMSPublicationInfos)pubInfos) && StringUtils.equals((String)"permLinkCtx", (String)cmsCtx.getDisplayContext())) {
                    if (extendedInfos != null && StringUtils.isNotEmpty((String)extendedInfos.getParentWebId())) {
                        webId = webId.concat("_c_").concat(extendedInfos.getParentWebId());
                    } else {
                        forceCmsPath = true;
                    }
                }
            } else {
                forceCmsPath = ContextDocumentsHelper.isRemoteProxy((Document)document);
            }
            if (!forceCmsPath) {
                path = this.getWebIdService().webIdToCmsPath(webId);
            }
        }
        return path;
    }

    public Link getUserAvatar(String username) {
        return this.getUserAvatar(username, true);
    }

    public Link getUserAvatar(String username, boolean checkCache) {
        StringBuilder url = new StringBuilder();
        List modules = this.pluginManager.getAvatarModules();
        if (CollectionUtils.isNotEmpty((Collection)modules)) {
            Iterator iterator = modules.iterator();
            while (url.length() == 0 && iterator.hasNext()) {
                AvatarModule module = (AvatarModule)iterator.next();
                String customizedUrl = module.getUrl(username);
                if (!StringUtils.isNotEmpty((String)customizedUrl)) continue;
                url.append(customizedUrl);
            }
        }
        if (url.length() == 0) {
            AvatarInfo avatar = AvatarUtils.getAvatar((String)username, (boolean)checkCache);
            String genericResource = System.getProperty("osivia.avatar.generic.resource");
            if (StringUtils.isNotEmpty((String)genericResource) && (avatar == null || BooleanUtils.isTrue((Boolean)avatar.getGenericResource()))) {
                url.append(genericResource);
            } else {
                url.append(AVATAR_SERVLET);
                try {
                    url.append(URLEncoder.encode(username, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e);
                }
                if (avatar != null) {
                    url.append("&t=");
                    url.append(avatar.getTimeStamp());
                }
            }
        }
        return new Link(url.toString(), false);
    }

    public Link getUserAvatar(CMSServiceCtx cmsCtx, String username) throws CMSException {
        return this.getUserAvatar(username, false);
    }

    public String refreshUserAvatar(String username) {
        return AvatarUtils.refreshUserAvatar((String)username);
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        return this.refreshUserAvatar(username);
    }

    public boolean isPathInLiveState(CMSServiceCtx cmsCtx, Document doc) {
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            return true;
        }
        return doc.getPath().equals(cmsCtx.getForcedLivePath());
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        String id = cmsCtx.getServletRequest().getSession().getId();
        Map delegationMap = (Map)this.delegations.get(id);
        if (delegationMap != null) {
            return (BinaryDelegation)delegationMap.get(path);
        }
        return null;
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws CMSException {
        Document document = binary.getDocument() == null ? null : (Document)binary.getDocument();
        String src = "";
        String path = "";
        boolean liveState = false;
        BinaryDelegation delegation = new BinaryDelegation();
        try {
            boolean reload;
            Date date;
            String portalName = null;
            ServerInvocation invocation = cmsCtx.getServerInvocation();
            Boolean isAdmin = false;
            if (invocation != null) {
                portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
                isAdmin = (Boolean)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"osivia.isAdmin");
            }
            if (document != null) {
                path = document.getPath();
                if (BinaryDescription.Type.FILE_OF_VERSION.equals((Object)binary.getType())) {
                    path = document.getId();
                }
                liveState = this.isPathInLiveState(cmsCtx, document);
                delegation.setGrantedAccess(true);
            } else {
                path = binary.getPath();
            }
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            delegation.setSubject(subject);
            delegation.setAdmin(isAdmin.booleanValue());
            if (StringUtils.endsWith((String)path, (String)".proxy") && !StringUtils.endsWith((String)path, (String)".remote.proxy")) {
                path = StringUtils.removeEnd((String)path, (String)".proxy");
            }
            delegation.setUserName(cmsCtx.getServletRequest().getRemoteUser());
            Map delegationMap = this.getUserDelegation(cmsCtx);
            delegationMap.put(path, delegation);
            String fileName = binary.getFileName();
            if (fileName == null) {
                if (document != null && binary.getIndex() == null) {
                    PropertyMap fileMap = document.getProperties().getMap("file:content");
                    if (fileMap != null) {
                        fileName = fileMap.getString("name");
                    }
                } else if (binary.getIndex() != null && cmsCtx.getDoc() != null) {
                    PropertyMap fileMap;
                    int index = NumberUtils.toInt((String)binary.getIndex());
                    Document contextDocument = (Document)cmsCtx.getDoc();
                    PropertyList files = contextDocument.getProperties().getList("files:files");
                    if (files != null && files.size() > index && (fileMap = files.getMap(index)) != null) {
                        fileName = fileMap.getString("filename");
                    }
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(BINARY_SERVLET);
            if (StringUtils.isNotBlank((String)fileName)) {
                sb.append("/").append(URLEncoder.encode(fileName, "UTF-8"));
            }
            sb.append("?type=").append(binary.getType().name()).append("&path=").append(URLEncoder.encode(path, "UTF-8"));
            if (portalName != null) {
                sb.append("&portalName=").append(portalName);
            }
            if (binary.getIndex() != null) {
                sb.append("&index=").append(binary.getIndex());
            }
            if (liveState) {
                sb.append("&liveState=").append(liveState);
            }
            if (binary.getContent() != null) {
                sb.append("&content=").append(binary.getContent());
            }
            if (binary.getFieldName() != null) {
                sb.append("&fieldName=").append(binary.getFieldName());
            }
            if (binary.getFileName() != null) {
                sb.append("&fileName=").append(URLEncoder.encode(binary.getFileName(), "UTF-8"));
            }
            if (cmsCtx.getScope() != null) {
                sb.append("&scope=").append(cmsCtx.getScope());
            }
            if (cmsCtx.getForcePublicationInfosScope() != null) {
                sb.append("&fscope=").append(cmsCtx.getForcePublicationInfosScope());
            }
            long timestamp = System.currentTimeMillis();
            Long modified = document == null ? null : ((date = document.getDate("dc:modified")) == null ? null : Long.valueOf(date.getTime()));
            boolean refreshingPage = PageProperties.getProperties().isRefreshingPage();
            BinaryTimestamp binaryTimestamp = (BinaryTimestamp)this.binaryTimestamps.get(path);
            if (binaryTimestamp == null) {
                binaryTimestamp = new BinaryTimestamp();
                binaryTimestamp.setTimestamp(timestamp);
                binaryTimestamp.setModified(modified);
                binaryTimestamp.setReloadingRequired(true);
                this.binaryTimestamps.put(path, binaryTimestamp);
            }
            if ("pdf:content".equals(binary.getFieldName()) && refreshingPage) {
                reload = true;
            } else if (binaryTimestamp.isReloadingRequired()) {
                reload = true;
                if (timestamp - binaryTimestamp.getTimestamp() > TimeUnit.SECONDS.toMillis(10L)) {
                    binaryTimestamp.setReloadingRequired(false);
                }
            } else if (modified == null) {
                reload = false;
                if (refreshingPage && BinaryDescription.Type.PICTURE.equals((Object)binary.getType())) {
                    binaryTimestamp.setTimestamp(timestamp);
                }
            } else if (binaryTimestamp.getModified() == null) {
                binaryTimestamp.setTimestamp(timestamp);
                binaryTimestamp.setModified(modified);
                binaryTimestamp.setReloadingRequired(true);
                reload = true;
            } else if (Math.abs(binaryTimestamp.getModified() - modified) > TimeUnit.SECONDS.toMillis(1L)) {
                binaryTimestamp.setTimestamp(timestamp);
                binaryTimestamp.setModified(modified);
                binaryTimestamp.setReloadingRequired(true);
                reload = true;
            } else {
                reload = false;
            }
            if (reload) {
                sb.append("&t=");
                sb.append(timestamp);
                sb.append("&reload=true");
            } else {
                sb.append("&t=");
                sb.append(TimeUnit.MILLISECONDS.toSeconds(binaryTimestamp.getTimestamp()));
            }
            src = sb.toString();
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return new Link(src, false);
    }

    private Map<String, BinaryDelegation> getUserDelegation(CMSServiceCtx cmsCtx) {
        String id = cmsCtx.getServletRequest().getSession(true).getId();
        ConcurrentHashMap delegationMap = (ConcurrentHashMap)this.delegations.get(id);
        if (delegationMap == null) {
            delegationMap = new ConcurrentHashMap();
            this.delegations.put(id, delegationMap);
        }
        return delegationMap;
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        this.delegations.remove(sessionEvent.getSession().getId());
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsContext, INuxeoCommand command) throws CMSException {
        try {
            return this.cmsService.executeNuxeoCommand(cmsContext, command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Map<String, EcmCommand> getEcmCommands() {
        ConcurrentHashMap<String, EcmCommand> commands = new ConcurrentHashMap<String, EcmCommand>();
        commands.put(EcmCommonCommands.lock.name(), (EcmCommand)new LockCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.unlock.name(), (EcmCommand)new UnlockCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.subscribe.name(), (EcmCommand)new SubscribeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.unsubscribe.name(), (EcmCommand)new UnsubscribeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.addToQuickAccess.name(), (EcmCommand)new AddToQuickAccessCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.removeFromQuickAccess.name(), (EcmCommand)new RemoveFromQuickAccessCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.synchronizeFolder.name(), (EcmCommand)new SynchronizeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.unsynchronizeFolder.name(), (EcmCommand)new UnsynchronizeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.eraseModifications.name(), (EcmCommand)new EraseModificationsCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.deleteDocument.name(), (EcmCommand)new DeleteDocumentCommand(this.notificationsService, this.internationalizationService));
        return commands;
    }

    public TaskbarItems getDefaultTaskbarItems() throws CMSException {
        TaskbarFactory factory = this.taskbarService.getFactory();
        TaskbarItems taskbarItems = factory.createTaskbarItems();
        TaskbarItem home = factory.createTransversalTaskbarItem("HOME", "HOME_TASK", "glyphicons glyphicons-home", null);
        taskbarItems.add(home);
        TaskbarItem search = factory.createStapledTaskbarItem("SEARCH", "SEARCH_TASK", "glyphicons glyphicons-search", "/default/templates/workspace/search");
        factory.hide(search, true);
        taskbarItems.add(search);
        TaskbarItem documents = factory.createCmsTaskbarItem("DOCUMENTS", "DOCUMENTS_TASK", "glyphicons glyphicons-folder-closed", "Folder");
        factory.preset(documents, true, Integer.valueOf(1));
        taskbarItems.add(documents);
        return taskbarItems;
    }

    protected PanelPlayer getFileBrowserPanelPlayer() {
        PanelPlayer player = new PanelPlayer();
        player.setInstance("toutatice-portail-cms-nuxeo-publishMenuPortletInstance");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.bootstrapPanelStyle", String.valueOf(true));
        properties.put("osivia.cms.template", "fancytree-lazy");
        properties.put("osivia.cms.startLevel", String.valueOf(2));
        properties.put("osivia.cms.forceNavigation", String.valueOf(true));
        player.setProperties(properties);
        return player;
    }

    public String getJSPName(String name, PortletContext portletContext, PortletRequest request) throws CMSException {
        try {
            CustomizedJsp customizedPage = this.pluginManager.customizeJSP(name, portletContext, request);
            String customizedName = customizedPage != null ? customizedPage.getName() : null;
            return customizedName;
        }
        catch (IOException e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Collection<SetType> getSetTypes() {
        Map mapSetTypes = this.pluginManager.getSetTypes();
        Collection<Object> collectionSetType = new ArrayList<SetType>();
        if (mapSetTypes != null) {
            collectionSetType = mapSetTypes.values();
        }
        return collectionSetType;
    }

    public String getTarget(DocumentDTO document) {
        if (System.getProperty(TABS_PROPERTY) != null && "true".equals(System.getProperty(TABS_PROPERTY))) {
            Object spaceUuid = document.getProperties().get("ttc:spaceUuid");
            if (spaceUuid != null) {
                return spaceUuid.toString();
            }
            return null;
        }
        return null;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public Map<String, Map<String, BinaryDelegation>> getDelegations() {
        return this.delegations;
    }

    public Map<String, INuxeoPlayerModule> getPlayers() {
        return this.players;
    }

    public Map<String, PanelPlayer> getNavigationPanelPlayers() {
        return this.navigationPanelPlayers;
    }

    public CustomizationPluginMgr getPluginManager() {
        return this.pluginManager;
    }

    public NuxeoConnectionProperties getNuxeoConnection() {
        return this.nuxeoConnection;
    }

    public UserPagesLoader getUserPagesLoader() {
        return this.userPagesLoader;
    }

    public MenuBarFormater getMenubarFormater() {
        return this.menubarFormater;
    }

    public BrowserAdapter getBrowserAdapter() {
        return this.browserAdapter;
    }

    public NavigationItemAdapter getNavigationItemAdapter() {
        return this.navigationItemAdapter;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public XMLReader getParser() {
        return this.parser;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        return this.portalUrlFactory;
    }

    public IWebIdService getWebIdService() {
        return this.webIdService;
    }

    public IWebUrlService getWebUrlService() {
        return this.webUrlService;
    }

    public ITaskbarService getTaskbarService() {
        return this.taskbarService;
    }

    public ICustomizationService getCustomizationService() {
        return this.customizationService;
    }

    public INuxeoCommentsService getNuxeoCommentsService() {
        return this.nuxeoCommentsService;
    }

    public IInternationalizationService getInternationalizationService() {
        return this.internationalizationService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }

    public INotificationsService getNotificationsService() {
        return this.notificationsService;
    }

    public List<Document> getUserWorkspaces(CMSServiceCtx cmsContext, String userName) throws CMSException {
        List listItem = this.browserAdapter.getUserWorkspaces(cmsContext, userName);
        ArrayList<Document> listDocument = new ArrayList<Document>();
        for (CMSItem item : listItem) {
            if (!(item.getNativeItem() instanceof Document)) continue;
            listDocument.add((Document)item.getNativeItem());
        }
        return listDocument;
    }

    public List<IPortletModule> getDocumentModules(String type) {
        return this.pluginManager.getDocumentModules(type);
    }
}

