/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.RemotePublishedDocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.liveedit.OnlyofficeLiveEditHelper;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceInvocationHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.CommentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.RemotePublishedDocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.avatar.AvatarServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.binaries.BinaryServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.document.GetPublishedDocumentsInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.InlineEditionCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.ShareLinkActivationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.FormsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.site.SitePictureServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.thumbnail.ThumbnailServlet;
import fr.toutatice.portail.cms.nuxeo.service.tag.NuxeoTagService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.IEcmCommandervice;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class ViewDocumentPortlet
extends CMSPortlet {
    public static final String PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String ONLY_DESCRIPTION_WINDOW_PROPERTY = "osivia.document.onlyDescription";
    public static final String ONLY_REMOTE_SECTIONS_WINDOW_PROPERTY = "osivia.document.onlyRemoteSections";
    public static final String REMOTE_SECTIONS_PAGE_WINDOW_PROPERTY = "osivia.document.remoteSectionsPage";
    public static final String HIDE_METADATA_WINDOW_PROPERTY = "osivia.cms.hideMetaDatas";
    public static final String HIDE_ATTACHMENTS_WINDOW_PROPERTY = "osivia.document.hideAttachments";
    private static final String HOST_JOKER = "__HOST__";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/document/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/document/view.jsp";
    private final IBundleFactory bundleFactory;
    private final INotificationsService notificationsService;
    private final DocumentDAO documentDao;
    private final CommentDAO commentDao;
    private final RemotePublishedDocumentDAO publishedDocumentsDao;
    private CMSService cmsService;
    private INuxeoService nuxeoService;

    public ViewDocumentPortlet() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
        this.documentDao = DocumentDAO.getInstance();
        this.commentDao = CommentDAO.getInstance();
        this.publishedDocumentsDao = RemotePublishedDocumentDAO.getInstance();
    }

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        try {
            this.nuxeoService = (INuxeoService)portletContext.getAttribute("NuxeoService");
            if (this.nuxeoService == null) {
                throw new PortletException("Cannot start ViewDocumentPortlet portlet due to service unavailability");
            }
            this.cmsService = new CMSService(portletContext);
            ICMSServiceLocator cmsLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            cmsLocator.register((ICMSService)this.cmsService);
            CMSCustomizer customizer = new CMSCustomizer(portletContext, this.cmsService);
            this.cmsService.setCustomizer((DefaultCMSCustomizer)customizer);
            this.nuxeoService.registerCMSCustomizer((INuxeoCustomizer)customizer);
            NuxeoTagService tagService = new NuxeoTagService();
            this.registerService((Object)this.nuxeoService.getTagService(), (Object)tagService);
            FormsServiceImpl formsService = new FormsServiceImpl((DefaultCMSCustomizer)customizer);
            this.registerService((Object)this.nuxeoService.getFormsService(), (Object)formsService);
            IEcmCommandervice ecmCmdService = (IEcmCommandervice)Locator.findMBean(IEcmCommandervice.class, (String)"osivia:service=EcmCommandService");
            for (EcmCommand command : customizer.getEcmCommands().values()) {
                ecmCmdService.registerCommand(command.getCommandName(), command);
            }
            ThumbnailServlet.setPortletContext((PortletContext)portletContext);
            SitePictureServlet.setPortletContext((PortletContext)portletContext);
            AvatarServlet.setPortletContext((PortletContext)portletContext);
            BinaryServlet.setPortletContext((PortletContext)portletContext);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void registerService(Object proxy, Object instance) {
        NuxeoServiceInvocationHandler invocationHandler = (NuxeoServiceInvocationHandler)Proxy.getInvocationHandler(proxy);
        invocationHandler.setInstance(instance);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                String path = request.getParameter("path");
                window.setProperty(PATH_WINDOW_PROPERTY, path);
                String onlyDescription = request.getParameter("onlyDescription");
                window.setProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY, onlyDescription);
                boolean displayMetadata = BooleanUtils.toBoolean((String)request.getParameter("metadata"));
                window.setProperty(HIDE_METADATA_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayMetadata, null, (String)"1"));
                boolean displayAttachments = BooleanUtils.toBoolean((String)request.getParameter("attachments"));
                window.setProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayAttachments, null, (String)"1"));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            this.processCommentAction(request, response);
            this.processInlineEditionAction(request, response);
            this.processCancelInlineEditionAction(request, response);
            this.processLinkActivationAction(request, response);
        }
        List modules = this.getModules(nuxeoController);
        if (CollectionUtils.isNotEmpty((Collection)modules)) {
            for (IPortletModule module : modules) {
                module.processAction(portalControllerContext);
            }
        }
    }

    private void processLinkActivationAction(ActionRequest request, ActionResponse response) {
        String action = request.getParameter("javax.portlet.action");
        if ("link-activation".equals(action)) {
            boolean activation = BooleanUtils.toBoolean((String)request.getParameter("activate"));
            PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = nuxeoController.getComputedPath(window.getProperty(PATH_WINDOW_PROPERTY));
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
            Document document = documentContext.getDocument();
            ShareLinkActivationCommand command = new ShareLinkActivationCommand(document, activation);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            documentContext.reload();
            StringBuilder message = new StringBuilder();
            if (activation) {
                message.append(bundle.getString("DOCUMENT_SHARE_ACTIVATION_SUCCESS"));
            } else {
                message.append(bundle.getString("DOCUMENT_SHARE_DEACTIVATION_SUCCESS"));
            }
            NotificationsType notificationType = NotificationsType.SUCCESS;
            this.notificationsService.addSimpleNotification(portalControllerContext, message.toString(), notificationType);
        }
    }

    private void processInlineEditionAction(ActionRequest request, ActionResponse response) throws PortletException {
        String property;
        String action = request.getParameter("javax.portlet.action");
        if ("inline-edition".equals(action) && StringUtils.isNotEmpty((String)(property = request.getParameter("property")))) {
            PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = nuxeoController.getComputedPath(window.getProperty(PATH_WINDOW_PROPERTY));
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
            Document document = documentContext.getDocument();
            String[] values = request.getParameterValues("inline-values");
            String cancelUrl = request.getParameter("cancel-url");
            String warnMessage = request.getParameter("warn-message");
            if (StringUtils.isNotEmpty((String)cancelUrl)) {
                PortletSession session = request.getPortletSession();
                session.setAttribute("inline-edition.property", (Object)property);
                session.setAttribute("inline-edition.previous-values", document.getProperties().get(property));
            }
            InlineEditionCommand command = new InlineEditionCommand(path, property, values);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            documentContext.reload();
            request.setAttribute("osivia.ajax.preventRefresh", (Object)true);
            StringBuilder message = new StringBuilder();
            message.append(bundle.getString("DOCUMENT_INLINE_EDITION_SUCCESS"));
            if (StringUtils.isNotEmpty((String)warnMessage)) {
                message.append("<br>");
                message.append(warnMessage);
            }
            if (StringUtils.isNotEmpty((String)cancelUrl)) {
                message.append("<br>");
                message.append(bundle.getString("DOCUMENT_INLINE_EDITION_CANCEL", new Object[]{cancelUrl}));
            }
            NotificationsType notificationType = StringUtils.isNotEmpty((String)warnMessage) ? NotificationsType.WARNING : NotificationsType.SUCCESS;
            this.notificationsService.addSimpleNotification(portalControllerContext, message.toString(), notificationType);
        }
    }

    private void processCancelInlineEditionAction(ActionRequest request, ActionResponse response) throws PortletException {
        String action = request.getParameter("javax.portlet.action");
        if ("cancel-inline-edition".equals(action)) {
            PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
            PortletSession session = request.getPortletSession();
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            String property = (String)session.getAttribute("inline-edition.property");
            if (StringUtils.isEmpty((String)property)) {
                String message = bundle.getString("DOCUMENT_INLINE_EDITION_CANCEL_ERROR");
                this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
            } else {
                String[] values;
                NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String path = nuxeoController.getComputedPath(window.getProperty(PATH_WINDOW_PROPERTY));
                Object object = session.getAttribute("inline-edition.previous-values");
                if (object == null) {
                    values = null;
                } else if (object instanceof PropertyList) {
                    PropertyList propertyList = (PropertyList)object;
                    values = new String[propertyList.size()];
                    for (int i = 0; i < propertyList.size(); ++i) {
                        values[i] = propertyList.getString(i);
                    }
                } else {
                    String value = String.valueOf(object);
                    values = new String[]{value};
                }
                InlineEditionCommand command = new InlineEditionCommand(path, property, values);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                documentContext.reload();
                String message = bundle.getString("DOCUMENT_INLINE_EDITION_CANCEL_SUCCESS");
                this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.INFO);
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
        boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
        request.setAttribute("onlyDescription", (Object)onlyDescription);
        boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(HIDE_METADATA_WINDOW_PROPERTY), null, (String)"1");
        request.setAttribute("metadata", (Object)metadata);
        boolean attachments = BooleanUtils.toBoolean((String)window.getProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY), null, (String)"1");
        request.setAttribute("attachments", (Object)attachments);
        List modules = this.getModules(nuxeoController);
        if (CollectionUtils.isNotEmpty((Collection)modules)) {
            for (IPortletModule module : modules) {
                module.doAdmin(portalControllerContext);
            }
        }
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String theme = window.getPageProperty("theme.id");
            request.setAttribute("theme", (Object)theme);
            String path = window.getProperty(PATH_WINDOW_PROPERTY);
            path = nuxeoController.getComputedPath(path);
            CMSPublicationInfos publicationInfos = this.cmsService.getPublicationInfos(cmsContext, path);
            if (StringUtils.isNotBlank((String)path)) {
                Object extendedDocumentInfos;
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                boolean maximized = WindowState.MAXIMIZED.equals((Object)request.getWindowState());
                boolean onlyRemoteSections = BooleanUtils.toBoolean((String)window.getProperty(ONLY_REMOTE_SECTIONS_WINDOW_PROPERTY));
                request.setAttribute("onlyRemoteSections", (Object)onlyRemoteSections);
                boolean remoteSectionsPage = BooleanUtils.toBoolean((String)window.getProperty(REMOTE_SECTIONS_PAGE_WINDOW_PROPERTY));
                request.setAttribute("remoteSectionsPage", (Object)remoteSectionsPage);
                boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
                if (!maximized) {
                    request.setAttribute("onlyDescription", (Object)onlyDescription);
                }
                boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(HIDE_METADATA_WINDOW_PROPERTY), null, (String)"1");
                request.setAttribute("metadata", (Object)metadata);
                boolean attachments = BooleanUtils.toBoolean((String)window.getProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY), null, (String)"1");
                request.setAttribute("attachments", (Object)attachments);
                Document document = documentContext.getDocument();
                nuxeoController.setCurrentDoc(document);
                String dispatchJsp = window.getProperty("osivia.document.dispatch.jsp");
                if (StringUtils.isEmpty((String)dispatchJsp)) {
                    dispatchJsp = this.getDispatchJspName(nuxeoController, document, null);
                }
                request.setAttribute("dispatchJsp", (Object)dispatchJsp);
                String dispatchExtraJsp = this.getDispatchJspName(nuxeoController, document, "extra");
                request.setAttribute("dispatchExtraJsp", (Object)dispatchExtraJsp);
                String dispatchLayoutJsp = this.getDispatchJspName(nuxeoController, document, "layout");
                request.setAttribute("dispatchLayoutJsp", (Object)dispatchLayoutJsp);
                DocumentDTO documentDto = this.documentDao.toDTO(portalControllerContext, document);
                request.setAttribute("document", (Object)documentDto);
                String title = document.getTitle();
                if (StringUtils.isNotBlank((String)title)) {
                    response.setTitle(documentDto.getDisplayTitle());
                }
                if ((extendedDocumentInfos = this.cmsService.getExtendedDocumentInfos(cmsContext, document.getPath())).isCurrentlyEdited() || extendedDocumentInfos.isRecentlyEdited()) {
                    this.addCurrentlyEditedNotification(nuxeoController, request.getUserPrincipal(), extendedDocumentInfos);
                }
                if (request.getUserPrincipal() != null) {
                    this.handleLiveEdit(request, document.getPath(), documentDto, nuxeoController);
                }
                if (onlyRemoteSections && maximized) {
                    this.generatePublishedDocumentsInfos(nuxeoController, documentContext, documentDto, Boolean.valueOf(true));
                } else if (!onlyDescription || maximized) {
                    nuxeoController.insertContentMenuBarItems();
                    this.generatePublishedDocumentsInfos(nuxeoController, documentContext, documentDto, Boolean.valueOf(false));
                    if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                        boolean commentsEnabled;
                        if (publicationInfos.isLiveSpace()) {
                            extendedDocumentInfos = ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) ? this.cmsService.getExtendedDocumentInfos(cmsContext, document.getPath()) : null;
                            this.addValidationState(document, documentDto, extendedDocumentInfos);
                        }
                        if ((commentsEnabled = this.areCommentsEnabled((ICMSService)this.cmsService, publicationInfos, cmsContext)) && publicationInfos.isCommentableByUser()) {
                            documentDto.setCommentable(true);
                            this.generateComments(nuxeoController, document, documentDto);
                        }
                        this.handleDriveEdition(nuxeoController.getPortalCtx(), document, documentDto, publicationInfos);
                    }
                }
                List modules = this.getModules(document.getType());
                if (CollectionUtils.isNotEmpty((Collection)modules)) {
                    for (IPortletModule module : modules) {
                        module.doView(portalControllerContext);
                    }
                }
                request.setAttribute("isEditableByUser", (Object)publicationInfos.isEditableByUser());
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void handleLiveEdit(RenderRequest request, String path, DocumentDTO documentDto, NuxeoController nuxeoController) throws PortalException {
        boolean isOnlyofficeRegistered = this.cmsService.getCustomizer().getPluginManager().isPluginRegistered("onlyoffice.plugin");
        if (isOnlyofficeRegistered && documentDto.isLiveEditable()) {
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            String onlyofficeEditLockUrl = OnlyofficeLiveEditHelper.getStartOnlyofficePortlerUrl((Bundle)bundle, (String)path, (NuxeoController)nuxeoController, (Boolean)Boolean.TRUE);
            String onlyofficeEditCollabUrl = OnlyofficeLiveEditHelper.getStartOnlyofficePortlerUrl((Bundle)bundle, (String)path, (NuxeoController)nuxeoController, (Boolean)Boolean.FALSE);
            request.setAttribute("onlyofficeEditLockUrl", (Object)onlyofficeEditLockUrl);
            request.setAttribute("onlyofficeEditCollabUrl", (Object)onlyofficeEditCollabUrl);
        }
    }

    private void addCurrentlyEditedNotification(NuxeoController nuxeoController, Principal principal, ExtendedDocumentInfos extendedDocumentInfos) {
        PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        HashSet editingNames = new HashSet();
        HashSet recentlyEditedNames = new HashSet();
        boolean editedByMe = false;
        JSONObject currentlyEditedEntry = extendedDocumentInfos.getCurrentlyEditedEntry();
        this.addDisplayNameToSet(principal, personService, editingNames, currentlyEditedEntry);
        JSONObject recentlyEditedEntry = extendedDocumentInfos.getRecentlyEditedEntry();
        this.addDisplayNameToSet(principal, personService, recentlyEditedNames, recentlyEditedEntry);
        if (this.isEditedByMe(principal, currentlyEditedEntry)) {
            editedByMe = true;
        }
        if (editedByMe) {
            if (editingNames.size() > 0) {
                this.addNotification(nuxeoController.getPortalCtx(), "CURRENTLY_EDITED_BY_OTHERS_AND_I", NotificationsType.WARNING, new Object[]{StringUtils.join(editingNames, (String)", ")});
            } else {
                this.addNotification(nuxeoController.getPortalCtx(), "CURRENTLY_EDITED_BY_ME", NotificationsType.WARNING);
            }
        } else if (editingNames.size() > 0) {
            this.addNotification(nuxeoController.getPortalCtx(), "CURRENTLY_EDITED_BY", NotificationsType.WARNING, new Object[]{StringUtils.join(editingNames, (String)", ")});
        } else if (recentlyEditedNames.size() > 0) {
            this.addNotification(nuxeoController.getPortalCtx(), "RECENTLY_EDITED_BY", NotificationsType.WARNING, new Object[]{StringUtils.join(recentlyEditedNames, (String)", ")});
        }
    }

    private void addDisplayNameToSet(Principal principal, PersonService personService, Set<String> displayNames, JSONObject currentlyEditedEntry) {
        JSONArray usernamesArray;
        if (currentlyEditedEntry != null && (usernamesArray = currentlyEditedEntry.getJSONArray("username")) != null) {
            ListIterator userNamesI = usernamesArray.listIterator();
            while (userNamesI.hasNext()) {
                Person person;
                String userName = (String)userNamesI.next();
                if (principal != null && StringUtils.equals((String)principal.getName(), (String)userName) || (person = personService.getPerson(userName)) == null) continue;
                displayNames.add(person.getDisplayName());
            }
        }
    }

    private boolean isEditedByMe(Principal principal, JSONObject currentlyEditedEntry) {
        JSONArray usernamesArray;
        if (currentlyEditedEntry != null && (usernamesArray = currentlyEditedEntry.getJSONArray("username")) != null) {
            ListIterator userNamesI = usernamesArray.listIterator();
            while (userNamesI.hasNext()) {
                String userName = (String)userNamesI.next();
                if (principal == null || !StringUtils.equals((String)principal.getName(), (String)userName)) continue;
                return true;
            }
        }
        return false;
    }

    private String getDispatchJspName(NuxeoController nuxeoController, Document document, String suffix) throws CMSException {
        INuxeoCustomizer customizer = nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        PortletRequest request = nuxeoController.getRequest();
        String type = StringUtils.lowerCase((String)document.getType());
        StringBuilder path = new StringBuilder();
        path.append("/WEB-INF/jsp/document/view-");
        path.append(type);
        if (StringUtils.isNotEmpty((String)suffix)) {
            path.append("-");
            path.append(suffix);
        }
        path.append(".jsp");
        String name = customizer.getJSPName(path.toString(), this.getPortletContext(), request);
        String realPath = this.getPortletContext().getRealPath(name);
        File file = new File(realPath);
        String dispatchJspName = file.exists() ? type : "default";
        return dispatchJspName;
    }

    private void addValidationState(Document document, DocumentDTO documentDTO, ExtendedDocumentInfos extendedDocumentInfos) {
        String color;
        String icon;
        String key;
        if (extendedDocumentInfos != null && extendedDocumentInfos.isValidationWorkflowRunning()) {
            key = "DOCUMENT_STATE_VALIDATION_IN_PROGRESS";
            icon = "glyphicons glyphicons-hourglass";
            color = "info";
        } else if ("approved".equals(document.getState())) {
            key = "DOCUMENT_STATE_VALID";
            icon = "glyphicons glyphicons-ok";
            color = "success";
        } else {
            key = null;
            icon = null;
            color = null;
        }
        if (key != null) {
            HashMap<String, String> validationState = new HashMap<String, String>();
            validationState.put("key", key);
            validationState.put("icon", icon);
            validationState.put("color", color);
            documentDTO.getProperties().put("validationState", validationState);
        }
    }

    private void generateComments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        GetCommentsCommand getCommentsCommand = new GetCommentsCommand(document);
        JSONArray jsonComments = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getCommentsCommand);
        for (int i = 0; i < jsonComments.size(); ++i) {
            JSONObject jsonComment = jsonComments.getJSONObject(i);
            CommentDTO commentDTO = this.commentDao.toDTO(jsonComment);
            documentDTO.getComments().add(commentDTO);
        }
    }

    protected boolean areCommentsEnabled(ICMSService cmsService, CMSPublicationInfos publicationInfos, CMSServiceCtx cmsContext) throws CMSException {
        boolean enable = true;
        String publishSpacePath = publicationInfos.getPublishSpacePath();
        if (StringUtils.isBlank((String)publishSpacePath)) {
            publishSpacePath = publicationInfos.getDocumentPath();
        }
        if (StringUtils.isNotBlank((String)publishSpacePath)) {
            boolean isPublishSpace;
            CMSItem spaceConfig = cmsService.getSpaceConfig(cmsContext, publishSpacePath);
            Document space = (Document)spaceConfig.getNativeItem();
            boolean bl = isPublishSpace = space.getFacets() != null && space.getFacets().list().contains("TTCPublishSpace");
            if (isPublishSpace) {
                enable = BooleanUtils.toBoolean((String)((String)spaceConfig.getProperties().get("spaceCommentable")));
            }
        }
        return enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generatePublishedDocumentsInfos(NuxeoController nuxeoController, NuxeoDocumentContext docCtx, DocumentDTO documentDTO, Boolean readFilter) {
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_61) && docCtx.getPublicationInfos().isLiveSpace()) {
            int cacheType = nuxeoController.getCacheType();
            int authType = nuxeoController.getAuthType();
            try {
                nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
                GetPublishedDocumentsInfosCommand getPublishedCommand = new GetPublishedDocumentsInfosCommand(docCtx.getDocument(), readFilter);
                JSONArray jsonPublishedDocumentsInfos = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getPublishedCommand);
                for (int index = 0; index < jsonPublishedDocumentsInfos.size(); ++index) {
                    JSONObject publishedDocumentInfos = jsonPublishedDocumentsInfos.getJSONObject(index);
                    RemotePublishedDocumentDTO publishedDocumentDTO = this.publishedDocumentsDao.toDTO(publishedDocumentInfos);
                    documentDTO.getPublishedDocuments().add(publishedDocumentDTO);
                }
            }
            finally {
                nuxeoController.setCacheType(cacheType);
                nuxeoController.setAuthType(authType);
            }
        }
    }

    private void handleDriveEdition(PortalControllerContext portalControllerContext, Document document, DocumentDTO documentDto, CMSPublicationInfos publicationInfos) {
        DocumentType documentType;
        PortletRequest request = portalControllerContext.getRequest();
        if (publicationInfos.isEditableByUser() && (documentType = documentDto.getType()) != null && documentType.isFile()) {
            String driveEditUrl = publicationInfos.getDriveEditURL();
            if (StringUtils.contains((String)driveEditUrl, (String)HOST_JOKER)) {
                String vhost = portalControllerContext.getHttpServletRequest().getHeader("osivia-virtual-host");
                vhost = StringUtils.isBlank((String)vhost) ? request.getScheme() + "/" + request.getServerName() : vhost.replace("://", "/");
                StringBuilder builder = new StringBuilder();
                builder.append(vhost);
                builder.append("/nuxeo");
                driveEditUrl = StringUtils.replace((String)driveEditUrl, (String)HOST_JOKER, (String)builder.toString());
            }
            boolean driveEnabled = BooleanUtils.isTrue((Boolean)publicationInfos.isDriveEnabled());
            if (driveEditUrl != null || driveEnabled) {
                request.setAttribute("driveEditUrl", (Object)driveEditUrl);
                request.setAttribute("driveEnabled", (Object)driveEnabled);
            }
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        super.serveResource(request, response);
        List modules = this.getModules(nuxeoController);
        if (CollectionUtils.isNotEmpty((Collection)modules)) {
            for (IPortletModule module : modules) {
                module.serveResource(portalControllerContext);
            }
        }
    }

    private List<IPortletModule> getModules(NuxeoController nuxeoController) {
        String type;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        if (StringUtils.isBlank((String)(path = nuxeoController.getComputedPath(path)))) {
            type = null;
        } else {
            Document document;
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
            try {
                document = documentContext.getDocument();
            }
            catch (NuxeoException e) {
                document = null;
            }
            type = document == null ? null : document.getType();
        }
        return this.getModules(type);
    }

    private List<IPortletModule> getModules(String type) {
        INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
        List modules = type == null ? null : customizer.getDocumentModules(type);
        return modules;
    }
}

